/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class BucketBackupMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public BucketBackupMessage() {
    }

    private BucketBackupMessage(Set recipients, int regionId, int bucketId) {
        super(recipients, regionId, null);
        this.bucketId = bucketId;
    }

    public static void send(Set recipients, PartitionedRegion r, int bucketId) {
        Assert.assertTrue(recipients != null, "BucketBackupMessage NULL sender list");
        BucketBackupMessage m = new BucketBackupMessage(recipients, r.getPRId(), bucketId);
        r.getDistributionManager().putOutgoing(m);
    }

    @Override
    protected final boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException {
        PartitionedRegionDataStore ds;
        if (pr2 == null || !pr2.isInitialized()) {
            return false;
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "BucketBackupMessage operateOnRegion: {}", pr2.getFullPath());
        }
        if ((ds = pr2.getDataStore()) != null) {
            pr2.getRedundancyProvider().finishIncompleteBucketCreation(this.bucketId);
        } else {
            logger.warn(LocalizedMessage.create(LocalizedStrings.BucketBackupMessage_BUCKETBACKUPMESSAGE_DATA_STORE_NOT_CONFIGURED_FOR_THIS_MEMBER));
        }
        pr2.getPrStats().endPartitionMessagesProcessing(startTime);
        return false;
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public int getDSFID() {
        return 39;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }
}

