/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class AllBucketProfilesUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int prId;
    private int processorId = 0;
    private Map<Integer, BucketAdvisor.BucketProfile> profiles;

    public AllBucketProfilesUpdateMessage() {
    }

    @Override
    public final int getProcessorType() {
        return 77;
    }

    private AllBucketProfilesUpdateMessage(Set recipients, int partitionedRegionId, int processorId, Map<Integer, BucketAdvisor.BucketProfile> profiles) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.prId = partitionedRegionId;
        this.profiles = profiles;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        try {
            PartitionedRegion pr2 = PartitionedRegion.getPRFromId(this.prId);
            for (Map.Entry<Integer, BucketAdvisor.BucketProfile> profile : this.profiles.entrySet()) {
                pr2.getRegionAdvisor().putBucketProfile(profile.getKey(), profile.getValue());
            }
        }
        catch (PRLocallyDestroyedException fre) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region locally destroyed> ///{}", this);
            }
        }
        catch (RegionDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region destroyed> ///{}", this);
            }
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<cache closed> ///{}", this);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        finally {
            if (this.processorId != 0) {
                ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
            }
        }
    }

    public static ReplyProcessor21 send(Set recipients, DM dm, int prId, Map<Integer, BucketAdvisor.BucketProfile> profiles, boolean requireAck) {
        if (recipients.isEmpty()) {
            return null;
        }
        ReplyProcessor21 rp = null;
        int procId = 0;
        if (requireAck) {
            rp = new ReplyProcessor21(dm, (Collection)recipients);
            procId = rp.getProcessorId();
        }
        AllBucketProfilesUpdateMessage m = new AllBucketProfilesUpdateMessage(recipients, prId, procId, profiles);
        dm.putOutgoing(m);
        return rp;
    }

    @Override
    public int getDSFID() {
        return 2124;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.prId = in.readInt();
        this.processorId = in.readInt();
        this.profiles = (Map)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.prId);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.profiles, out);
    }
}

