/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class NewLRUClockHand {
    private static final Logger logger = LogService.getLogger();
    private BucketRegion bucketRegion = null;
    protected LRUClockNode tail = new GuardNode();
    protected LRUClockNode head = new GuardNode();
    protected final HeadLock lock;
    private final LRUStatistics stats;
    private int size = 0;
    public static final boolean debug = Boolean.getBoolean("gemfire.verbose-lru-clock");
    private static final int maxEntries;

    public NewLRUClockHand(Object region, EnableLRU ccHelper, InternalRegionArguments internalRegionArgs) {
        this.setBucketRegion(region);
        this.lock = new HeadLock();
        this.initHeadAndTail();
        if (this.bucketRegion != null) {
            this.stats = internalRegionArgs.getPartitionedRegion() != null ? internalRegionArgs.getPartitionedRegion().getEvictionController().stats : null;
        } else {
            LRUStatistics tmp = null;
            if (region instanceof PlaceHolderDiskRegion) {
                tmp = ((PlaceHolderDiskRegion)region).getPRLRUStats();
            } else if (region instanceof PartitionedRegion) {
                tmp = ((PartitionedRegion)region).getPRLRUStatsDuringInitialization();
                PartitionedRegion pr2 = (PartitionedRegion)region;
                if (tmp != null) {
                    pr2.getEvictionController().stats = tmp;
                }
            }
            if (tmp == null) {
                InternalDistributedSystem sf = GemFireCacheImpl.getExisting("").getDistributedSystem();
                tmp = ccHelper.initStats(region, sf);
            }
            this.stats = tmp;
        }
    }

    public void setBucketRegion(Object r) {
        if (r instanceof BucketRegion) {
            this.bucketRegion = (BucketRegion)r;
        }
    }

    public NewLRUClockHand(Region region, EnableLRU ccHelper, NewLRUClockHand oldList) {
        this.setBucketRegion(region);
        this.lock = new HeadLock();
        this.initHeadAndTail();
        if (oldList.stats == null) {
            DistributedSystem sf = region.getCache().getDistributedSystem();
            this.stats = ccHelper.initStats(region, sf);
        } else {
            this.stats = oldList.stats;
            if (this.bucketRegion != null) {
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.resetCounter();
            } else {
                this.stats.resetCounter();
            }
        }
    }

    public void close() {
        this.closeStats();
        if (this.bucketRegion != null) {
            this.bucketRegion.close();
        }
    }

    public void closeStats() {
        LRUStatistics ls2 = this.stats;
        if (ls2 != null) {
            ls2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendEntry(LRUClockNode aNode) {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            if (aNode.nextLRUNode() != null || aNode.prevLRUNode() != null) {
                return;
            }
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_ADDING_ANODE_TO_LRU_LIST, aNode));
            }
            aNode.setNextLRUNode(this.tail);
            this.tail.prevLRUNode().setNextLRUNode(aNode);
            aNode.setPrevLRUNode(this.tail.prevLRUNode());
            this.tail.setPrevLRUNode(aNode);
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LRUClockNode getHeadEntry() {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            LRUClockNode aNode = this.head.nextLRUNode();
            if (aNode == this.tail) {
                return null;
            }
            LRUClockNode next2 = aNode.nextLRUNode();
            this.head.setNextLRUNode(next2);
            next2.setPrevLRUNode(this.head);
            aNode.setNextLRUNode(null);
            aNode.setPrevLRUNode(null);
            ++this.size;
            return aNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LRUClockNode getLRUEntry() {
        LRUClockNode aNode;
        long numEvals = 0L;
        while (true) {
            aNode = null;
            aNode = this.getHeadEntry();
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                logger.trace(LogMarker.LRU_CLOCK, "lru considering {}", aNode);
            }
            if (aNode == null) {
                this.stats.incEvaluations(numEvals);
                return aNode;
            }
            ++numEvals;
            LRUClockNode lRUClockNode = aNode;
            synchronized (lRUClockNode) {
                if (aNode instanceof AbstractRegionEntry && ((AbstractRegionEntry)((Object)aNode)).isInUseByTransaction()) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_REMOVING_TRANSACTIONAL_ENTRY_FROM_CONSIDERATION));
                    }
                    continue;
                }
                if (aNode.testEvicted()) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_DISCARDING_EVICTED_ENTRY));
                    }
                    continue;
                }
                if (maxEntries > 0 && numEvals > (long)maxEntries) {
                    if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                        logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_GREEDILY_PICKING_AN_AVAILABLE_ENTRY));
                    }
                    this.stats.incGreedyReturns(1L);
                    break block13;
                }
                if (!aNode.testRecentlyUsed()) break;
                aNode.unsetRecentlyUsed();
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                    logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_SKIPPING_RECENTLY_USED_ENTRY, aNode));
                }
                this.appendEntry(aNode);
            }
        }
        {
            block13: {
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
                    logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_RETURNING_UNUSED_ENTRY, aNode));
                }
            }
            this.stats.incEvaluations(numEvals);
            return aNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpList() {
        boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.LRU_CLOCK);
        if (!isDebugEnabled) {
            return;
        }
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            int idx = 1;
            for (LRUClockNode aNode = this.head; aNode != null; aNode = aNode.nextLRUNode()) {
                if (!isDebugEnabled) continue;
                logger.trace(LogMarker.LRU_CLOCK, "  ({}) {}", idx++, aNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpensiveListCount() {
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            long count = 0L;
            for (LRUClockNode aNode = this.head.nextLRUNode(); aNode != this.tail; aNode = aNode.nextLRUNode()) {
                ++count;
            }
            return count;
        }
    }

    public String getAuditReport() {
        int totalNodes = 0;
        int evictedNodes = 0;
        int usedNodes = 0;
        for (LRUClockNode h = this.head; h != null; h = h.nextLRUNode()) {
            ++totalNodes;
            if (h.testEvicted()) {
                ++evictedNodes;
            }
            if (!h.testRecentlyUsed()) continue;
            ++usedNodes;
        }
        StringBuffer result = new StringBuffer(128);
        result.append("LRUList Audit: listEntries = ").append(totalNodes).append(" evicted = ").append(evictedNodes).append(" used = ").append(usedNodes);
        return result.toString();
    }

    public void audit() {
        System.out.println(this.getAuditReport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlinkEntry(LRUClockNode entry) {
        if (logger.isTraceEnabled(LogMarker.LRU_CLOCK)) {
            logger.trace(LogMarker.LRU_CLOCK, LocalizedMessage.create(LocalizedStrings.NewLRUClockHand_UNLINKENTRY_CALLED, entry));
        }
        entry.setEvicted();
        this.stats().incDestroys();
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            LRUClockNode next2 = entry.nextLRUNode();
            LRUClockNode prev = entry.prevLRUNode();
            if (next2 == null || prev == null) {
                return false;
            }
            next2.setPrevLRUNode(prev);
            prev.setNextLRUNode(next2);
            entry.setNextLRUNode(null);
            entry.setPrevLRUNode(null);
        }
        return true;
    }

    public LRUStatistics stats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(RegionVersionVector rvv) {
        if (rvv != null) {
            return;
        }
        HeadLock headLock = this.lock;
        synchronized (headLock) {
            if (this.bucketRegion != null) {
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.resetCounter();
            } else {
                this.stats.resetCounter();
            }
            this.initHeadAndTail();
        }
    }

    private void initHeadAndTail() {
        this.head = new GuardNode();
        this.tail = new GuardNode();
        this.head.setNextLRUNode(this.tail);
        this.tail.setPrevLRUNode(this.head);
        this.size = 0;
    }

    static {
        String squelch = System.getProperty("gemfire.lru.maxSearchEntries");
        maxEntries = squelch == null ? -1 : Integer.parseInt(squelch);
    }

    private static final class GuardNode
    implements LRUClockNode {
        private LRUClockNode next;
        LRUClockNode prev;

        private GuardNode() {
        }

        @Override
        public int getEntrySize() {
            return 0;
        }

        @Override
        public LRUClockNode nextLRUNode() {
            return this.next;
        }

        @Override
        public LRUClockNode prevLRUNode() {
            return this.prev;
        }

        @Override
        public void setEvicted() {
        }

        @Override
        public void setNextLRUNode(LRUClockNode next2) {
            this.next = next2;
        }

        @Override
        public void setPrevLRUNode(LRUClockNode prev) {
            this.prev = prev;
        }

        @Override
        public void setRecentlyUsed() {
        }

        @Override
        public boolean testEvicted() {
            return false;
        }

        @Override
        public boolean testRecentlyUsed() {
            return false;
        }

        @Override
        public void unsetEvicted() {
        }

        @Override
        public void unsetRecentlyUsed() {
        }

        @Override
        public int updateEntrySize(EnableLRU ccHelper) {
            return 0;
        }

        @Override
        public int updateEntrySize(EnableLRU ccHelper, Object value2) {
            return 0;
        }
    }

    protected static class HeadLock {
        protected HeadLock() {
        }
    }
}

