/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Properties;

public final class LRUCapacityController
extends LRUAlgorithm
implements Declarable {
    private static final long serialVersionUID = -4383074909189355938L;
    public static final int DEFAULT_MAXIMUM_ENTRIES = 900;
    public static final String MAXIMUM_ENTRIES = "maximum-entries";
    protected static final StatisticsType statType;
    private volatile int maximumEntries;

    public LRUCapacityController(Region region) {
        this(900, EvictionAction.DEFAULT_EVICTION_ACTION, region);
    }

    public LRUCapacityController(int maximumEntries, Region region) {
        this(maximumEntries, EvictionAction.DEFAULT_EVICTION_ACTION, region);
    }

    public LRUCapacityController(int maximumEntries, EvictionAction evictionAction, Region region) {
        super(evictionAction, region);
        this.setMaximumEntries(maximumEntries);
    }

    public void setMaximumEntries(int maximumEntries) {
        if (maximumEntries <= 0) {
            throw new IllegalArgumentException(LocalizedStrings.LRUCapacityController_MAXIMUM_ENTRIES_MUST_BE_POSITIVE.toLocalizedString());
        }
        this.maximumEntries = maximumEntries;
        if (this.bucketRegion != null) {
            this.bucketRegion.setLimit(this.maximumEntries);
        } else if (this.stats != null) {
            this.stats.setLimit(this.maximumEntries);
        }
    }

    @Override
    public void setLimit(int max) {
        this.setMaximumEntries(max);
    }

    @Override
    public void init(Properties props) throws NumberFormatException {
        String prop = null;
        prop = props.getProperty(MAXIMUM_ENTRIES);
        if (prop != null) {
            this.maximumEntries = Integer.parseInt(prop);
        }
        if ((prop = props.getProperty("eviction-action")) != null) {
            this.setEvictionAction(EvictionAction.parseAction(prop));
        }
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        if (this.evictionAction != EvictionAction.DEFAULT_EVICTION_ACTION) {
            props.setProperty("eviction-action", this.evictionAction.toString());
        }
        if (this.maximumEntries != 900) {
            props.setProperty(MAXIMUM_ENTRIES, String.valueOf(this.maximumEntries));
        }
        return props;
    }

    @Override
    public long getLimit() {
        return this.maximumEntries;
    }

    @Override
    protected EnableLRU createLRUHelper() {
        return new LRUAlgorithm.AbstractEnableLRU(){

            @Override
            public EvictionAlgorithm getEvictionAlgorithm() {
                return EvictionAlgorithm.LRU_ENTRY;
            }

            @Override
            public int entrySize(Object key2, Object value2) throws IllegalArgumentException {
                if (Token.isRemoved(value2)) {
                    return 0;
                }
                if ((value2 == null || value2 == Token.INVALID || value2 == Token.LOCAL_INVALID) && this.getEvictionAction().isOverflowToDisk()) {
                    return 0;
                }
                return 1;
            }

            @Override
            public StatisticsType getStatisticsType() {
                return statType;
            }

            @Override
            public String getStatisticsName() {
                return "LRUStatistics";
            }

            @Override
            public int getLimitStatId() {
                return statType.nameToId("entriesAllowed");
            }

            @Override
            public int getCountStatId() {
                return statType.nameToId("entryCount");
            }

            @Override
            public int getEvictionsStatId() {
                return statType.nameToId("lruEvictions");
            }

            @Override
            public int getDestroysStatId() {
                return statType.nameToId("lruDestroys");
            }

            @Override
            public int getDestroysLimitStatId() {
                return statType.nameToId("lruDestroysLimit");
            }

            @Override
            public int getEvaluationsStatId() {
                return statType.nameToId("lruEvaluations");
            }

            @Override
            public int getGreedyReturnsStatId() {
                return statType.nameToId("lruGreedyReturns");
            }

            @Override
            public boolean mustEvict(LRUStatistics stats, Region region, int delta) {
                return stats.getCounter() + (long)delta > stats.getLimit();
            }
        };
    }

    @Override
    public boolean equals(Object cc) {
        if (!super.equals(cc)) {
            return false;
        }
        if (!(cc instanceof LRUCapacityController)) {
            return false;
        }
        LRUCapacityController other = (LRUCapacityController)cc;
        return this.maximumEntries == other.maximumEntries;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.maximumEntries;
    }

    @Override
    public String toString() {
        return LocalizedStrings.LRUCapacityController_LRUCAPACITYCONTROLLER_WITH_A_CAPACITY_OF_0_ENTRIES_AND_EVICTION_ACTION_1.toLocalizedString(this.getLimit(), this.getEvictionAction());
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String entriesAllowedDesc = "Number of entries allowed in this region.";
        String regionEntryCountDesc = "Number of entries in this region.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.";
        String lruDestroysLimitDesc = "Maximum number of entry destroys triggered by LRU before scan occurs.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("LRUStatistics", "Statistics about entry based Least Recently Used region entry disposal", new StatisticDescriptor[]{f.createLongGauge("entriesAllowed", "Number of entries allowed in this region.", "entries"), f.createLongGauge("entryCount", "Number of entries in this region.", "entries"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.", "entries"), f.createLongGauge("lruDestroysLimit", "Maximum number of entry destroys triggered by LRU before scan occurs.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
    }
}

