/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.locks;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.locks.DLockRecoverGrantorProcessor;
import com.gemstone.gemfire.distributed.internal.locks.DLockRemoteToken;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.locks.TXLockService;
import com.gemstone.gemfire.internal.cache.locks.TXLockServiceImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;

public class TXRecoverGrantorMessageProcessor
implements DLockRecoverGrantorProcessor.MessageProcessor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void process(final DM dm, final DLockRecoverGrantorProcessor.DLockRecoverGrantorMessage msg) {
        try {
            dm.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    TXRecoverGrantorMessageProcessor.this.processDLockRecoverGrantorMessage(dm, msg);
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger.debug("Rejected processing of {}", msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDLockRecoverGrantorMessage(DM dm, DLockRecoverGrantorProcessor.DLockRecoverGrantorMessage msg) {
        ReplyException replyException = null;
        int replyCode = 0;
        DLockRemoteToken[] heldLocks = new DLockRemoteToken[]{};
        if (logger.isDebugEnabled()) {
            logger.debug("[TXRecoverGrantorMessageProcessor.process]");
        }
        boolean gotRecoveryLock = false;
        TXLockServiceImpl dtls = null;
        try {
            Assert.assertTrue(msg.getServiceName().startsWith("DTLS"), "TXRecoverGrantorMessageProcessor cannot handle service " + msg.getServiceName());
            DLockService svc = DLockService.getInternalServiceNamed(msg.getServiceName());
            if (svc != null && (dtls = (TXLockServiceImpl)TXLockService.getDTLS()) != null) {
                dtls.acquireRecoveryWriteLock();
                gotRecoveryLock = true;
                TXCommitMessage.getTracker().waitForAllToProcess();
            }
        }
        catch (InterruptedException t) {
            Thread.currentThread().interrupt();
            logger.warn(LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_TXRECOVERGRANTORMESSAGEPROCESSORPROCESS_THROWABLE), (Throwable)t);
            replyException = new ReplyException(t);
        }
        catch (RuntimeException t) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_TXRECOVERGRANTORMESSAGEPROCESSORPROCESS_THROWABLE), (Throwable)t);
            if (replyException == null) {
                replyException = new ReplyException(t);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_MORE_THAN_ONE_EXCEPTION_THROWN_IN__0, this), (Throwable)t);
            }
        }
        finally {
            if (gotRecoveryLock && dtls != null) {
                dtls.releaseRecoveryWriteLock();
            }
            DLockRecoverGrantorProcessor.DLockRecoverGrantorReplyMessage replyMsg = new DLockRecoverGrantorProcessor.DLockRecoverGrantorReplyMessage();
            replyMsg.setReplyCode(replyCode);
            replyMsg.setHeldLocks(heldLocks);
            replyMsg.setProcessorId(msg.getProcessorId());
            replyMsg.setRecipient(msg.getSender());
            replyMsg.setException(replyException);
            if (msg.getSender().equals(dm.getId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[TXRecoverGrantorMessageProcessor.process] locally process reply");
                }
                replyMsg.setSender(dm.getId());
                replyMsg.dmProcess((DistributionManager)dm);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("[TXRecoverGrantorMessageProcessor.process] send reply");
                }
                dm.putOutgoing(replyMsg);
            }
        }
    }
}

