/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.locks;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.locks.DLockBatch;
import com.gemstone.gemfire.distributed.internal.locks.DLockGrantor;
import com.gemstone.gemfire.distributed.internal.locks.DLockLessorDepartureHandler;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.locks.TXLockBatch;
import com.gemstone.gemfire.internal.cache.locks.TXLockService;
import com.gemstone.gemfire.internal.cache.locks.TXLockServiceImpl;
import com.gemstone.gemfire.internal.cache.locks.TXOriginatorRecoveryProcessor;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;

public class TXLessorDepartureHandler
implements DLockLessorDepartureHandler {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void handleDepartureOf(InternalDistributedMember owner, DLockGrantor grantor) {
        TXLockService dtls = TXLockService.getDTLS();
        if (dtls == null) {
            return;
        }
        try {
            if (!dtls.isLockGrantor()) {
                logger.debug("This member is not lock grantor; exiting TXLessorDepartureHandler");
                return;
            }
            DLockService dlock = ((TXLockServiceImpl)dtls).getInternalDistributedLockService();
            if (grantor == null || grantor.isDestroyed()) {
                logger.debug("Lock grantor does not exist or has been destroyed; exiting TXLessorDepartureHandler");
                return;
            }
            DLockBatch[] batches = grantor.getLockBatches(owner);
            if (batches.length == 0) {
                logger.debug("{} has no active lock batches; exiting TXLessorDepartureHandler", owner);
                return;
            }
            this.sendRecoveryMsgs(dlock.getDistributionManager(), batches, owner, grantor);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    private void sendRecoveryMsgs(final DM dm, final DLockBatch[] batches, final InternalDistributedMember owner, final DLockGrantor grantor) {
        block2: {
            try {
                dm.getWaitingThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < batches.length; ++i) {
                            TXLockBatch batch = (TXLockBatch)batches[i];
                            Set participants = batch.getParticipants();
                            TXOriginatorRecoveryProcessor.sendMessage(participants, owner, batch.getTXLockId(), grantor, dm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Rejected sending recovery messages for departure of tx originator {}", owner, e);
            }
        }
    }
}

