/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public abstract class GFEAbstractQueuedSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private static final AtomicIntegerFieldUpdater<GFEAbstractQueuedSynchronizer> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(GFEAbstractQueuedSynchronizer.class, "state");
    private static final AtomicIntegerFieldUpdater<Node> nodeStatusUpdater = AtomicIntegerFieldUpdater.newUpdater(Node.class, "waitStatus");
    private static final AtomicReferenceFieldUpdater<GFEAbstractQueuedSynchronizer, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(GFEAbstractQueuedSynchronizer.class, Node.class, "head");
    private static final AtomicReferenceFieldUpdater<GFEAbstractQueuedSynchronizer, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(GFEAbstractQueuedSynchronizer.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater<Node, Node> prevNodeUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "prev");
    private static final AtomicReferenceFieldUpdater<Node, Node> nextNodeUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;

    protected GFEAbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int newState) {
        this.state = newState;
    }

    protected final boolean compareAndSetState(int expect, int update) {
        return stateUpdater.compareAndSet(this, expect, update);
    }

    private Node enq(Node node) {
        Node t;
        while (true) {
            if ((t = this.tail) == null) {
                Node h = new Node();
                h.next = node;
                node.prev = h;
                if (!this.compareAndSetHead(h)) continue;
                this.tail = node;
                return h;
            }
            node.prev = t;
            if (this.compareAndSetTail(t, node)) break;
        }
        t.next = node;
        return t;
    }

    private Node addWaiter(Node mode) {
        Node node = new Node(Thread.currentThread(), mode);
        Node pred = this.tail;
        if (pred != null) {
            node.prev = pred;
            if (this.compareAndSetTail(pred, node)) {
                pred.next = node;
                return node;
            }
        }
        this.enq(node);
        return node;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -1, 0);
        Node s = node.next;
        if (s == null || s.waitStatus > 0) {
            s = null;
            Node t = this.tail;
            while (t != null && t != node) {
                if (t.waitStatus <= 0) {
                    s = t;
                }
                t = t.prev;
            }
        }
        if (s != null) {
            LockSupport.unpark(s.thread);
        }
    }

    private void setHeadAndPropagate(Node node, int propagate) {
        Node s;
        this.setHead(node);
        if (propagate > 0 && node.waitStatus != 0 && ((s = node.next) == null || s.isShared())) {
            this.unparkSuccessor(node);
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node pred = node.prev;
        while (pred.waitStatus > 0) {
            node.prev = pred = pred.prev;
        }
        Node predNext = pred.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, pred)) {
            GFEAbstractQueuedSynchronizer.compareAndSetNext(pred, predNext, null);
        } else {
            if (pred != this.head && (pred.waitStatus == -1 || GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(pred, 0, -1)) && pred.thread != null) {
                Node next2 = node.next;
                if (next2 != null && next2.waitStatus <= 0) {
                    GFEAbstractQueuedSynchronizer.compareAndSetNext(pred, predNext, next2);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node pred, Node node) {
        int s = pred.waitStatus;
        if (s < 0) {
            return true;
        }
        if (s > 0) {
            do {
                node.prev = pred = pred.prev;
            } while (pred.waitStatus > 0);
            pred.next = node;
        } else {
            GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(pred, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park();
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, int arg, Object id) {
        try {
            boolean interrupted = false;
            while (true) {
                Node p;
                if ((p = node.predecessor()) == this.head && this.tryAcquire(arg, id)) {
                    this.setHead(node);
                    p.next = null;
                    return interrupted;
                }
                if (!GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
    }

    private void doAcquireInterruptibly(int arg, Object id) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node p;
            do {
                if ((p = node.predecessor()) != this.head || !this.tryAcquire(arg, id)) continue;
                this.setHead(node);
                p.next = null;
                return;
            } while (!GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireNanos(int arg, Object id, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            do {
                Node p;
                if ((p = node.predecessor()) == this.head && this.tryAcquire(arg, id)) {
                    this.setHead(node);
                    p.next = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (nanosTimeout > 1000L && GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node)) {
                    LockSupport.parkNanos(nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private void doAcquireShared(int arg, Object id) {
        Node node = this.addWaiter(Node.SHARED);
        try {
            boolean interrupted = false;
            while (true) {
                int r;
                Node p;
                if ((p = node.predecessor()) == this.head && (r = this.tryAcquireShared(arg, id)) >= 0) {
                    this.setHeadAndPropagate(node, r);
                    p.next = null;
                    if (interrupted) {
                        GFEAbstractQueuedSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
    }

    private void doAcquireSharedInterruptibly(int arg, Object id) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        try {
            Node p;
            do {
                int r;
                if ((p = node.predecessor()) != this.head || (r = this.tryAcquireShared(arg, id)) < 0) continue;
                this.setHeadAndPropagate(node, r);
                p.next = null;
                return;
            } while (!GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireSharedNanos(int arg, Object id, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        Node node = this.addWaiter(Node.SHARED);
        try {
            do {
                int r;
                Node p;
                if ((p = node.predecessor()) == this.head && (r = this.tryAcquireShared(arg, id)) >= 0) {
                    this.setHeadAndPropagate(node, r);
                    p.next = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (nanosTimeout > 1000L && GFEAbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node)) {
                    LockSupport.parkNanos(nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node);
            throw ex;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(int arg, Object id) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int arg, Object id) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int arg, Object id) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int arg, Object id) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int arg, Object id) {
        if (!this.tryAcquire(arg, id) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), arg, id)) {
            GFEAbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int arg, Object id) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(arg, id)) {
            this.doAcquireInterruptibly(arg, id);
        }
    }

    public final boolean tryAcquireNanos(int arg, Object id, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(arg, id) || this.doAcquireNanos(arg, id, nanosTimeout);
    }

    public final boolean release(int arg, Object id) {
        if (this.tryRelease(arg, id)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int arg, Object id) {
        if (this.tryAcquireShared(arg, id) < 0) {
            this.doAcquireShared(arg, id);
        }
    }

    public final void acquireSharedInterruptibly(int arg, Object id) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(arg, id) < 0) {
            this.doAcquireSharedInterruptibly(arg, id);
        }
    }

    public final boolean tryAcquireSharedNanos(int arg, Object id, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(arg, id) >= 0 || this.doAcquireSharedNanos(arg, id, nanosTimeout);
    }

    public final boolean releaseShared(int arg, Object id) {
        if (this.tryReleaseShared(arg, id)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread st;
        Node s;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null || (h = this.head) != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null) {
            return st;
        }
        Node t = this.tail;
        Thread firstThread = null;
        while (t != null && t != this.head) {
            Thread tt = t.thread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.prev;
        }
        return firstThread;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node p = this.tail;
        while (p != null) {
            if (p.thread == thread) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node s;
        Node h = this.head;
        return h != null && (s = h.next) != null && s.nextWaiter != Node.SHARED;
    }

    final boolean isFirst(Thread current) {
        Node s;
        Node h = this.head;
        return h == null || (s = h.next) != null && s.thread == current || this.fullIsFirst(current);
    }

    final boolean fullIsFirst(Thread current) {
        Node s;
        Thread firstThread = null;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (firstThread = s.thread) != null) {
            return firstThread == current;
        }
        Node t = this.tail;
        while (t != null && t != this.head) {
            Thread tt = t.thread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.prev;
        }
        return firstThread == current || firstThread == null;
    }

    public final int getQueueLength() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            if (p.thread != null) {
                ++n;
            }
            p = p.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t = p.thread;
            if (t != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (!p.isShared() && (t = p.thread) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (p.isShared() && (t = p.thread) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public String toString() {
        int s = this.getState();
        String q = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + s + ", " + q + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node t = this.tail;
        while (t != node) {
            if (t == null) {
                return false;
            }
            t = t.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node p = this.enq(node);
        int c = p.waitStatus;
        if (c > 0 || !GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(p, c, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (GFEAbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    private final boolean compareAndSetHead(Node update) {
        return headUpdater.compareAndSet(this, null, update);
    }

    private final boolean compareAndSetTail(Node expect, Node update) {
        return tailUpdater.compareAndSet(this, expect, update);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int expect, int update) {
        return nodeStatusUpdater.compareAndSet(node, expect, update);
    }

    private static final boolean compareAndSetNext(Node node, Node expect, Node update) {
        return nextNodeUpdater.compareAndSet(node, expect, update);
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node p = this.prev;
            if (p == null) {
                throw new NullPointerException();
            }
            return p;
        }

        Node() {
        }

        Node(Thread thread, Node mode) {
            this.nextWaiter = mode;
            this.thread = thread;
        }

        Node(Thread thread, int waitStatus) {
            this.waitStatus = waitStatus;
            this.thread = thread;
        }
    }
}

