/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.cache.ha.HAContainerWrapper;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.HAEventWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HAContainerRegion
implements HAContainerWrapper {
    private Map map;
    private final Map<String, CacheClientProxy> haRegionNameToProxy;

    public HAContainerRegion(Region region) {
        this.map = region;
        this.haRegionNameToProxy = new ConcurrentHashMap<String, CacheClientProxy>();
    }

    @Override
    public ClientProxyMembershipID getProxyID(String haRegionName) {
        CacheClientProxy proxy = this.haRegionNameToProxy.get(haRegionName);
        if (proxy != null) {
            return proxy.getProxyID();
        }
        return null;
    }

    @Override
    public Object putProxy(String haName, CacheClientProxy proxy) {
        return this.haRegionNameToProxy.put(haName, proxy);
    }

    @Override
    public CacheClientProxy getProxy(String haName) {
        return this.haRegionNameToProxy.get(haName);
    }

    @Override
    public Object removeProxy(String haName) {
        return this.haRegionNameToProxy.remove(haName);
    }

    @Override
    public Object getKey(Object key2) {
        Region.Entry entry = ((Region)this.map).getEntry(key2);
        if (entry != null) {
            try {
                return entry.getKey();
            }
            catch (EntryDestroyedException ede) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return ((Region)this.map).getName();
    }

    @Override
    public void cleanUp() {
        try {
            ((Region)this.map).destroyRegion();
        }
        catch (CancelException e) {
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.map.containsValue(value2);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key2) {
        ClientUpdateMessageImpl cum = (ClientUpdateMessageImpl)this.map.get(key2);
        if (cum != null) {
            cum.setEventIdentifier(((HAEventWrapper)key2).getEventId());
            if (cum.hasCqs()) {
                cum.setClientCqs(((HAEventWrapper)key2).getClientCqs());
            }
        }
        return cum;
    }

    @Override
    public Object getEntry(Object key2) {
        Region.Entry entry = ((Region)this.map).getEntry(key2);
        if (entry != null) {
            ClientUpdateMessageImpl cum = (ClientUpdateMessageImpl)entry.getValue();
            cum.setEventIdentifier(((HAEventWrapper)key2).getEventId());
            if (cum.hasCqs()) {
                cum.setClientCqs(((HAEventWrapper)key2).getClientCqs());
            }
        }
        return entry;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key2, Object value2) {
        return this.map.put(key2, value2);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    public Object remove(Object key2) {
        return this.map.remove(key2);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }
}

