/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.extension;

import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.cache.extension.ExtensionPoint;
import com.gemstone.gemfire.internal.util.CollectionUtils;
import java.util.ArrayList;

public class SimpleExtensionPoint<T>
implements ExtensionPoint<T> {
    protected final ArrayList<Extension<T>> extensions = new ArrayList();
    protected final Iterable<Extension<T>> iterable = CollectionUtils.unmodifiableIterable(this.extensions);
    protected final Extensible<T> extensible;
    protected final T target;

    public SimpleExtensionPoint(Extensible<T> extensible, T target) {
        this.extensible = extensible;
        this.target = target;
    }

    @Override
    public Iterable<Extension<T>> getExtensions() {
        return this.iterable;
    }

    @Override
    public void addExtension(Extension<T> extension) {
        this.extensions.add(extension);
    }

    @Override
    public void removeExtension(Extension<T> extension) {
        this.extensions.remove(extension);
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    public void fireCreate(Extensible<T> newTarget) {
        for (Extension<T> extension : this.extensions) {
            extension.onCreate(this.extensible, newTarget);
        }
    }
}

