/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.RebalanceResultsImpl;
import com.gemstone.gemfire.internal.cache.control.RegionFilter;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.CompositeDirector;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class RebalanceOperationImpl
implements RebalanceOperation {
    private static final Logger logger = LogService.getLogger();
    private final boolean simulation;
    private final GemFireCacheImpl cache;
    private Future<RebalanceResults> future;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Object futureLock = new Object();
    private RegionFilter filter;

    RebalanceOperationImpl(GemFireCacheImpl cache, boolean simulation, RegionFilter filter) {
        this.simulation = simulation;
        this.cache = cache;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        final InternalResourceManager manager = this.cache.getResourceManager();
        ScheduledExecutorService ex = manager.getExecutor();
        Object object = this.futureLock;
        synchronized (object) {
            manager.addInProgressRebalance(this);
            this.future = ex.submit(new Callable<RebalanceResults>(){

                @Override
                public RebalanceResults call() {
                    SystemFailure.checkFailure();
                    RebalanceOperationImpl.this.cache.getCancelCriterion().checkCancelInProgress(null);
                    try {
                        RebalanceResults rebalanceResults = RebalanceOperationImpl.this.call();
                        return rebalanceResults;
                    }
                    catch (RuntimeException e) {
                        logger.debug("Unexpected exception in rebalancing: {}", e.getMessage(), e);
                        throw e;
                    }
                    finally {
                        manager.removeInProgressRebalance(RebalanceOperationImpl.this);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebalanceResults call() {
        RebalanceResultsImpl results = new RebalanceResultsImpl();
        ResourceManagerStats stats = this.cache.getResourceManager().getStats();
        long start = stats.startRebalance();
        try {
            for (PartitionedRegion region : this.cache.getPartitionedRegions()) {
                if (this.cancelled.get()) {
                    break;
                }
                try {
                    PartitionedRegionRebalanceOp prOp;
                    if (region.getColocatedWith() != null || !this.filter.include(region)) continue;
                    Set<PartitionRebalanceInfo> detailSet = null;
                    if (region.isFixedPartitionedRegion()) {
                        if (!Boolean.getBoolean("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP")) continue;
                        prOp = new PartitionedRegionRebalanceOp(region, this.simulation, new CompositeDirector(false, false, false, true), true, true, this.cancelled, stats);
                        detailSet = prOp.execute();
                    } else {
                        prOp = new PartitionedRegionRebalanceOp(region, this.simulation, new CompositeDirector(true, true, true, true), true, true, this.cancelled, stats);
                        detailSet = prOp.execute();
                    }
                    for (PartitionRebalanceInfo details : detailSet) {
                        results.addDetails(details);
                    }
                }
                catch (RegionDestroyedException e) {
                }
            }
        }
        finally {
            stats.endRebalance(start);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<RebalanceResults> getFuture() {
        Object object = this.futureLock;
        synchronized (object) {
            return this.future;
        }
    }

    @Override
    public boolean cancel() {
        this.cancelled.set(true);
        if (this.getFuture().cancel(false)) {
            this.cache.getResourceManager().removeInProgressRebalance(this);
        }
        return true;
    }

    @Override
    public RebalanceResults getResults() throws CancellationException, InterruptedException {
        try {
            return this.getFuture().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GemFireException) {
                throw (GemFireException)e.getCause();
            }
            if (e.getCause() instanceof InternalGemFireError) {
                throw (InternalGemFireError)e.getCause();
            }
            throw new InternalGemFireError(e.getCause());
        }
    }

    @Override
    public RebalanceResults getResults(long timeout, TimeUnit unit) throws CancellationException, TimeoutException, InterruptedException {
        try {
            return this.getFuture().get(timeout, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GemFireException) {
                throw (GemFireException)e.getCause();
            }
            if (e.getCause() instanceof InternalGemFireError) {
                throw (InternalGemFireError)e.getCause();
            }
            throw new InternalGemFireError(e.getCause());
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.cancelled.get() || this.getFuture().isDone();
    }

    boolean isSimulation() {
        return this.simulation;
    }
}

