/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryEventType;

public class MemoryEventImpl
implements MemoryEvent {
    public static final MemoryEventImpl UNKOWN = new MemoryEventImpl(MemoryEventType.UNKNOWN, null, 0, 0L, 0L, true, new InternalResourceManager.Thresholds());
    public static final MemoryEventImpl NO_DELIVERY = new MemoryEventImpl(MemoryEventType.UNKNOWN, null, 0, 0L, 0L, true, new InternalResourceManager.Thresholds());
    private final MemoryEventType type;
    private final DistributedMember member;
    private final int currentHeapUsagePercent;
    private final long currentHeapBytesUsed;
    private final boolean isLocal;
    private final long bytesFromThreshold;
    private final InternalResourceManager.Thresholds thresholds;
    private final boolean skipValidation;

    public MemoryEventImpl(MemoryEventType type, DistributedMember member, int currentHeapUsagePercent, long currentHeapBytesUsed, long bytesFromThreshold, boolean isLocal, InternalResourceManager.Thresholds t) {
        assert (type != null);
        this.type = type;
        this.member = member;
        this.currentHeapUsagePercent = currentHeapUsagePercent;
        this.currentHeapBytesUsed = currentHeapBytesUsed;
        this.bytesFromThreshold = bytesFromThreshold;
        this.isLocal = isLocal;
        assert (t != null);
        this.thresholds = t;
        this.skipValidation = false;
    }

    public MemoryEventImpl(MemoryEventImpl event, MemoryEventType overrideType) {
        assert (overrideType != null);
        this.type = overrideType;
        this.member = event.member;
        this.currentHeapUsagePercent = event.currentHeapUsagePercent;
        this.currentHeapBytesUsed = event.currentHeapBytesUsed;
        this.bytesFromThreshold = event.bytesFromThreshold;
        this.isLocal = event.isLocal;
        this.thresholds = event.thresholds;
        this.skipValidation = event.skipValidation;
    }

    public MemoryEventImpl(MemoryEventType type, long currentHeapBytesUsed, DistributedMember member, boolean isLocal, InternalResourceManager.Thresholds t, boolean forcedEvent) {
        this.type = type;
        this.member = member;
        this.currentHeapUsagePercent = 0;
        this.currentHeapBytesUsed = currentHeapBytesUsed;
        this.bytesFromThreshold = 0L;
        this.isLocal = isLocal;
        this.thresholds = t;
        this.skipValidation = forcedEvent;
    }

    public MemoryEventImpl(long currentHeapBytesUsed, DistributedMember member, boolean isLocal, InternalResourceManager.Thresholds t) {
        this.type = MemoryEventType.UNKNOWN;
        this.member = member;
        this.currentHeapUsagePercent = 0;
        this.currentHeapBytesUsed = currentHeapBytesUsed;
        this.bytesFromThreshold = 0L;
        this.isLocal = isLocal;
        this.thresholds = t;
        this.skipValidation = false;
    }

    @Override
    public int getCurrentHeapUsagePercent() {
        return this.currentHeapUsagePercent;
    }

    @Override
    public DistributedMember getMember() {
        return this.member;
    }

    @Override
    public MemoryEventType getType() {
        return this.type;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return "MemoryEvent@" + System.identityHashCode(this) + ("[Member:" + this.member) + (",eventType:" + (Object)((Object)this.type)) + (",currentHeapUsagePercent:" + this.currentHeapUsagePercent) + (",bytesFromThreshold:" + this.bytesFromThreshold) + (",currentHeapBytesUsed:" + this.currentHeapBytesUsed) + (",isLocal:" + this.isLocal) + (",skipValidation:" + this.skipValidation + "]");
    }

    @Override
    public long getBytesFromThreshold() {
        return this.bytesFromThreshold;
    }

    public boolean isDisableEvent() {
        assert (this.type != null);
        return this.type.isDisabledType();
    }

    @Override
    public long getCurrentHeapBytesUsed() {
        return this.currentHeapBytesUsed;
    }

    @Override
    public InternalResourceManager.Thresholds getThresholds() {
        return this.thresholds;
    }

    public boolean skipValidation() {
        return this.skipValidation;
    }
}

