/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinDiskRegionEntryHeap
extends VersionedThinDiskRegionEntry {
    private static final VersionedThinDiskRegionEntryHeapFactory factory = new VersionedThinDiskRegionEntryHeapFactory();

    public VersionedThinDiskRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedThinDiskRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedThinDiskRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

