/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsDiskRegionEntryHeap
extends VersionedStatsDiskRegionEntry {
    private static final VersionedStatsDiskRegionEntryHeapFactory factory = new VersionedStatsDiskRegionEntryHeapFactory();

    public VersionedStatsDiskRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedStatsDiskRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedStatsDiskRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

