/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsDiskLRURegionEntryHeap
extends VersionedStatsDiskLRURegionEntry {
    private static final VersionedStatsDiskLRURegionEntryHeapFactory factory = new VersionedStatsDiskLRURegionEntryHeapFactory();

    public VersionedStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedStatsDiskLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedStatsDiskLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

