/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeap;
import java.util.UUID;

public abstract class VMThinRegionEntryHeap
extends VMThinRegionEntry {
    private static final VMThinRegionEntryHeapFactory factory = new VMThinRegionEntryHeapFactory();

    public VMThinRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMThinRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMThinRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMThinRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinRegionEntryHeap.getEntryFactory();
        }
    }
}

