/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMThinLRURegionEntryHeapStringKey1
extends VMThinLRURegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinLRURegionEntryHeapStringKey1> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinLRURegionEntryHeapStringKey1.class, "lastModified");
    private volatile Object value;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private final long bits1;

    public VMThinLRURegionEntryHeapStringKey1(RegionEntryContext context, String key2, Object value2, boolean byteEncode) {
        super(context, value2);
        long tmpBits1 = 0L;
        if (byteEncode) {
            for (int i = key2.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)((byte)key2.charAt(i) & 0xFF);
                tmpBits1 <<= 8;
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key2.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)key2.charAt(i);
                tmpBits1 <<= 16;
            }
        }
        this.bits1 = tmpBits1 |= (long)key2.length();
    }

    @Override
    protected final Object areGetValue() {
        return this.value;
    }

    @Override
    protected void areSetValue(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController, Object value2) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value2);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public final boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public final void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public final void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public final boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public final void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public final void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public final void setNextLRUNode(LRUClockNode next2) {
        this.nextLRU = next2;
    }

    @Override
    public final LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public final void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public final LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public final int getEntrySize() {
        return this.size;
    }

    protected final void setEntrySize(int size2) {
        this.size = size2;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public final Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

