/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMThinLRURegionEntryHeap
extends VMThinLRURegionEntry {
    private static final VMThinLRURegionEntryHeapFactory factory = new VMThinLRURegionEntryHeapFactory();

    public VMThinLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMThinLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMThinLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMThinLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinLRURegionEntryHeap.getEntryFactory();
        }
    }
}

