/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.AbstractDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMThinDiskRegionEntryHeapIntKey
extends VMThinDiskRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryHeapIntKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryHeapIntKey.class, "lastModified");
    private volatile Object value;
    protected DiskId id;
    private final int key;

    public VMThinDiskRegionEntryHeapIntKey(RegionEntryContext context, int key2, Object value2) {
        super(context, value2 instanceof DiskEntry.RecoveredEntry ? null : value2);
        this.initialize(context, value2);
        this.key = key2;
    }

    @Override
    protected final Object areGetValue() {
        return this.value;
    }

    @Override
    protected void areSetValue(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext context, Object value2) {
        this.diskInitialize(context, value2);
    }

    @Override
    public int updateAsyncEntrySize(EnableLRU capacityController) {
        throw new IllegalStateException("should never be called");
    }

    private void diskInitialize(RegionEntryContext context, Object value2) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value2);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof Integer) {
            return (Integer)k == this.key;
        }
        return false;
    }
}

