/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsRegionEntryHeap
extends VMStatsRegionEntry {
    private static final VMStatsRegionEntryHeapFactory factory = new VMStatsRegionEntryHeapFactory();

    public VMStatsRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMStatsRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMStatsRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMStatsRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsRegionEntryHeap.getEntryFactory();
        }
    }
}

