/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsLRURegionEntryHeap
extends VMStatsLRURegionEntry {
    private static final VMStatsLRURegionEntryHeapFactory factory = new VMStatsLRURegionEntryHeapFactory();

    public VMStatsLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMStatsLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMStatsLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMStatsLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsLRURegionEntryHeap.getEntryFactory();
        }
    }
}

