/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsDiskLRURegionEntryHeap
extends VMStatsDiskLRURegionEntry {
    private static final VMStatsDiskLRURegionEntryHeapFactory factory = new VMStatsDiskLRURegionEntryHeapFactory();

    public VMStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMStatsDiskLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMStatsDiskLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

