/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BytesAndBitsForCompactor;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.pdx.PdxInstance;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class VMCachedDeserializable
implements CachedDeserializable,
DataSerializableFixedID {
    private volatile Object value;
    private int valueSize;
    static final int MEM_OVERHEAD = 16;

    public VMCachedDeserializable() {
    }

    VMCachedDeserializable(byte[] serializedValue) {
        if (serializedValue == null) {
            throw new NullPointerException(LocalizedStrings.VMCachedDeserializable_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.value = serializedValue;
        this.valueSize = CachedDeserializableFactory.getByteSize(serializedValue);
    }

    VMCachedDeserializable(VMCachedDeserializable cd2) {
        this.value = cd2.value;
        this.valueSize = cd2.valueSize;
    }

    public VMCachedDeserializable(Object object, int objectSize) {
        this.value = object;
        this.valueSize = objectSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        Object v = this.value;
        if (v instanceof byte[]) {
            LRUEntry le = null;
            if (re != null) {
                assert (r != null);
                if (re instanceof LRUEntry) {
                    le = (LRUEntry)re;
                }
            }
            if (le != null) {
                if (r instanceof PartitionedRegion) {
                    r = ((PartitionedRegion)r).getBucketRegion(re.getKey());
                }
                boolean callFinish = false;
                AbstractLRURegionMap lruMap = null;
                if (r != null) {
                    lruMap = (AbstractLRURegionMap)((LocalRegion)r).getRegionMap();
                }
                boolean threadAlreadySynced = Thread.holdsLock(le);
                boolean isCacheListenerInvoked = re.isCacheListenerInvocationInProgress();
                LRUEntry lRUEntry = le;
                synchronized (lRUEntry) {
                    v = this.value;
                    if (!(v instanceof byte[])) {
                        return v;
                    }
                    v = EntryEventImpl.deserialize((byte[])v);
                    if (threadAlreadySynced && !isCacheListenerInvoked) {
                        return v;
                    }
                    if (!(v instanceof PdxInstance)) {
                        this.value = v;
                        if (lruMap != null) {
                            callFinish = lruMap.beginChangeValueForm(le, this, v);
                        }
                    }
                }
                if (callFinish && !isCacheListenerInvoked) {
                    lruMap.finishChangeValueForm();
                }
            } else {
                VMCachedDeserializable vMCachedDeserializable = this;
                synchronized (vMCachedDeserializable) {
                    v = this.value;
                    if (!(v instanceof byte[])) {
                        return v;
                    }
                    if (!((v = EntryEventImpl.deserialize((byte[])v)) instanceof PdxInstance)) {
                        this.value = v;
                    }
                }
            }
        }
        return v;
    }

    @Override
    public Object getDeserializedForReading() {
        Object v = this.value;
        if (v instanceof byte[]) {
            return EntryEventImpl.deserialize((byte[])v);
        }
        return v;
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        Object v = this.value;
        if (v instanceof byte[]) {
            Object result = EntryEventImpl.deserialize((byte[])v);
            if (CopyHelper.isWellKnownImmutableInstance(result) && !(result instanceof PdxInstance)) {
                result = this.getDeserializedValue(r, re);
            }
            return result;
        }
        return CopyHelper.copy(v);
    }

    @Override
    public byte[] getSerializedValue() {
        Object v = this.value;
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        return EntryEventImpl.serialize(v);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getSizeInBytes() {
        return 16 + this.valueSize;
    }

    @Override
    public int getValueSizeInBytes() {
        return this.valueSize;
    }

    @Override
    public int getDSFID() {
        return -64;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        byte[] bytes = DataSerializer.readByteArray(in);
        this.valueSize = bytes.length;
        this.value = bytes;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObjectAsByteArray(this.getValue(), out);
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        return this.getShortClassName() + "@" + this.hashCode();
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        this.toData(out);
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        Object v = this.value;
        if (v instanceof byte[]) {
            wrapper.setData((byte[])v, userBits, ((byte[])v).length, false);
        } else {
            EntryEventImpl.fillSerializedValue(wrapper, v, userBits);
        }
    }

    @Override
    public String getStringForm() {
        try {
            return StringUtils.forceToString(this.getDeserializedForReading());
        }
        catch (RuntimeException ex) {
            return "Could not convert object to string because " + ex;
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

