/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXSynchronizationRunnable
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private Runnable firstRunnable;
    private final Object firstRunnableSync = new Object();
    private boolean firstRunnableCompleted;
    private Runnable secondRunnable;
    private final Object secondRunnableSync = new Object();
    private boolean secondRunnableCompleted;
    private boolean abort;

    public TXSynchronizationRunnable(Runnable beforeCompletion) {
        this.firstRunnable = beforeCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.firstRunnableSync;
        synchronized (object) {
            try {
                this.firstRunnable.run();
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace("beforeCompletion notification completed");
                }
                this.firstRunnableCompleted = true;
                this.firstRunnable = null;
                this.firstRunnableSync.notify();
            }
        }
        object = this.secondRunnableSync;
        synchronized (object) {
            boolean isTraceEnabled = logger.isTraceEnabled();
            while (this.secondRunnable == null && !this.abort) {
                GemFireCacheImpl cache;
                try {
                    if (isTraceEnabled) {
                        logger.trace("waiting for afterCompletion notification");
                    }
                    this.secondRunnableSync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.secondRunnable != null || (cache = GemFireCacheImpl.getInstance()) != null && cache.getCancelCriterion().cancelInProgress() == null) continue;
                return;
            }
            if (isTraceEnabled) {
                logger.trace("executing afterCompletion notification");
            }
            try {
                if (!this.abort) {
                    this.secondRunnable.run();
                }
            }
            finally {
                if (isTraceEnabled) {
                    logger.trace("afterCompletion notification completed");
                }
                this.secondRunnableCompleted = true;
                this.secondRunnable = null;
                this.secondRunnableSync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFirstExecution() {
        Object object = this.firstRunnableSync;
        synchronized (object) {
            while (!this.firstRunnableCompleted) {
                try {
                    this.firstRunnableSync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache == null) {
                    return;
                }
                cache.getCancelCriterion().checkCancelInProgress(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSecondRunnable(Runnable r) {
        Object object = this.secondRunnableSync;
        synchronized (object) {
            this.secondRunnable = r;
            this.secondRunnableSync.notify();
            while (!this.secondRunnableCompleted && !this.abort) {
                try {
                    this.secondRunnableSync.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache == null) {
                    return;
                }
                cache.getCancelCriterion().checkCancelInProgress(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.secondRunnableSync;
        synchronized (object) {
            this.abort = true;
        }
    }
}

