/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.distributed.TXManagerCancelledException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TXStateProxyImpl;
import com.gemstone.gemfire.internal.cache.TransactionMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.Logger;

public final class TXManagerImpl
implements CacheTransactionManager,
MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private final ThreadLocal<TXStateProxy> txContext;
    private static TXManagerImpl currentInstance = null;
    private final AtomicInteger uniqId;
    private final DM dm;
    private final Cache cache;
    private final InternalDistributedMember distributionMgrId;
    private final CachePerfStats cachePerfStats;
    private static final TransactionListener[] EMPTY_LISTENERS = new TransactionListener[0];
    public static final int NOTX = -1;
    private final ArrayList<TransactionListener> txListeners = new ArrayList(8);
    public TransactionWriter writer = null;
    private boolean closed = false;
    private final Map<TXId, TXStateProxy> hostedTXStates;
    public static final int FAILOVER_TX_MAP_SIZE = Integer.getInteger("gemfire.transactionFailoverMapSize", 1000);
    private Map<TXId, TXCommitMessage> failoverMap = Collections.synchronizedMap(new LinkedHashMap<TXId, TXCommitMessage>(){
        private static final long serialVersionUID = -4156018226167594134L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: removing client initiated transaction from failover map:{} :{}", eldest.getKey(), this.size() > FAILOVER_TX_MAP_SIZE);
            }
            return this.size() > FAILOVER_TX_MAP_SIZE;
        }
    });
    public static boolean ALLOW_PERSISTENT_TRANSACTIONS = Boolean.getBoolean("gemfire.ALLOW_PERSISTENT_TRANSACTIONS");
    private ConcurrentMap<TXId, Boolean> localTxMap = new ConcurrentHashMap<TXId, Boolean>();
    private volatile long suspendedTXTimeout = Long.getLong("gemfire.suspendedTxTimeout", 30L);
    private ConcurrentMap<TransactionId, TXStateProxy> suspendedTXs = new ConcurrentHashMap<TransactionId, TXStateProxy>();
    private ConcurrentMap<TransactionId, Queue<Thread>> waitMap = new ConcurrentHashMap<TransactionId, Queue<Thread>>();
    private ConcurrentMap<TransactionId, SystemTimer.SystemTimerTask> expiryTasks = new ConcurrentHashMap<TransactionId, SystemTimer.SystemTimerTask>();
    private final CustomEntryConcurrentHashMap<AbstractRegionEntry, RefCountMapEntry> refCountMap = new CustomEntryConcurrentHashMap<AbstractRegionEntry, RefCountMapEntry>(16, 0.75f, 16, true, new RefCountMapEntryCreator());
    private static final CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object> incCallback = new CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object>(){

        @Override
        public RefCountMapEntry newValue(AbstractRegionEntry key2, Object context, Object createParams) {
            return new RefCountMapEntry(key2);
        }

        @Override
        public void oldValueRead(RefCountMapEntry value2) {
            value2.incRefCount();
        }

        @Override
        public boolean doRemoveValue(RefCountMapEntry value2, Object context, Object removeParams) {
            throw new IllegalStateException("doRemoveValue should not be called from create");
        }
    };
    private static final CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object> decCallback = new CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object>(){

        @Override
        public RefCountMapEntry newValue(AbstractRegionEntry key2, Object context, Object createParams) {
            throw new IllegalStateException("newValue should not be called from remove");
        }

        @Override
        public void oldValueRead(RefCountMapEntry value2) {
            throw new IllegalStateException("oldValueRead should not be called from remove");
        }

        @Override
        public boolean doRemoveValue(RefCountMapEntry value2, Object context, Object removeParams) {
            return value2.decRefCount();
        }
    };

    public TXManagerImpl(CachePerfStats cachePerfStats, Cache cache) {
        this.cache = cache;
        this.dm = ((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager();
        this.distributionMgrId = this.dm.getDistributionManagerId();
        this.uniqId = new AtomicInteger(0);
        this.cachePerfStats = cachePerfStats;
        this.hostedTXStates = new HashMap<TXId, TXStateProxy>();
        this.txContext = new ThreadLocal();
        currentInstance = this;
    }

    final Cache getCache() {
        return this.cache;
    }

    @Override
    public final TransactionWriter getWriter() {
        return this.writer;
    }

    @Override
    public final void setWriter(TransactionWriter writer) {
        if (((GemFireCacheImpl)this.cache).isClient()) {
            throw new IllegalStateException(LocalizedStrings.TXManager_NO_WRITER_ON_CLIENT.toLocalizedString());
        }
        this.writer = writer;
    }

    @Override
    public final TransactionListener getListener() {
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            if (this.txListeners.isEmpty()) {
                return null;
            }
            if (this.txListeners.size() == 1) {
                return this.txListeners.get(0);
            }
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_MORE_THAN_ONE_TRANSACTION_LISTENER_EXISTS.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionListener[] getListeners() {
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            int size2 = this.txListeners.size();
            if (size2 == 0) {
                return EMPTY_LISTENERS;
            }
            TransactionListener[] result = new TransactionListener[size2];
            this.txListeners.toArray(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionListener setListener(TransactionListener newListener) {
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            TransactionListener result = this.getListener();
            this.txListeners.clear();
            if (newListener != null) {
                this.txListeners.add(newListener);
            }
            if (result != null) {
                this.closeListener(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TransactionListener aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException(LocalizedStrings.TXManagerImpl_ADDLISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            if (!this.txListeners.contains(aListener)) {
                this.txListeners.add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TransactionListener aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException(LocalizedStrings.TXManagerImpl_REMOVELISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            if (this.txListeners.remove(aListener)) {
                this.closeListener(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initListeners(TransactionListener[] newListeners) {
        ArrayList<TransactionListener> arrayList = this.txListeners;
        synchronized (arrayList) {
            if (!this.txListeners.isEmpty()) {
                Iterator<TransactionListener> it = this.txListeners.iterator();
                while (it.hasNext()) {
                    this.closeListener(it.next());
                }
                this.txListeners.clear();
            }
            if (newListeners != null && newListeners.length > 0) {
                List<TransactionListener> nl = Arrays.asList(newListeners);
                if (nl.contains(null)) {
                    throw new IllegalArgumentException(LocalizedStrings.TXManagerImpl_INITLISTENERS_PARAMETER_HAD_A_NULL_ELEMENT.toLocalizedString());
                }
                this.txListeners.addAll(nl);
            }
        }
    }

    final CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    @Override
    public void begin() {
        this.checkClosed();
        TransactionId tid = this.getTransactionId();
        if (tid != null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_TRANSACTION_0_ALREADY_IN_PROGRESS.toLocalizedString(tid));
        }
        TXId id = new TXId(this.distributionMgrId, this.uniqId.incrementAndGet());
        this.setTXState(new TXStateProxyImpl(this, id, null));
        this.localTxMap.put(id, Boolean.TRUE);
    }

    public TXStateProxy beginJTA() {
        this.checkClosed();
        TXId id = new TXId(this.distributionMgrId, this.uniqId.incrementAndGet());
        TXStateProxyImpl newState = new TXStateProxyImpl(this, id, true);
        this.setTXState(newState);
        return newState;
    }

    @Override
    public void commit() throws CommitConflictException {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_THREAD_DOES_NOT_HAVE_AN_ACTIVE_TRANSACTION.toLocalizedString());
        }
        tx.checkJTA(LocalizedStrings.TXManagerImpl_CAN_NOT_COMMIT_THIS_TRANSACTION_BECAUSE_IT_IS_ENLISTED_WITH_A_JTA_TRANSACTION_USE_THE_JTA_MANAGER_TO_PERFORM_THE_COMMIT.toLocalizedString());
        long opStart = CachePerfStats.getStatTime();
        long lifeTime = opStart - tx.getBeginTime();
        try {
            this.setTXState(null);
            tx.commit();
        }
        catch (CommitConflictException ex) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.CMT_CONFLICT_MSG);
            this.noteCommitFailure(opStart, lifeTime, tx);
            throw ex;
        }
        catch (TransactionDataRebalancedException reb) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.REBALANCE_MSG);
            throw reb;
        }
        catch (UnsupportedOperationInTransactionException e) {
            this.setTXState(tx);
            throw e;
        }
        catch (RuntimeException e) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.EXCEPTION_MSG);
            throw e;
        }
        this.saveTXStateForClientFailover(tx);
        this.cleanup(tx.getTransactionId());
        this.noteCommitSuccess(opStart, lifeTime, tx);
    }

    final void noteCommitFailure(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = CachePerfStats.getStatTime();
        this.cachePerfStats.txFailure(opEnd - opStart, lifeTime, tx.getChanges());
        TransactionListener[] listeners = this.getListeners();
        if (tx.isFireCallbacks()) {
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].afterFailedCommit(tx.getEvent());
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error(LocalizedMessage.create(LocalizedStrings.TXManagerImpl_EXCEPTION_OCCURRED_IN_TRANSACTIONLISTENER), t);
                }
            }
        }
    }

    final void noteCommitSuccess(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = CachePerfStats.getStatTime();
        this.cachePerfStats.txSuccess(opEnd - opStart, lifeTime, tx.getChanges());
        if (tx.isFireCallbacks()) {
            TransactionListener[] listeners = this.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].afterCommit(tx.getEvent());
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error(LocalizedMessage.create(LocalizedStrings.TXManagerImpl_EXCEPTION_OCCURRED_IN_TRANSACTIONLISTENER), t);
                }
            }
        }
    }

    private void _incrementTXUniqueIDForReplay() {
        TXStateProxyImpl tx = (TXStateProxyImpl)this.getTXState();
        assert (tx != null) : "expected a transaction to be in progress";
        TXId id = new TXId(this.distributionMgrId, this.uniqId.incrementAndGet());
        tx.setTXIDForReplay(id);
    }

    @Override
    public void rollback() {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_THREAD_DOES_NOT_HAVE_AN_ACTIVE_TRANSACTION.toLocalizedString());
        }
        tx.checkJTA(LocalizedStrings.TXManagerImpl_CAN_NOT_ROLLBACK_THIS_TRANSACTION_IS_ENLISTED_WITH_A_JTA_TRANSACTION_USE_THE_JTA_MANAGER_TO_PERFORM_THE_ROLLBACK.toLocalizedString());
        long opStart = CachePerfStats.getStatTime();
        long lifeTime = opStart - tx.getBeginTime();
        this.setTXState(null);
        tx.rollback();
        this.saveTXStateForClientFailover(tx);
        this.cleanup(tx.getTransactionId());
        this.noteRollbackSuccess(opStart, lifeTime, tx);
    }

    final void noteRollbackSuccess(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = CachePerfStats.getStatTime();
        this.cachePerfStats.txRollback(opEnd - opStart, lifeTime, tx.getChanges());
        TransactionListener[] listeners = this.getListeners();
        if (tx.isFireCallbacks()) {
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].afterRollback(tx.getEvent());
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error(LocalizedMessage.create(LocalizedStrings.TXManagerImpl_EXCEPTION_OCCURRED_IN_TRANSACTIONLISTENER), t);
                }
            }
        }
    }

    private void cleanup(TransactionId txId) {
        this.localTxMap.remove(txId);
        Queue waitingThreads = (Queue)this.waitMap.get(txId);
        if (waitingThreads != null && !waitingThreads.isEmpty()) {
            for (Thread waitingThread : waitingThreads) {
                LockSupport.unpark(waitingThread);
            }
            this.waitMap.remove(txId);
        }
    }

    @Override
    public boolean exists() {
        return null != this.getTXState();
    }

    @Override
    public TransactionId getTransactionId() {
        TXStateProxy t = this.getTXState();
        TransactionId ret = null;
        if (t != null) {
            ret = t.getTransactionId();
        }
        return ret;
    }

    public final TXStateProxy getTXState() {
        TXStateProxy tsp = this.txContext.get();
        if (tsp != null && !tsp.isInProgress()) {
            this.txContext.set(null);
            tsp = null;
        }
        return tsp;
    }

    public boolean setInProgress(boolean progress) {
        boolean retVal = false;
        TXStateProxy tsp = this.txContext.get();
        if (tsp != null) {
            retVal = tsp.isInProgress();
            tsp.setInProgress(progress);
        }
        return retVal;
    }

    public final void setTXState(TXStateProxy val) {
        this.txContext.set(val);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        TransactionListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.closeListener(listeners[i]);
        }
    }

    private void closeListener(TransactionListener tl) {
        try {
            tl.close();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.error(LocalizedMessage.create(LocalizedStrings.TXManagerImpl_EXCEPTION_OCCURRED_IN_TRANSACTIONLISTENER), t);
        }
    }

    public final TXStateProxy internalSuspend() {
        TXStateProxy result = this.getTXState();
        if (result != null) {
            result.suspend();
            this.setTXState(null);
        }
        return result;
    }

    public final void resume(TXStateProxy tx) {
        if (tx != null) {
            TransactionId tid = this.getTransactionId();
            if (tid != null) {
                throw new IllegalStateException(LocalizedStrings.TXManagerImpl_TRANSACTION_0_ALREADY_IN_PROGRESS.toLocalizedString(tid));
            }
            if (tx instanceof TXState) {
                throw new IllegalStateException("Found instance of TXState: " + tx);
            }
            this.setTXState(tx);
            tx.resume();
            SystemTimer.SystemTimerTask task = (SystemTimer.SystemTimerTask)this.expiryTasks.remove(tx.getTransactionId());
            if (task != null) {
                task.cancel();
            }
        }
    }

    private final boolean isClosed() {
        return this.closed;
    }

    private final void checkClosed() {
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        if (this.closed) {
            throw new TXManagerCancelledException("This transaction manager is closed.");
        }
    }

    final DM getDM() {
        return this.dm;
    }

    public static int getCurrentTXUniqueId() {
        if (currentInstance == null) {
            return -1;
        }
        return currentInstance.getMyTXUniqueId();
    }

    public static final TXStateProxy getCurrentTXState() {
        if (currentInstance == null) {
            return null;
        }
        return currentInstance.getTXState();
    }

    public static void incrementTXUniqueIDForReplay() {
        if (currentInstance != null) {
            currentInstance._incrementTXUniqueIDForReplay();
        }
    }

    public int getMyTXUniqueId() {
        TXStateProxy t = this.txContext.get();
        if (t != null) {
            return t.getTxId().getUniqId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy masqueradeAs(TransactionMessage msg) throws InterruptedException {
        if (msg.getTXUniqId() == -1 || !msg.canParticipateInTransaction()) {
            return null;
        }
        TXId key2 = new TXId(msg.getMemberToMasqueradeAs(), msg.getTXUniqId());
        TXStateProxy val = this.hostedTXStates.get(key2);
        if (val == null) {
            Map<TXId, TXStateProxy> map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(key2);
                if (val == null && msg.canStartRemoteTransaction()) {
                    val = new TXStateProxyImpl(this, key2, msg.getTXOriginatorClient());
                    val.setLocalTXState(new TXState(val, true));
                    this.hostedTXStates.put(key2, val);
                }
            }
        }
        if (val != null && !val.getLock().isHeldByCurrentThread()) {
            val.getLock().lock();
        }
        this.setTXState(val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy masqueradeAs(Message msg, InternalDistributedMember memberId, boolean probeOnly) throws InterruptedException {
        Map<TXId, TXStateProxy> map;
        if (msg.getTransactionId() == -1) {
            return null;
        }
        TXId key2 = new TXId(memberId, msg.getTransactionId());
        TXStateProxy val = this.hostedTXStates.get(key2);
        if (val == null) {
            map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(key2);
                if (val == null && msg.canStartRemoteTransaction()) {
                    val = new TXStateProxyImpl(this, key2, memberId);
                    this.hostedTXStates.put(key2, val);
                }
            }
        }
        if (!probeOnly) {
            if (val != null && !val.getLock().isHeldByCurrentThread()) {
                val.getLock().lock();
                map = this.hostedTXStates;
                synchronized (map) {
                    this.hostedTXStates.put(key2, val);
                }
            }
            this.setTXState(val);
        }
        return val;
    }

    public void masqueradeAs(TXStateProxy txState) {
        assert (txState != null);
        if (!txState.getLock().isHeldByCurrentThread()) {
            txState.getLock().lock();
        }
        this.setTXState(txState);
    }

    public void unmasquerade(TXStateProxy tx) {
        if (tx != null) {
            this.setTXState(null);
            tx.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy removeHostedTXState(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return this.hostedTXStates.remove(txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHostedTXStatesForClients() {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> entry = iterator.next();
                if (!entry.getValue().isOnBehalfOfClient()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Cleaning up TXStateProxy for {}", entry.getKey());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostedTxInProgress(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            TXStateProxy tx = this.hostedTXStates.get(txId);
            if (tx == null) {
                return false;
            }
            return tx.isRealDealLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy getHostedTXState(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return this.hostedTXStates.get(txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostedTransactionsInProgressForTest() {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return this.hostedTXStates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<TXId> iterator = this.hostedTXStates.keySet().iterator();
            while (iterator.hasNext()) {
                TXId txId = iterator.next();
                if (!txId.getMemberId().equals(id)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Received memberDeparted, cleaning up txState:{}", txId);
                }
                iterator.remove();
            }
        }
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TXId> getTransactionsForClient(InternalDistributedMember id) {
        HashSet<TXId> result = new HashSet<TXId>();
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (Map.Entry<TXId, TXStateProxy> entry : this.hostedTXStates.entrySet()) {
                if (!entry.getKey().getMemberId().equals(id)) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactions(Set<TXId> txIds, boolean distribute) {
        if (logger.isDebugEnabled()) {
            logger.debug("expiring the following transactions: {}", txIds);
        }
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> entry = iterator.next();
                if (!txIds.contains(entry.getKey())) continue;
                iterator.remove();
            }
        }
        if (distribute) {
            TXRemovalMessage.send(this.dm, this.dm.getOtherDistributionManagerIds(), txIds);
        }
    }

    private void saveTXStateForClientFailover(TXStateProxy tx) {
        if (tx.isOnBehalfOfClient() && tx.isRealDealLocal()) {
            this.failoverMap.put(tx.getTxId(), tx.getCommitMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("TX: storing client initiated transaction:{}; now there are {} entries in the failoverMap", tx.getTxId(), this.failoverMap.size());
            }
        }
    }

    private void saveTXStateForClientFailover(TXStateProxy tx, TXCommitMessage msg) {
        if (tx.isOnBehalfOfClient() && tx.isRealDealLocal()) {
            this.failoverMap.put(tx.getTxId(), msg);
            if (logger.isDebugEnabled()) {
                logger.debug("TX: storing client initiated transaction:{}; now there are {} entries in the failoverMap", tx.getTxId(), this.failoverMap.size());
            }
        }
    }

    public void saveTXCommitMessageForClientFailover(TXId txId, TXCommitMessage msg) {
        this.failoverMap.put(txId, msg);
    }

    public boolean isHostedTxRecentlyCompleted(TXId txId) {
        TXCommitMessage msg = this.failoverMap.remove(txId);
        if (msg != null) {
            this.failoverMap.put(txId, msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletingTransaction(TXId txId) {
        TXStateProxyImpl impl;
        TXState state;
        TXStateProxy val = this.hostedTXStates.get(txId);
        if (val == null) {
            Map<TXId, TXStateProxy> map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(txId);
            }
        }
        return val != null && val.isRealDealLocal() && (state = (impl = (TXStateProxyImpl)val).getLocalRealDeal()).waitForPreviousCompletion();
    }

    public TXCommitMessage getRecentlyCompletedMessage(TXId txId) {
        return this.failoverMap.get(txId);
    }

    public boolean isExceptionToken(TXCommitMessage msg) {
        return msg == TXCommitMessage.CMT_CONFLICT_MSG || msg == TXCommitMessage.REBALANCE_MSG || msg == TXCommitMessage.EXCEPTION_MSG;
    }

    public RuntimeException getExceptionForToken(TXCommitMessage msg, TXId txId) {
        if (msg == TXCommitMessage.CMT_CONFLICT_MSG) {
            return new CommitConflictException(LocalizedStrings.TXState_CONFLICT_DETECTED_IN_GEMFIRE_TRANSACTION_0.toLocalizedString(txId));
        }
        if (msg == TXCommitMessage.REBALANCE_MSG) {
            return new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
        }
        if (msg == TXCommitMessage.EXCEPTION_MSG) {
            return new TransactionInDoubtException(LocalizedStrings.ClientTXStateStub_COMMIT_FAILED_ON_SERVER.toLocalizedString());
        }
        throw new InternalGemFireError("the parameter TXCommitMessage is not an exception token");
    }

    @Override
    public TransactionId suspend() {
        TXStateProxy result = this.getTXState();
        if (result != null) {
            TransactionId txId = result.getTransactionId();
            this.internalSuspend();
            this.suspendedTXs.put(txId, result);
            Queue waitingThreads = (Queue)this.waitMap.get(txId);
            if (waitingThreads != null) {
                Thread waitingThread = null;
                while ((waitingThread = (Thread)waitingThreads.poll()) != null && Thread.currentThread().equals(waitingThread)) {
                }
                if (waitingThread != null) {
                    LockSupport.unpark(waitingThread);
                }
            }
            this.scheduleExpiry(txId);
            return txId;
        }
        return null;
    }

    @Override
    public void resume(TransactionId transactionId) {
        if (transactionId == null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_UNKNOWN_TRANSACTION_OR_RESUMED.toLocalizedString());
        }
        if (this.getTXState() != null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_TRANSACTION_ACTIVE_CANNOT_RESUME.toLocalizedString());
        }
        TXStateProxy txProxy = (TXStateProxy)this.suspendedTXs.remove(transactionId);
        if (txProxy == null) {
            throw new IllegalStateException(LocalizedStrings.TXManagerImpl_UNKNOWN_TRANSACTION_OR_RESUMED.toLocalizedString());
        }
        this.resume(txProxy);
    }

    @Override
    public boolean isSuspended(TransactionId transactionId) {
        return this.suspendedTXs.containsKey(transactionId);
    }

    @Override
    public boolean tryResume(TransactionId transactionId) {
        if (transactionId == null || this.getTXState() != null) {
            return false;
        }
        TXStateProxy txProxy = (TXStateProxy)this.suspendedTXs.remove(transactionId);
        if (txProxy != null) {
            this.resume(txProxy);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryResume(TransactionId transactionId, long time, TimeUnit unit) {
        if (transactionId == null || this.getTXState() != null || !this.exists(transactionId)) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        long timeout = unit.toNanos(time);
        long startTime = System.nanoTime();
        Queue threadq = null;
        try {
            long nowTime;
            do {
                Queue oldq2;
                if ((threadq = (ConcurrentLinkedQueue<Thread>)this.waitMap.get(transactionId)) == null && (oldq2 = (Queue)this.waitMap.putIfAbsent(transactionId, threadq = new ConcurrentLinkedQueue<Thread>())) != null) {
                    threadq = oldq2;
                }
                threadq.add(currentThread);
                if (this.tryResume(transactionId)) {
                    boolean oldq2 = true;
                    return oldq2;
                }
                if (!this.exists(transactionId)) {
                    boolean oldq2 = false;
                    return oldq2;
                }
                LockSupport.parkNanos(timeout);
            } while ((timeout -= (nowTime = System.nanoTime()) - (startTime = nowTime)) > 0L);
        }
        finally {
            threadq = (Queue)this.waitMap.get(transactionId);
            if (threadq != null) {
                threadq.remove(currentThread);
            }
        }
        return false;
    }

    @Override
    public boolean exists(TransactionId transactionId) {
        return this.isHostedTxInProgress((TXId)transactionId) || this.isSuspended(transactionId) || this.localTxMap.containsKey(transactionId);
    }

    public void setSuspendedTransactionTimeout(long timeout) {
        this.suspendedTXTimeout = timeout;
    }

    public long getSuspendedTransactionTimeout() {
        return this.suspendedTXTimeout;
    }

    private void scheduleExpiry(TransactionId txId) {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.cache;
        if (this.suspendedTXTimeout < 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: transaction: {} not scheduled to expire", txId);
            }
            return;
        }
        TXExpiryTask task = new TXExpiryTask(txId);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: scheduling transaction: {} to expire after:{}", txId, this.suspendedTXTimeout);
        }
        cache.getCCPTimer().schedule((SystemTimer.SystemTimerTask)task, this.suspendedTXTimeout * 60L * 1000L);
        this.expiryTasks.put(txId, task);
    }

    public static final void incRefCount(AbstractRegionEntry re) {
        TXManagerImpl mgr = currentInstance;
        if (mgr != null) {
            mgr.refCountMap.create(re, incCallback, null, null, true);
        }
    }

    public static final boolean decRefCount(AbstractRegionEntry re) {
        TXManagerImpl mgr = currentInstance;
        if (mgr != null) {
            return mgr.refCountMap.removeConditionally(re, decCallback, null, null) != null;
        }
        return true;
    }

    private static class RefCountMapEntry
    implements CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> {
        private final AbstractRegionEntry key;
        private CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> next;
        private volatile int refCount;
        private static final AtomicIntegerFieldUpdater<RefCountMapEntry> refCountUpdater = AtomicIntegerFieldUpdater.newUpdater(RefCountMapEntry.class, "refCount");

        public RefCountMapEntry(AbstractRegionEntry k) {
            this.key = k;
            this.refCount = 1;
        }

        @Override
        public AbstractRegionEntry getKey() {
            return this.key;
        }

        @Override
        public boolean isKeyEqual(Object k) {
            return this.key.equals(k);
        }

        @Override
        public RefCountMapEntry getMapValue() {
            return this;
        }

        @Override
        public void setMapValue(RefCountMapEntry newValue) {
            if (newValue != this) {
                throw new IllegalStateException("Expected newValue " + newValue + " to be this " + this);
            }
        }

        @Override
        public int getEntryHash() {
            return this.key.getEntryHash();
        }

        @Override
        public CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> getNextEntry() {
            return this.next;
        }

        @Override
        public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> n) {
            this.next = n;
        }

        public void incRefCount() {
            refCountUpdater.addAndGet(this, 1);
        }

        public boolean decRefCount() {
            int rc = refCountUpdater.decrementAndGet(this);
            if (rc < 0) {
                throw new IllegalStateException("rc=" + rc);
            }
            return rc == 0;
        }
    }

    private static class RefCountMapEntryCreator
    implements CustomEntryConcurrentHashMap.HashEntryCreator<AbstractRegionEntry, RefCountMapEntry> {
        private RefCountMapEntryCreator() {
        }

        @Override
        public CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> newEntry(AbstractRegionEntry key2, int hash, CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> next2, RefCountMapEntry value2) {
            value2.setNextEntry(next2);
            return value2;
        }

        @Override
        public int keyHashCode(Object key2, boolean compareValues) {
            return ((AbstractRegionEntry)key2).getEntryHash();
        }
    }

    public static class TXExpiryTask
    extends SystemTimer.SystemTimerTask {
        private final TransactionId txId;

        public TXExpiryTask(TransactionId txId) {
            this.txId = txId;
        }

        @Override
        public void run2() {
            TXManagerImpl mgr = currentInstance;
            TXStateProxy tx = (TXStateProxy)mgr.suspendedTXs.remove(this.txId);
            if (tx != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("TX: Expiry task rolling back transaction: {}", this.txId);
                    }
                    tx.rollback();
                }
                catch (GemFireException e) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.TXManagerImpl_EXCEPTION_IN_TRANSACTION_TIMEOUT, this.txId), (Throwable)e);
                }
            }
        }
    }

    public static class TXRemovalMessage
    extends HighPriorityDistributionMessage {
        Set<TXId> txIds;

        static void send(DM dm, Set recipients, Set<TXId> txIds) {
            TXRemovalMessage msg = new TXRemovalMessage();
            msg.txIds = txIds;
            msg.setRecipients(recipients);
            dm.putOutgoing(msg);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeHashSet((HashSet)this.txIds, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.txIds = DataSerializer.readHashSet(in);
        }

        @Override
        public int getDSFID() {
            return 138;
        }

        @Override
        protected void process(DistributionManager dm) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null) {
                TXManagerImpl mgr = cache.getTXMgr();
                mgr.removeTransactions(this.txIds, false);
            }
        }
    }
}

