/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.ExternalizableDSFID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class TXId
extends ExternalizableDSFID
implements TransactionId {
    private InternalDistributedMember memberId;
    private int uniqId;

    public TXId() {
    }

    public TXId(InternalDistributedMember memberId, int uniqId) {
        this.memberId = memberId;
        this.uniqId = uniqId;
    }

    public InternalDistributedMember getMemberId() {
        return this.memberId;
    }

    public String toString() {
        return "TXId: " + this.memberId + ':' + this.uniqId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TXId)) {
            return false;
        }
        TXId otx = (TXId)o;
        return otx.uniqId == this.uniqId && (otx.memberId == null && this.memberId == null || otx.memberId != null && this.memberId != null && otx.memberId.equals(this.memberId));
    }

    public int hashCode() {
        int retval = this.uniqId;
        if (this.memberId != null) {
            retval = retval * 37 + this.memberId.hashCode();
        }
        return retval;
    }

    @Override
    public int getDSFID() {
        return 109;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.uniqId);
        InternalDataSerializer.invokeToData(this.memberId, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.uniqId = in.readInt();
        this.memberId = DSFIDFactory.readInternalDistributedMember(in);
    }

    public static final TXId createFromData(DataInput in) throws IOException, ClassNotFoundException {
        TXId result = new TXId();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    public int getUniqId() {
        return this.uniqId;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

