/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.locks.TXLockId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class TXFarSideCMTracker {
    private static final Logger logger = LogService.getLogger();
    private final Map txInProgress;
    private final Object[] txHistory;
    private int lastHistoryItem;
    private Map<TXId, TXCommitMessage> failoverMap = Collections.synchronizedMap(new LinkedHashMap<TXId, TXCommitMessage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > TXManagerImpl.FAILOVER_TX_MAP_SIZE;
        }
    });

    public TXFarSideCMTracker(int historySize) {
        this.txInProgress = new HashMap();
        this.txHistory = new Object[historySize];
        this.lastHistoryItem = 0;
    }

    public final int getHistorySize() {
        return this.txHistory.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commitProcessReceived(Object key2, DM dm) {
        TXCommitMessage mess;
        if (key2 instanceof TXLockId) {
            TXLockId lk = (TXLockId)key2;
            this.waitForMemberToDepart(lk.getMemberId(), dm);
        } else if (key2 instanceof TXId) {
            TXId id = (TXId)key2;
            this.waitForMemberToDepart(id.getMemberId(), dm);
        } else {
            Assert.assertTrue(false, "TXTracker received an unknown key class: " + key2.getClass());
        }
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.get(key2);
            if (null != mess && mess.isProcessing()) {
                return true;
            }
            for (int i = this.txHistory.length - 1; i >= 0; --i) {
                if (!key2.equals(this.txHistory[i])) continue;
                return true;
            }
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                if (!mess.isProcessing()) {
                    mess.setDontProcess();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllToProcess() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Map map = this.txInProgress;
        synchronized (map) {
            while (!this.txInProgress.isEmpty()) {
                this.txInProgress.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitToProcess(TXLockId lk, DM dm) {
        TXCommitMessage mess;
        this.waitForMemberToDepart(lk.getMemberId(), dm);
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.get(lk);
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                while (!mess.wasProcessed()) {
                    try {
                        mess.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        logger.error(LocalizedMessage.create(LocalizedStrings.TxFarSideTracker_WAITING_TO_COMPLETE_ON_MESSAGE_0_CAUGHT_AN_INTERRUPTED_EXCEPTION, mess), (Throwable)ie);
                        break;
                    }
                }
            }
        } else {
            for (int i = this.txHistory.length - 1; i >= 0; --i) {
                if (!lk.equals(this.txHistory[i])) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void waitForMemberToDepart(final InternalDistributedMember memberId, DM dm) {
        if (!dm.getDistributionManagerIds().contains(memberId)) {
            return;
        }
        final Object lock = new Object();
        MembershipListener memEar = new MembershipListener(){

            @Override
            public void memberJoined(InternalDistributedMember id) {
            }

            @Override
            public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memberDeparted(InternalDistributedMember id, boolean crashed) {
                if (memberId.equals(id)) {
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
            }

            @Override
            public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            }
        };
        try {
            Set memberSet = dm.addMembershipListenerAndGetDistributionManagerIds(memEar);
            Object object = lock;
            synchronized (object) {
                while (memberSet.contains(memberId)) {
                    try {
                        lock.wait();
                        memberSet = dm.getDistributionManagerIds();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var6_6
                        dm.removeMembershipListener(memEar);
                        return;
                    }
                }
                return;
            }
        }
        finally {
            dm.removeMembershipListener(memEar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage processed(TXCommitMessage processedMess) {
        TXCommitMessage mess;
        Object key2 = processedMess.getTrackerKey();
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.remove(key2);
            if (mess != null) {
                this.txHistory[this.lastHistoryItem++] = key2;
                if (this.lastHistoryItem >= this.txHistory.length) {
                    this.lastHistoryItem = 0;
                }
                if (this.txInProgress.isEmpty()) {
                    this.txInProgress.notifyAll();
                }
            }
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                mess.setProcessed(true);
                mess.notifyAll();
            }
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessage(TXCommitMessage deadMess) {
        Map map = this.txInProgress;
        synchronized (map) {
            this.txInProgress.remove(deadMess.getTrackerKey());
            if (this.txInProgress.isEmpty()) {
                this.txInProgress.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage get(Object key2) {
        TXCommitMessage mess;
        Map map = this.txInProgress;
        synchronized (map) {
            mess = (TXCommitMessage)this.txInProgress.get(key2);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage waitForMessage(Object key2, DM dm) {
        TXCommitMessage msg = null;
        Map map = this.txInProgress;
        synchronized (map) {
            msg = (TXCommitMessage)this.txInProgress.get(key2);
            while (msg == null) {
                try {
                    dm.getSystem().getCancelCriterion().checkCancelInProgress(null);
                    this.txInProgress.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                msg = (TXCommitMessage)this.txInProgress.get(key2);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(TXCommitMessage msg) {
        Map map = this.txInProgress;
        synchronized (map) {
            Object key2 = msg.getTrackerKey();
            if (key2 == null) {
                Assert.assertTrue(false, "TXFarSideCMTracker must have a non-null key for message " + msg);
            }
            this.txInProgress.put(key2, msg);
            this.txInProgress.notifyAll();
        }
    }

    public void saveTXForClientFailover(TXId txId, TXCommitMessage msg) {
        this.failoverMap.put(txId, msg);
    }

    public TXCommitMessage getTXCommitMessage(TXId txId) {
        return this.failoverMap.get(txId);
    }

    public void clearForCacheClose() {
        this.failoverMap.clear();
        this.lastHistoryItem = 0;
        Arrays.fill(this.txHistory, null);
    }
}

