/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class StateFlushOperation {
    private static final Logger logger = LogService.getLogger();
    private DistributedRegion region;
    private DM dm;

    public static void flushTo(Set<InternalDistributedMember> targets, DistributedRegion region) {
        DM dm = region.getDistributionManager();
        DistributedRegion r = region;
        boolean initialized = r.isInitialized();
        if (initialized) {
            r.getDistributionAdvisor().forceNewMembershipVersion();
            try {
                r.getDistributionAdvisor().waitForCurrentOperations();
            }
            catch (RegionDestroyedException e) {
                return;
            }
        }
        HashSet<ReplyProcessor21> processors = new HashSet<ReplyProcessor21>();
        for (InternalDistributedMember target : targets) {
            StateStabilizationMessage gr = new StateStabilizationMessage();
            gr.isSingleFlushTo = true;
            gr.requestingMember = dm.getDistributionManagerId();
            gr.setRecipient(target);
            ReplyProcessor21 processor = new ReplyProcessor21(dm, target);
            gr.processorId = processor.getProcessorId();
            gr.channelState = dm.getMembershipManager().getChannelStates(target, false);
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP) && gr.channelState != null && gr.channelState.size() > 0) {
                logger.trace(LogMarker.STATE_FLUSH_OP, "channel states: {}", gr.channelStateDescription(gr.channelState));
            }
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
                logger.trace(LogMarker.STATE_FLUSH_OP, "Sending {}", gr);
            }
            dm.putOutgoing(gr);
            processors.add(processor);
        }
        for (ReplyProcessor21 processor : processors) {
            try {
                processor.waitForReplies();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public StateFlushOperation(DistributedRegion r) {
        this.region = r;
        this.dm = r.getDistributionManager();
    }

    public StateFlushOperation(DM dm) {
        this.dm = dm;
    }

    public boolean flush(Set recipients, DistributedMember target, int processorType, boolean flushNewOps) throws InterruptedException {
        Set failures;
        HashSet<DistributedMember> recips = recipients;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InternalDistributedMember myId = this.dm.getDistributionManagerId();
        if (!recips.contains(target) && !myId.equals(target)) {
            recips = new HashSet<DistributedMember>(recipients);
            recips.add(target);
        }
        StateMarkerMessage smm = new StateMarkerMessage();
        smm.relayRecipient = target;
        smm.processorType = processorType;
        smm.flushNewOps = flushNewOps;
        if (this.region == null) {
            smm.allRegions = true;
        } else {
            smm.regionPath = this.region.getFullPath();
        }
        smm.setRecipients(recips);
        StateFlushReplyProcessor gfprocessor = new StateFlushReplyProcessor(this.dm, recips, target);
        smm.processorId = gfprocessor.getProcessorId();
        if (this.region != null && this.region.isUsedForPartitionedRegionBucket() && this.region.getDistributionConfig().getAckSevereAlertThreshold() > 0) {
            smm.severeAlertEnabled = true;
            gfprocessor.enableSevereAlertProcessing();
        }
        if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
            logger.trace(LogMarker.STATE_FLUSH_OP, "Sending {} with processor {}", smm, gfprocessor);
        }
        if ((failures = this.dm.putOutgoing(smm)) != null) {
            if (failures.contains(target)) {
                if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
                    logger.trace(LogMarker.STATE_FLUSH_OP, "failed to send StateMarkerMessage to target {}; returning from flush without waiting for replies", target);
                }
                return false;
            }
            gfprocessor.messageNotSentTo(failures);
        }
        try {
            gfprocessor.waitForReplies();
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
                logger.trace(LogMarker.STATE_FLUSH_OP, "Finished processing {}", smm);
            }
        }
        catch (ReplyException re) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.StateFlushOperation_STATE_FLUSH_TERMINATED_WITH_EXCEPTION), (Throwable)re);
            return false;
        }
        return true;
    }

    public static class StateFlushReplyProcessor
    extends ReplyProcessor21 {
        InternalDistributedMember targetMember;
        int originalCount;
        boolean targetMemberHasLeft;

        public StateFlushReplyProcessor(DM manager, Set initMembers, DistributedMember target) {
            super(manager, (Collection)initMembers);
            this.targetMember = (InternalDistributedMember)target;
            this.originalCount = initMembers.size();
            this.targetMemberHasLeft = this.targetMemberHasLeft || !manager.isCurrentMember((InternalDistributedMember)target);
        }

        public void messageNotSentTo(Set failures) {
            Iterator it = failures.iterator();
            while (it.hasNext()) {
                this.memberDeparted((InternalDistributedMember)it.next(), true);
            }
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            super.memberDeparted(id, crashed);
        }

        @Override
        protected void processActiveMembers(Set activeMembers) {
            super.processActiveMembers(activeMembers);
            if (!activeMembers.contains(this.targetMember)) {
                this.targetMemberHasLeft = true;
            }
        }

        @Override
        protected boolean stillWaiting() {
            this.targetMemberHasLeft = this.targetMemberHasLeft || !this.getDistributionManager().isCurrentMember(this.targetMember);
            return super.stillWaiting() && !this.targetMemberHasLeft;
        }

        @Override
        public String toString() {
            return "<" + this.shortName() + " " + this.getProcessorId() + " targeting " + this.targetMember + " waiting for " + this.numMembers() + " replies out of " + this.originalCount + " " + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + ">";
        }
    }

    public static final class StateStabilizedMessage
    extends ReplyMessage {
        protected DistributedMember sendingMember;

        @Override
        public InternalDistributedMember getSender() {
            return (InternalDistributedMember)this.sendingMember;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
                logger.trace(LogMarker.STATE_FLUSH_OP, "Processing {}", this);
            }
            super.process(dm, processor);
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            DataSerializer.writeObject(this.sendingMember, dout);
        }

        @Override
        public int getDSFID() {
            return -78;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.sendingMember = (DistributedMember)DataSerializer.readObject(din);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("StateStabilizedMessage ");
            sb.append(this.processorId);
            if (super.getSender() != null) {
                sb.append(" from ");
                sb.append(super.getSender());
            }
            if (this.getRecipients().length > 0) {
                String recip = this.getRecipientsDescription();
                sb.append(" to ");
                sb.append(recip);
            }
            sb.append(" on behalf of ");
            sb.append(this.sendingMember);
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }

    public static final class StateStabilizationMessage
    extends SerialDistributionMessage {
        protected DistributedMember requestingMember;
        protected int processorId;
        protected HashMap channelState;
        protected boolean isSingleFlushTo;

        public String channelStateDescription(Object state) {
            if (!(state instanceof Map)) {
                return "unknown channelState content";
            }
            Map csmap = (Map)state;
            StringBuffer result = new StringBuffer(200);
            Iterator it = csmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                result.append(entry.getKey()).append('=').append(entry.getValue());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            return result.toString();
        }

        @Override
        protected void process(final DistributionManager dm) {
            dm.getWaitingThreadPool().execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            dout.writeInt(this.processorId);
            DataSerializer.writeHashMap(this.channelState, dout);
            DataSerializer.writeObject(this.requestingMember, dout);
            dout.writeBoolean(this.isSingleFlushTo);
        }

        @Override
        public int getDSFID() {
            return -79;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.processorId = din.readInt();
            this.channelState = DataSerializer.readHashMap(din);
            this.requestingMember = (DistributedMember)DataSerializer.readObject(din);
            this.isSingleFlushTo = din.readBoolean();
        }

        @Override
        public String toString() {
            return "StateStabilizationMessage(recipients=" + this.getRecipientsDescription() + ",requestingMember=" + this.requestingMember + ",processorId=" + this.processorId + ")";
        }
    }

    public static final class StateMarkerMessage
    extends DistributionMessage
    implements MessageWithReply {
        public boolean flushNewOps;
        protected DistributedMember relayRecipient;
        protected int processorId;
        protected int processorType;
        protected String regionPath;
        protected DistributedRegion region;
        protected transient boolean severeAlertEnabled;
        protected boolean allRegions;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public final int getProcessorType() {
            return this.processorType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DistributedRegion getRegion(DistributionManager dm) {
            if (this.region != null) {
                return this.region;
            }
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                GemFireCacheImpl gfc = (GemFireCacheImpl)CacheFactory.getInstance(dm.getSystem());
                LocalRegion r = gfc.getRegionByPathForProcessing(this.regionPath);
                if (r instanceof DistributedRegion) {
                    this.region = (DistributedRegion)r;
                }
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
            return this.region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<DistributedRegion> getAllRegions(DistributionManager dm) {
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                GemFireCacheImpl gfc = (GemFireCacheImpl)CacheFactory.getInstance(dm.getSystem());
                HashSet<DistributedRegion> result = new HashSet<DistributedRegion>();
                for (LocalRegion r : gfc.getAllRegions()) {
                    if (!(r instanceof DistributedRegion) || r.isDestroyed) continue;
                    result.add((DistributedRegion)r);
                }
                HashSet<DistributedRegion> hashSet = result;
                return hashSet;
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(DistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            DataSerializer.writeObject(this.relayRecipient, dout);
            dout.writeInt(this.processorId);
            dout.writeInt(this.processorType);
            dout.writeBoolean(this.allRegions);
            if (!this.allRegions) {
                DataSerializer.writeString(this.regionPath, dout);
            }
        }

        @Override
        public int getDSFID() {
            return -80;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.relayRecipient = (DistributedMember)DataSerializer.readObject(din);
            this.processorId = din.readInt();
            this.processorType = din.readInt();
            this.allRegions = din.readBoolean();
            if (!this.allRegions) {
                this.regionPath = DataSerializer.readString(din);
            }
        }

        @Override
        public String toString() {
            return "StateMarkerMessage(requestingMember=" + this.getSender() + ",processorId=" + this.processorId + ",target=" + this.relayRecipient + ",region=" + this.regionPath + ")";
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return this.severeAlertEnabled;
        }
    }
}

