/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SendQueueOperation {
    private DM dm;
    private DistributedRegion r;
    private List l;
    private Role role;

    SendQueueOperation(DM dm, DistributedRegion r, List l, Role role) {
        this.dm = dm;
        this.r = r;
        this.l = l;
        this.role = role;
    }

    boolean distribute() {
        CacheDistributionAdvisor advisor = this.r.getCacheDistributionAdvisor();
        Set recipients = advisor.adviseCacheOpRole(this.role);
        if (recipients.isEmpty()) {
            return false;
        }
        ReplyProcessor21 processor = new ReplyProcessor21(this.dm, (Collection)recipients);
        SendQueueMessage msg = new SendQueueMessage();
        msg.setRecipients(recipients);
        msg.setRegionPath(this.r.getFullPath());
        msg.setProcessorId(processor.getProcessorId());
        msg.setOperations(this.l);
        this.dm.putOutgoing(msg);
        try {
            processor.waitForReplies();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ReplyException ex) {
            ex.handleAsUnexpected();
        }
        if (msg.getSuccessfulRecipients().isEmpty()) {
            return false;
        }
        this.r.getCachePerfStats().incReliableQueuedOps(-this.l.size());
        this.l.clear();
        return true;
    }

    public static final class SendQueueMessage
    extends SerialDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String regionPath;
        private List ops;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public void setProcessorId(int id) {
            this.processorId = id;
        }

        public String getRegionPath() {
            return this.regionPath;
        }

        public void setRegionPath(String rp) {
            this.regionPath = rp;
        }

        public void setOperations(List l) {
            this.ops = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            ReplyException rex = null;
            boolean ignored = false;
            try {
                GemFireCacheImpl gfc = (GemFireCacheImpl)CacheFactory.getInstance(dm.getSystem());
                LocalRegion lclRgn = gfc.getRegionByPathForProcessing(this.regionPath);
                if (lclRgn != null) {
                    lclRgn.waitOnInitialization();
                    long lastMod = gfc.cacheTimeMillis();
                    for (QueuedOperation op : this.ops) {
                        op.process(lclRgn, this.getSender(), lastMod);
                    }
                } else {
                    ignored = true;
                }
            }
            catch (RegionDestroyedException e) {
                ignored = true;
            }
            catch (CancelException e) {
                ignored = true;
            }
            finally {
                ReplyMessage.send(this.getSender(), this.processorId, rex, dm, ignored, false, false);
            }
        }

        @Override
        public int getDSFID() {
            return -81;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.processorId = in.readInt();
            int opCount = in.readInt();
            QueuedOperation[] ops = new QueuedOperation[opCount];
            for (int i = 0; i < opCount; ++i) {
                ops[i] = QueuedOperation.createFromData(in);
            }
            this.ops = Arrays.asList(ops);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeInt(this.processorId);
            int opCount = this.ops.size();
            out.writeInt(opCount);
            for (int i = 0; i < opCount; ++i) {
                QueuedOperation op = (QueuedOperation)this.ops.get(i);
                op.toData(out);
            }
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.getClass().getName());
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'");
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; queuedOps=");
            buff.append(this.ops.size());
            buff.append(")");
            return buff.toString();
        }
    }
}

