/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RoleEvent;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class RoleEventImpl
extends RegionEventImpl
implements RoleEvent,
DataSerializable {
    private static final long serialVersionUID = 1306615015229258945L;
    private Set requiredRoles;

    public RoleEventImpl() {
    }

    RoleEventImpl(Region region, Operation op, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, Set requiredRoles) {
        super(region, op, callbackArgument, originRemote, distributedMember);
        this.requiredRoles = Collections.unmodifiableSet(requiredRoles);
    }

    public Set getRequiredRoles() {
        return this.requiredRoles;
    }

    @Override
    public int getDSFID() {
        return 19;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        String[] requiredRoleNames = new String[this.requiredRoles.size()];
        Iterator iter = this.requiredRoles.iterator();
        for (int i = 0; i < requiredRoleNames.length; ++i) {
            Role role = (Role)iter.next();
            requiredRoleNames[i] = role.getName();
        }
        DataSerializer.writeStringArray(requiredRoleNames, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        String[] requiredRoleNames = DataSerializer.readStringArray(in);
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>(requiredRoleNames.length);
        for (int i = 0; i < requiredRoleNames.length; ++i) {
            InternalRole role = InternalRole.getRole(requiredRoleNames[i]);
            requiredRolesSet.add(role);
        }
        this.requiredRoles = Collections.unmodifiableSet(requiredRolesSet);
    }
}

