/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteRemoveAllMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData;
    private int removeAllDataCount = 0;
    ClientProxyMembershipID bridgeContext;
    private transient InternalDistributedSystem internalDs;
    private boolean posDup;
    protected static final short HAS_BRIDGE_CONTEXT = 64;
    private EventID eventId;
    private Object callbackArg;

    public void addEntry(DistributedRemoveAllOperation.RemoveAllEntryData entry) {
        this.removeAllData[this.removeAllDataCount++] = entry;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public int getSize() {
        return this.removeAllDataCount;
    }

    public static boolean distribute(EntryEventImpl event, DistributedRemoveAllOperation.RemoveAllEntryData[] data, int dataCount) {
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Collection<InternalDistributedMember> replicates = r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                RemoveAllResponse response = RemoteRemoveAllMessage.send(replicate, event, data, dataCount, false, 74, posDup);
                response.waitForCacheException();
                VersionedObjectList result = response.getResponse();
                List successfulKeys = result.getKeys();
                List<VersionTag> versions = result.getVersionTags();
                for (DistributedRemoveAllOperation.RemoveAllEntryData removeAllEntry : data) {
                    Object key2 = removeAllEntry.getKey();
                    if (!successfulKeys.contains(key2)) continue;
                    int index2 = successfulKeys.indexOf(key2);
                    removeAllEntry.versionTag = versions.get(index2);
                }
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteRemoveAllMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemoteRemoveAllMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    RemoteRemoveAllMessage(EntryEventImpl event, Set recipients, DirectReplyProcessor p, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate) {
        super(recipients, event.getRegion().getFullPath(), p);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.removeAllData = removeAllData;
        this.removeAllDataCount = removeAllDataCount;
        this.posDup = possibleDuplicate;
        this.eventId = event.getEventId();
        this.callbackArg = event.getCallbackArgument();
    }

    public RemoteRemoveAllMessage() {
    }

    public static RemoveAllResponse send(DistributedMember recipient, EntryEventImpl event, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoveAllResponse p = new RemoveAllResponse(event.getRegion().getSystem(), recipients);
        RemoteRemoveAllMessage msg = new RemoteRemoveAllMessage(event, recipients, p, removeAllData, removeAllDataCount, useOriginRemote, processorType, possibleDuplicate);
        Set failures = event.getRegion().getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemotePutMessage_FAILED_SENDING_0.toLocalizedString(msg));
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -6;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.callbackArg = DataSerializer.readObject(in);
        boolean bl = this.posDup = (this.flags & 8) != 0;
        if ((this.flags & 0x40) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        this.removeAllDataCount = (int)InternalDataSerializer.readUnsignedVL(in);
        this.removeAllData = new DistributedRemoveAllOperation.RemoveAllEntryData[this.removeAllDataCount];
        if (this.removeAllDataCount > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.removeAllDataCount; ++i) {
                this.removeAllData[i] = new DistributedRemoveAllOperation.RemoveAllEntryData(in, this.eventId, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.removeAllDataCount; ++i) {
                    this.removeAllData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.callbackArg, out);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        InternalDataSerializer.writeUnsignedVL(this.removeAllDataCount, out);
        if (this.removeAllDataCount > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllDataCount);
            boolean hasTags = false;
            boolean requiresRegionContext = this.removeAllData[0].key instanceof KeyWithRegionContext;
            for (int i = 0; i < this.removeAllDataCount; ++i) {
                if (!hasTags && this.removeAllData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.removeAllData[i].versionTag;
                versionTags.add(tag);
                this.removeAllData[i].versionTag = null;
                this.removeAllData[i].toData(out, requiresRegionContext);
                this.removeAllData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.posDup) {
            flags = (short)(flags | 8);
        }
        if (this.bridgeContext != null) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        boolean sendReply;
        InternalDistributedMember eventSender = this.getSender();
        try {
            sendReply = this.doLocalRemoveAll(r, eventSender);
        }
        catch (RemoteOperationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    public final boolean doLocalRemoveAll(final LocalRegion r, final InternalDistributedMember eventSender) throws EntryExistsException, RemoteOperationException {
        final DistributedRegion dr = (DistributedRegion)r;
        EntryEventImpl baseEvent = new EntryEventImpl(r, Operation.REMOVEALL_DESTROY, null, null, this.callbackArg, false, eventSender, true);
        baseEvent.setCausedByMessage(this);
        baseEvent.setEventId(this.eventId);
        if (this.bridgeContext != null) {
            baseEvent.setContext(this.bridgeContext);
        }
        baseEvent.setPossibleDuplicate(this.posDup);
        if (logger.isDebugEnabled()) {
            logger.debug("RemoteRemoveAllMessage.doLocalRemoveAll: eventSender is {}, baseEvent is {}, msg is {}", eventSender, baseEvent, this);
        }
        final DistributedRemoveAllOperation op = new DistributedRemoveAllOperation(baseEvent, this.removeAllDataCount, false);
        final VersionedObjectList versions = new VersionedObjectList(this.removeAllDataCount, true, dr.concurrencyChecksEnabled);
        dr.syncBulkOp(new Runnable(){

            @Override
            public void run() {
                InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < RemoteRemoveAllMessage.this.removeAllDataCount; ++i) {
                    EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(r, myId, eventSender, i, RemoteRemoveAllMessage.this.removeAllData, false, RemoteRemoveAllMessage.this.bridgeContext, RemoteRemoveAllMessage.this.posDup, false);
                    ev.setRemoveAllOperation(op);
                    if (logger.isDebugEnabled()) {
                        logger.debug("invoking basicDestroy with {}", ev);
                    }
                    try {
                        dr.basicDestroy(ev, true, null);
                    }
                    catch (EntryNotFoundException ignore) {
                        // empty catch block
                    }
                    ((RemoteRemoveAllMessage)RemoteRemoveAllMessage.this).removeAllData[i].versionTag = ev.getVersionTag();
                    versions.addKeyAndVersion(((RemoteRemoveAllMessage)RemoteRemoveAllMessage.this).removeAllData[i].key, ev.getVersionTag());
                }
            }
        }, baseEvent.getEventId());
        if (this.getTXUniqId() != -1 || dr.getConcurrencyChecksEnabled()) {
            dr.getDataView().postRemoveAll(op, versions, dr);
        }
        RemoveAllReplyMessage.send(this.getSender(), this.processorId, this.getReplySender(r.getDistributionManager()), versions, this.removeAllData, this.removeAllDataCount);
        return false;
    }

    RemoteOperationMessage.RemoteOperationResponse createReplyProcessor(LocalRegion r, Set recipients, Object key2) {
        return new RemoveAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), r != null && r.isInternalRegion());
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; removeAllDataCount=").append(this.removeAllDataCount);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        for (int i = 0; i < this.removeAllDataCount; ++i) {
            buff.append("; entry" + i + ":").append(this.removeAllData[i] == null ? "null" : this.removeAllData[i].getKey());
        }
    }

    public static class RemoveAllResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private VersionedObjectList versions;

        public RemoveAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, false);
        }

        public void setResponse(RemoveAllReplyMessage removeAllReplyMessage) {
            if (removeAllReplyMessage.versions != null) {
                this.versions = removeAllReplyMessage.versions;
                this.versions.replaceNullIDs(removeAllReplyMessage.getSender());
            }
        }

        public VersionedObjectList getResponse() {
            return this.versions;
        }
    }

    public static final class RemoveAllReplyMessage
    extends ReplyMessage {
        private VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        private RemoveAllReplyMessage(int processorId, VersionedObjectList versionList, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllCount) {
            this.versions = versionList;
            this.setProcessorId(processorId);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, VersionedObjectList versions, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount) {
            Assert.assertTrue(recipient != null, "RemoveAllReplyMessage NULL reply message");
            RemoveAllReplyMessage m = new RemoveAllReplyMessage(processorId, versions, removeAllData, removeAllDataCount);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("RemoveAllReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof RemoveAllResponse) {
                RemoveAllResponse processor = (RemoveAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", rp, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -5;
        }

        public RemoveAllReplyMessage() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoveAllReplyMessage ").append(" processorid=").append(this.processorId).append(" returning versionTags=").append(this.versions);
            return sb.toString();
        }
    }
}

