/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemotePutMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private static final short FLAG_IFNEW = 1;
    private static final short FLAG_IFOLD = 2;
    private static final short FLAG_REQUIREOLDVALUE = 4;
    private static final short FLAG_HASOLDVALUE = 8;
    private static final short FLAG_HASDELTA = 16;
    private static final short FLAG_HASDELTABYTES = 32;
    private static final short FLAG_OLDVALUEISSERIALIZED = 64;
    private static final short FLAG_USEORIGINREMOTE = 128;
    private static final short FLAG_POSSIBLEDUPLICATE = 256;
    private Object key;
    private byte[] valBytes;
    private byte[] oldValBytes;
    private transient Object valObj;
    private transient Object oldValObj;
    private Object cbArg;
    protected long lastModified;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    protected byte deserializationPolicy = 0;
    protected boolean oldValueIsSerialized = false;
    private boolean ifNew;
    private boolean ifOld;
    private boolean requireOldValue;
    private Object expectedOldValue;
    private VersionTag versionTag;
    private transient InternalDistributedSystem internalDs;
    transient boolean result = false;
    private boolean hasOldValue = false;
    private boolean hasDelta = false;
    private transient boolean applyDeltaBytes = false;
    private transient byte[] deltaBytes;
    private transient boolean sendDelta = false;
    private EntryEventImpl event = null;
    private boolean useOriginRemote;
    private boolean possibleDuplicate;
    private Collection cacheOpRecipients;
    protected static final short IF_NEW = 64;
    protected static final short IF_OLD = 128;
    protected static final short REQUIRED_OLD_VAL = 256;
    protected static final short HAS_OLD_VAL = 512;
    protected static final short HAS_DELTA_BYTES = 1024;
    protected static final short USE_ORIGIN_REMOTE = 2048;
    protected static final short CACHE_WRITE = 4096;
    protected static final short HAS_EXPECTED_OLD_VAL = 8192;
    protected static final int HAS_BRIDGE_CONTEXT = RemotePutMessage.getNextByteMask(DistributedCacheOperation.DESERIALIZATION_POLICY_END);
    protected static final int HAS_ORIGINAL_SENDER = RemotePutMessage.getNextByteMask(HAS_BRIDGE_CONTEXT);
    protected static final int HAS_VERSION_TAG = RemotePutMessage.getNextByteMask(HAS_ORIGINAL_SENDER);
    protected static final int HAS_CALLBACKARG = RemotePutMessage.getNextByteMask(HAS_VERSION_TAG);

    public RemotePutMessage() {
    }

    private RemotePutMessage(Set recipients, String regionPath, DirectReplyProcessor processor, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean useOriginRemote, int processorType, boolean possibleDuplicate) {
        super(recipients, regionPath, processor);
        CachedDeserializable cd2;
        this.processor = processor;
        this.requireOldValue = requireOldValue;
        this.expectedOldValue = expectedOldValue;
        this.useOriginRemote = useOriginRemote;
        this.key = event.getKey();
        this.processorType = processorType;
        this.possibleDuplicate = possibleDuplicate;
        event.setOriginRemote(useOriginRemote);
        if (event.hasNewValue()) {
            Object v;
            cd2 = (CachedDeserializable)((Object)event.getSerializedNewValue());
            if (cd2 != null) {
                this.deserializationPolicy = (byte)2;
                v = cd2.getValue();
                if (v instanceof byte[]) {
                    this.setValBytes((byte[])v);
                } else {
                    this.setValObj(v);
                }
            } else {
                v = event.getRawNewValue();
                if (v instanceof byte[]) {
                    this.deserializationPolicy = 0;
                    this.setValBytes((byte[])v);
                } else if (event.hasDelta()) {
                    this.deserializationPolicy = 1;
                    if (event.getCachedSerializedNewValue() != null) {
                        this.setValBytes(event.getCachedSerializedNewValue());
                    } else {
                        this.setValObj(v);
                    }
                } else {
                    this.deserializationPolicy = (byte)2;
                    if (event.getCachedSerializedNewValue() != null) {
                        this.setValBytes(event.getCachedSerializedNewValue());
                    } else {
                        this.setValObj(v);
                    }
                }
            }
        } else assert (this.deserializationPolicy == 0) : this.deserializationPolicy;
        if (event.hasOldValue()) {
            this.hasOldValue = true;
            cd2 = (CachedDeserializable)((Object)event.getSerializedOldValue());
            if (cd2 != null) {
                this.oldValueIsSerialized = true;
                Object o = cd2.getValue();
                if (o instanceof byte[]) {
                    this.setOldValBytes((byte[])o);
                } else {
                    this.setOldValObj(o);
                }
            } else {
                Object old = event.getRawOldValue();
                if (old instanceof byte[]) {
                    this.oldValueIsSerialized = false;
                    this.setOldValBytes((byte[])old);
                } else {
                    this.oldValueIsSerialized = true;
                    this.setOldValObj(old);
                }
            }
        }
        this.event = event;
        this.cbArg = event.getRawCallbackArgument();
        this.lastModified = lastModified;
        this.op = event.getOperation();
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        Assert.assertTrue(this.eventId != null);
        this.ifNew = ifNew;
        this.ifOld = ifOld;
        this.versionTag = event.getVersionTag();
    }

    public static boolean distribute(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean onlyPersistent) {
        Collection<InternalDistributedMember> replicates;
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Set<InternalDistributedMember> set = replicates = onlyPersistent ? r.getCacheDistributionAdvisor().adviseInitializedPersistentMembers().keySet() : r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("performing remote put messaging for {}", event);
        }
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                RemotePutResponse response = RemotePutMessage.send(replicate, event.getRegion(), event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, false, 74, posDup);
                PutResult result = response.waitForResult();
                event.setOldValue(result.oldValue, true);
                event.setOperation(result.op);
                if (result.versionTag != null) {
                    event.setVersionTag(result.versionTag);
                    if (event.getRegion().getVersionVector() != null) {
                        event.getRegion().getVersionVector().recordVersion(result.versionTag.getMemberID(), result.versionTag);
                    }
                }
                event.setInhibitDistribution(true);
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemotePutMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemotePutMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static RemotePutResponse txSend(DistributedMember recipient, LocalRegion r, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws RemoteOperationException {
        return RemotePutMessage.send(recipient, r, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, true, 78, false);
    }

    public static RemotePutResponse send(DistributedMember recipient, LocalRegion r, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean useOriginRemote, int processorType, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemotePutResponse processor = new RemotePutResponse(r.getSystem(), recipients, event.getKey(), false);
        RemotePutMessage m = new RemotePutMessage(recipients, r.getFullPath(), processor, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, useOriginRemote, processorType, possibleDuplicate);
        m.setInternalDs(r.getSystem());
        m.setSendDelta(true);
        processor.setRemotePutMessage(m);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemotePutMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return processor;
    }

    public final Object getKey() {
        return this.key;
    }

    public final void setKey(Object key2) {
        this.key = key2;
    }

    public final byte[] getValBytes() {
        return this.valBytes;
    }

    public final byte[] getOldValueBytes() {
        return this.oldValBytes;
    }

    private void setValBytes(byte[] valBytes) {
        this.valBytes = valBytes;
    }

    private void setOldValBytes(byte[] valBytes) {
        this.oldValBytes = valBytes;
    }

    private Object getOldValObj() {
        return this.oldValObj;
    }

    private void setValObj(Object o) {
        this.valObj = o;
    }

    private void setOldValObj(Object o) {
        this.oldValObj = o;
    }

    public final Object getCallbackArg() {
        return this.cbArg;
    }

    protected final Operation getOperation() {
        return this.op;
    }

    @Override
    public final void setOperation(Operation operation) {
        this.op = operation;
    }

    @Override
    public void setCacheOpRecipients(Collection cacheOpRecipients) {
        this.cacheOpRecipients = cacheOpRecipients;
    }

    @Override
    public void setHasOldValue(boolean value2) {
        this.hasOldValue = value2;
    }

    @Override
    public int getDSFID() {
        return -29;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.setKey(DataSerializer.readObject(in));
        int extraFlags = in.readUnsignedByte();
        this.deserializationPolicy = (byte)(extraFlags & DistributedCacheOperation.DESERIALIZATION_POLICY_MASK);
        this.cbArg = DataSerializer.readObject(in);
        this.lastModified = in.readLong();
        this.op = Operation.fromOrdinal(in.readByte());
        if ((extraFlags & HAS_BRIDGE_CONTEXT) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        if ((extraFlags & HAS_ORIGINAL_SENDER) != 0) {
            this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        this.eventId = new EventID();
        InternalDataSerializer.invokeFromData(this.eventId, in);
        if ((this.flags & 0x2000) != 0) {
            this.expectedOldValue = DataSerializer.readObject(in);
        }
        if (this.hasOldValue) {
            this.oldValueIsSerialized = in.readByte() == 1;
            this.setOldValBytes(DataSerializer.readByteArray(in));
        }
        if (this.deserializationPolicy == 1) {
            this.setValObj(DataSerializer.readObject(in));
        } else {
            this.setValBytes(DataSerializer.readByteArray(in));
        }
        if ((this.flags & 0x400) != 0) {
            this.applyDeltaBytes = true;
            this.deltaBytes = DataSerializer.readByteArray(in);
        }
        if ((extraFlags & HAS_VERSION_TAG) != 0) {
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }
    }

    @Override
    protected void setFlags(short flags, DataInput in) throws IOException, ClassNotFoundException {
        super.setFlags(flags, in);
        this.ifNew = (flags & 0x40) != 0;
        this.ifOld = (flags & 0x80) != 0;
        this.requireOldValue = (flags & 0x100) != 0;
        this.hasOldValue = (flags & 0x200) != 0;
        this.useOriginRemote = (flags & 0x800) != 0;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    public int getProcessorType() {
        return this.processorType;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        this.hasDelta = false;
        super.toData(out);
        DataSerializer.writeObject(this.getKey(), out);
        int extraFlags = this.deserializationPolicy;
        if (this.bridgeContext != null) {
            extraFlags |= HAS_BRIDGE_CONTEXT;
        }
        if (this.originalSender != null) {
            extraFlags |= HAS_ORIGINAL_SENDER;
        }
        if (this.versionTag != null) {
            extraFlags |= HAS_VERSION_TAG;
        }
        out.writeByte(extraFlags);
        DataSerializer.writeObject(this.getCallbackArg(), out);
        out.writeLong(this.lastModified);
        out.writeByte(this.op.ordinal);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        if (this.originalSender != null) {
            DataSerializer.writeObject(this.originalSender, out);
        }
        InternalDataSerializer.invokeToData(this.eventId, out);
        if (this.expectedOldValue != null) {
            DataSerializer.writeObject(this.expectedOldValue, out);
        }
        if (this.hasOldValue) {
            out.writeByte(this.oldValueIsSerialized ? 1 : 0);
            if (this.oldValueIsSerialized) {
                DataSerializer.writeObjectAsByteArray(this.getOldValObj(), out);
            } else {
                DataSerializer.writeByteArray(this.getOldValueBytes(), out);
            }
        }
        byte[] newValBytes = null;
        if (this.valObj != null) {
            newValBytes = BlobHelper.serializeToBlob(this.valObj);
            this.event.setCachedSerializedNewValue(newValBytes);
        } else {
            newValBytes = this.getValBytes();
        }
        if (this.deserializationPolicy == 1) {
            out.write(newValBytes);
        } else {
            DataSerializer.writeByteArray(newValBytes, out);
        }
        if (this.event.getDeltaBytes() != null) {
            DataSerializer.writeByteArray(this.event.getDeltaBytes(), out);
        }
        if (this.versionTag != null) {
            DataSerializer.writeObject(this.versionTag, out);
        }
    }

    @Override
    protected short computeCompressedShort() {
        short s = super.computeCompressedShort();
        if (this.ifNew) {
            s = (short)(s | 0x40);
        }
        if (this.ifOld) {
            s = (short)(s | 0x80);
        }
        if (this.requireOldValue) {
            s = (short)(s | 0x100);
        }
        if (this.hasOldValue) {
            s = (short)(s | 0x200);
        }
        if (this.event.getDeltaBytes() != null) {
            s = (short)(s | 0x400);
        }
        if (this.expectedOldValue != null) {
            s = (short)(s | 0x2000);
        }
        if (this.useOriginRemote) {
            s = (short)(s | 0x800);
        }
        if (this.possibleDuplicate) {
            s = (short)(s | 8);
        }
        return s;
    }

    @Override
    protected final boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws EntryExistsException, RemoteOperationException {
        this.setInternalDs(r.getSystem());
        boolean sendReply = true;
        InternalDistributedMember eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        if (r.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)this.key).setRegionContext(r);
        }
        this.event = new EntryEventImpl(r, this.getOperation(), this.getKey(), null, this.getCallbackArg(), this.useOriginRemote, (DistributedMember)eventSender, true, false);
        if (this.versionTag != null) {
            this.versionTag.replaceNullIDs(this.getSender());
            this.event.setVersionTag(this.versionTag);
        }
        this.event.setCausedByMessage(this);
        this.event.setPossibleDuplicate(this.possibleDuplicate);
        if (this.bridgeContext != null) {
            this.event.setContext(this.bridgeContext);
        }
        Assert.assertTrue(this.eventId != null);
        this.event.setEventId(this.eventId);
        if (this.hasOldValue) {
            if (this.oldValueIsSerialized) {
                this.event.setSerializedOldValue(this.getOldValueBytes());
            } else {
                this.event.setOldValue(this.getOldValueBytes());
            }
        }
        if (this.applyDeltaBytes) {
            this.event.setNewValue(this.valObj);
            this.event.setDeltaBytes(this.deltaBytes);
        } else {
            switch (this.deserializationPolicy) {
                case 2: {
                    this.event.setSerializedNewValue(this.getValBytes());
                    break;
                }
                case 0: {
                    this.event.setNewValue(this.getValBytes());
                    break;
                }
                case 1: {
                    this.event.setNewValue(this.valObj);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown deserialization policy: " + this.deserializationPolicy));
                }
            }
        }
        try {
            this.result = r.getDataView().putEntry(this.event, this.ifNew, this.ifOld, this.expectedOldValue, this.requireOldValue, this.lastModified, true);
            if (!this.result) {
                r.checkReadiness();
                if (!this.ifNew && !this.ifOld) {
                    RemoteOperationException fre = new RemoteOperationException(LocalizedStrings.RemotePutMessage_UNABLE_TO_PERFORM_PUT_BUT_OPERATION_SHOULD_NOT_FAIL_0.toLocalizedString());
                    fre.setHash(this.key.hashCode());
                    this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(fre), r, startTime);
                }
            }
        }
        catch (CacheWriterException cwe) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(cwe), r, startTime);
            return false;
        }
        catch (PrimaryBucketException pbe) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
            return false;
        }
        this.setOperation(this.event.getOperation());
        if (sendReply) {
            Object oldValue = null;
            if (this.requireOldValue && (oldValue = this.event.getSerializedOldValue()) == null) {
                oldValue = this.event.getRawOldValue();
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime, oldValue, this.event);
        }
        return false;
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion pr2, long startTime, Object oldValue, EntryEventImpl event) {
        Collection distributedTo = null;
        if (this.processorId != 0) {
            distributedTo = this.cacheOpRecipients;
        }
        PutReplyMessage.send(member, procId, this.getReplySender(dm), this.result, this.getOperation(), ex, oldValue, event);
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        byte[] ov;
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey()).append("; value=");
        buff.append(this.getValBytes() == null ? this.valObj : "(" + this.getValBytes().length + " bytes)");
        buff.append("; callback=").append(this.cbArg).append("; op=").append(this.op);
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        buff.append("; ifOld=").append(this.ifOld).append("; ifNew=").append(this.ifNew).append("; op=").append(this.getOperation());
        buff.append("; hadOldValue=").append(this.hasOldValue);
        if (this.hasOldValue && (ov = this.getOldValueBytes()) != null) {
            buff.append("; oldValueLength=").append(ov.length);
        }
        buff.append("; deserializationPolicy=");
        buff.append(DistributedCacheOperation.deserializationPolicyToString(this.deserializationPolicy));
        buff.append("; hasDelta=");
        buff.append(this.hasDelta);
        buff.append("; sendDelta=");
        buff.append(this.sendDelta);
        buff.append("; isDeltaApplied=");
        buff.append(this.applyDeltaBytes);
    }

    public final InternalDistributedSystem getInternalDs() {
        return this.internalDs;
    }

    public final void setInternalDs(InternalDistributedSystem internalDs) {
        this.internalDs = internalDs;
    }

    public void setSendDelta(boolean sendDelta) {
        this.sendDelta = sendDelta;
    }

    public static class PutResult {
        public boolean returnValue;
        public Operation op;
        public Object oldValue;
        public VersionTag versionTag;

        public PutResult(boolean flag, Operation actualOperation, Object oldValue, VersionTag versionTag) {
            this.returnValue = flag;
            this.op = actualOperation;
            this.oldValue = oldValue;
            this.versionTag = versionTag;
        }
    }

    public static class RemotePutResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile boolean returnValue;
        private volatile Operation op;
        private volatile Object oldValue;
        private final Object key;
        private RemotePutMessage putMessage;
        private VersionTag versionTag;

        public RemotePutResponse(InternalDistributedSystem ds, Collection recipients, Object key2, boolean register) {
            super(ds, recipients, register);
            this.key = key2;
        }

        public void setRemotePutMessage(RemotePutMessage putMessage) {
            this.putMessage = putMessage;
        }

        public RemotePutMessage getRemotePutMessage() {
            return this.putMessage;
        }

        public void setResponse(PutReplyMessage msg) {
            this.returnValue = msg.result;
            this.op = msg.op;
            this.oldValue = msg.getOldValue();
            this.versionTag = msg.versionTag;
        }

        public PutResult waitForResult() throws CacheException, RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (this.op == null) {
                throw new RemoteOperationException(LocalizedStrings.RemotePutMessage_DID_NOT_RECEIVE_A_VALID_REPLY.toLocalizedString());
            }
            return new PutResult(this.returnValue, this.op, this.oldValue, this.versionTag);
        }
    }

    public static final class PutReplyMessage
    extends ReplyMessage {
        static final byte FLAG_RESULT = 1;
        static final byte FLAG_HASVERSION = 2;
        static final byte FLAG_PERSISTENT = 4;
        boolean result;
        Operation op;
        Object oldValue;
        VersionTag versionTag;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public PutReplyMessage() {
        }

        private PutReplyMessage(int processorId, boolean result, Operation op, ReplyException ex, Object oldValue, VersionTag versionTag) {
            this.op = op;
            this.result = result;
            this.setProcessorId(processorId);
            this.setException(ex);
            this.oldValue = oldValue;
            this.versionTag = versionTag;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, boolean result, Operation op, ReplyException ex, Object oldValue, EntryEventImpl event) {
            Assert.assertTrue(recipient != null, "PutReplyMessage NULL recipient");
            PutReplyMessage m = new PutReplyMessage(processorId, result, op, ex, oldValue, event.getVersionTag());
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isDebugEnabled()) {
                logger.debug("Processing {}", this);
            }
            if (rp == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PutReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof RemotePutResponse) {
                RemotePutResponse processor = (RemotePutResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", rp, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        public Object getOldValue() {
            if (this.oldValue instanceof CachedDeserializable) {
                return ((CachedDeserializable)this.oldValue).getDeserializedValue(null, null);
            }
            return this.oldValue;
        }

        @Override
        public int getDSFID() {
            return -28;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            byte flags = (byte)(in.readByte() & 0xFF);
            this.result = (flags & 1) != 0;
            this.op = Operation.fromOrdinal(in.readByte());
            this.oldValue = DataSerializer.readObject(in);
            if ((flags & 2) != 0) {
                boolean persistentTag = (flags & 4) != 0;
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            byte flags = 0;
            if (this.result) {
                flags = (byte)(flags | 1);
            }
            if (this.versionTag != null) {
                flags = (byte)(flags | 2);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                flags = (byte)(flags | 4);
            }
            out.writeByte(flags);
            out.writeByte(this.op.ordinal);
            DataSerializer.writeObject(this.oldValue, out);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PutReplyMessage ").append("processorid=").append(this.processorId).append(" returning ").append(this.result).append(" op=").append(this.op).append(" exception=").append(this.getException());
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            return sb.toString();
        }
    }
}

