/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.partitioned.PutAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemotePutAllMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedPutAllOperation.PutAllEntryData[] putAllData;
    private int putAllDataCount = 0;
    ClientProxyMembershipID bridgeContext;
    private boolean posDup;
    protected static final short HAS_BRIDGE_CONTEXT = 64;
    protected static final short SKIP_CALLBACKS = 128;
    private EventID eventId;
    private boolean skipCallbacks;
    private Object callbackArg;

    public void addEntry(DistributedPutAllOperation.PutAllEntryData entry) {
        this.putAllData[this.putAllDataCount++] = entry;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public int getSize() {
        return this.putAllDataCount;
    }

    public static boolean distribute(EntryEventImpl event, DistributedPutAllOperation.PutAllEntryData[] data, int dataCount) {
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Collection<InternalDistributedMember> replicates = r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                PutAllResponse response = RemotePutAllMessage.send(replicate, event, data, dataCount, false, 74, posDup);
                response.waitForCacheException();
                VersionedObjectList result = response.getResponse();
                List successfulKeys = result.getKeys();
                List<VersionTag> versions = result.getVersionTags();
                for (DistributedPutAllOperation.PutAllEntryData putAllEntry : data) {
                    Object key2 = putAllEntry.getKey();
                    if (!successfulKeys.contains(key2)) continue;
                    int index2 = successfulKeys.indexOf(key2);
                    putAllEntry.versionTag = versions.get(index2);
                }
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemotePutMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemotePutMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    RemotePutAllMessage(EntryEventImpl event, Set recipients, DirectReplyProcessor p, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate, boolean skipCallbacks) {
        super(recipients, event.getRegion().getFullPath(), p);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.putAllData = putAllData;
        this.putAllDataCount = putAllDataCount;
        this.posDup = possibleDuplicate;
        this.eventId = event.getEventId();
        this.skipCallbacks = skipCallbacks;
        this.callbackArg = event.getCallbackArgument();
    }

    public RemotePutAllMessage() {
    }

    public static PutAllResponse send(DistributedMember recipient, EntryEventImpl event, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        PutAllResponse p = new PutAllResponse(event.getRegion().getSystem(), recipients);
        RemotePutAllMessage msg = new RemotePutAllMessage(event, recipients, p, putAllData, putAllDataCount, useOriginRemote, processorType, possibleDuplicate, !event.isGenerateCallbacks());
        Set failures = event.getRegion().getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemotePutMessage_FAILED_SENDING_0.toLocalizedString(msg));
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -119;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.eventId = (EventID)DataSerializer.readObject(in);
        Version sourceVersion = InternalDataSerializer.getVersionForDataStream(in);
        if (sourceVersion.compareTo(Version.GFE_81) >= 0) {
            this.callbackArg = DataSerializer.readObject(in);
        }
        boolean bl = this.posDup = (this.flags & 8) != 0;
        if ((this.flags & 0x40) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        this.skipCallbacks = (this.flags & 0x80) != 0;
        this.putAllDataCount = (int)InternalDataSerializer.readUnsignedVL(in);
        this.putAllData = new DistributedPutAllOperation.PutAllEntryData[this.putAllDataCount];
        if (this.putAllDataCount > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.putAllDataCount; ++i) {
                this.putAllData[i] = new DistributedPutAllOperation.PutAllEntryData(in, this.eventId, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.putAllDataCount; ++i) {
                    this.putAllData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.eventId, out);
        Version receiverVersion = InternalDataSerializer.getVersionForDataStream(out);
        if (receiverVersion.compareTo(Version.GFE_81) >= 0) {
            DataSerializer.writeObject(this.callbackArg, out);
        }
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        InternalDataSerializer.writeUnsignedVL(this.putAllDataCount, out);
        if (this.putAllDataCount > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllDataCount);
            boolean hasTags = false;
            boolean requiresRegionContext = this.putAllData[0].key instanceof KeyWithRegionContext;
            for (int i = 0; i < this.putAllDataCount; ++i) {
                if (!hasTags && this.putAllData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.putAllData[i].versionTag;
                versionTags.add(tag);
                this.putAllData[i].versionTag = null;
                this.putAllData[i].toData(out, requiresRegionContext);
                this.putAllData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.posDup) {
            flags = (short)(flags | 8);
        }
        if (this.bridgeContext != null) {
            flags = (short)(flags | 0x40);
        }
        if (this.skipCallbacks) {
            flags = (short)(flags | 0x80);
        }
        return flags;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        boolean sendReply;
        InternalDistributedMember eventSender = this.getSender();
        long lastModified = 0L;
        try {
            sendReply = this.doLocalPutAll(r, eventSender, lastModified);
        }
        catch (RemoteOperationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    public final boolean doLocalPutAll(final LocalRegion r, final InternalDistributedMember eventSender, long lastModified) throws EntryExistsException, RemoteOperationException {
        final DistributedRegion dr = (DistributedRegion)r;
        EntryEventImpl baseEvent = new EntryEventImpl(r, Operation.PUTALL_CREATE, null, null, this.callbackArg, false, eventSender, !this.skipCallbacks);
        baseEvent.setCausedByMessage(this);
        baseEvent.setEventId(this.eventId);
        if (this.bridgeContext != null) {
            baseEvent.setContext(this.bridgeContext);
        }
        baseEvent.setPossibleDuplicate(this.posDup);
        if (logger.isDebugEnabled()) {
            logger.debug("RemotePutAllMessage.doLocalPutAll: eventSender is {}, baseEvent is {}, msg is {}", eventSender, baseEvent, this);
        }
        final DistributedPutAllOperation dpao = new DistributedPutAllOperation(baseEvent, this.putAllDataCount, false);
        final VersionedObjectList versions = new VersionedObjectList(this.putAllDataCount, true, dr.concurrencyChecksEnabled);
        dr.syncBulkOp(new Runnable(){

            @Override
            public void run() {
                InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < RemotePutAllMessage.this.putAllDataCount; ++i) {
                    EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i, RemotePutAllMessage.this.putAllData, false, RemotePutAllMessage.this.bridgeContext, RemotePutAllMessage.this.posDup, !RemotePutAllMessage.this.skipCallbacks);
                    ev.setPutAllOperation(dpao);
                    if (logger.isDebugEnabled()) {
                        logger.debug("invoking basicPut with {}", ev);
                    }
                    if (!dr.basicPut(ev, false, false, null, false)) continue;
                    ((RemotePutAllMessage)RemotePutAllMessage.this).putAllData[i].versionTag = ev.getVersionTag();
                    versions.addKeyAndVersion(((RemotePutAllMessage)RemotePutAllMessage.this).putAllData[i].key, ev.getVersionTag());
                }
            }
        }, baseEvent.getEventId());
        if (this.getTXUniqId() != -1 || dr.getConcurrencyChecksEnabled()) {
            dr.getDataView().postPutAll(dpao, versions, dr);
        }
        PutAllReplyMessage.send(this.getSender(), this.processorId, this.getReplySender(r.getDistributionManager()), versions, this.putAllData, this.putAllDataCount);
        return false;
    }

    RemoteOperationMessage.RemoteOperationResponse createReplyProcessor(LocalRegion r, Set recipients, Object key2) {
        return new PutAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), r != null && r.isInternalRegion());
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; putAllDataCount=").append(this.putAllDataCount);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        for (int i = 0; i < this.putAllDataCount; ++i) {
            buff.append("; entry" + i + ":").append(this.putAllData[i] == null ? "null" : this.putAllData[i].getKey());
        }
    }

    public static class PutAllResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private VersionedObjectList versions;

        public PutAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, false);
        }

        public void setResponse(PutAllReplyMessage putAllReplyMessage) {
            if (putAllReplyMessage.versions != null) {
                this.versions = putAllReplyMessage.versions;
                this.versions.replaceNullIDs(putAllReplyMessage.getSender());
            }
        }

        public VersionedObjectList getResponse() {
            return this.versions;
        }
    }

    public static final class PutAllReplyMessage
    extends ReplyMessage {
        private VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        private PutAllReplyMessage(int processorId, VersionedObjectList versionList, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllCount) {
            this.versions = versionList;
            this.setProcessorId(processorId);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, VersionedObjectList versions, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount) {
            Assert.assertTrue(recipient != null, "PutAllReplyMessage NULL reply message");
            PutAllReplyMessage m = new PutAllReplyMessage(processorId, versions, putAllData, putAllDataCount);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "PutAllReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof PutAllResponse) {
                PutAllResponse processor = (PutAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", rp, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -121;
        }

        public PutAllReplyMessage() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PutAllReplyMessage ").append(" processorid=").append(this.processorId).append(" returning versionTags=").append(this.versions);
            return sb.toString();
        }
    }
}

