/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteGetMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private ClientProxyMembershipID context;

    public RemoteGetMessage() {
    }

    private RemoteGetMessage(InternalDistributedMember recipient, String regionPath, DirectReplyProcessor processor, Object key2, Object aCallbackArgument, ClientProxyMembershipID context) {
        super(recipient, regionPath, processor);
        this.key = key2;
        this.cbArg = aCallbackArgument;
        this.context = context;
    }

    @Override
    public final int getProcessorType() {
        return 74;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        BucketRegion.RawValue valueBytes;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "RemoteGetMessage operateOnRegion: {}", r.getFullPath());
        }
        if (this.getTXUniqId() != -1) assert (r.getDataView() instanceof TXStateProxy);
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        try {
            if (r.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(r);
            }
            KeyInfo keyInfo = r.getKeyInfo(this.key, this.cbArg);
            Object val = r.getDataView().getSerializedValue(r, keyInfo, false, this.context, null, false);
            valueBytes = val instanceof BucketRegion.RawValue ? (BucketRegion.RawValue)val : new BucketRegion.RawValue(val);
        }
        catch (DistributedSystemDisconnectedException sde) {
            this.sendReply(this.getSender(), this.processorId, dm, new ReplyException(new RemoteOperationException(LocalizedStrings.GetMessage_OPERATION_GOT_INTERRUPTED_DUE_TO_SHUTDOWN_IN_PROGRESS_ON_REMOTE_VM.toLocalizedString(), sde)), r, startTime);
            return false;
        }
        catch (PrimaryBucketException pbe) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
            return false;
        }
        catch (DataLocationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            return false;
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "GetMessage sending serialized value {} back via GetReplyMessage using processorId: {}", valueBytes, this.getProcessorId());
        }
        GetReplyMessage.send(this.getSender(), this.getProcessorId(), valueBytes, this.getReplySender(dm));
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key).append("; callback arg=").append(this.cbArg);
    }

    @Override
    public int getDSFID() {
        return -24;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.cbArg = DataSerializer.readObject(in);
        this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.cbArg, out);
        DataSerializer.writeObject(this.context, out);
    }

    public void setKey(Object key2) {
        this.key = key2;
    }

    public static RemoteGetResponse send(InternalDistributedMember recipient, LocalRegion r, Object key2, Object aCallbackArgument, ClientProxyMembershipID requestingClient) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
        RemoteGetResponse p = new RemoteGetResponse(r.getSystem(), Collections.singleton(recipient), key2);
        RemoteGetMessage m = new RemoteGetMessage(recipient, r.getFullPath(), p, key2, aCallbackArgument, requestingClient);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.GetMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static class RemoteGetResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile GetReplyMessage getReply;
        private volatile boolean returnValueReceived;
        private volatile long start;
        final Object key;

        public RemoteGetResponse(InternalDistributedSystem ds, Set recipients, Object key2) {
            super(ds, (Collection)recipients, false);
            this.key = key2;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof GetReplyMessage) {
                GetReplyMessage reply = (GetReplyMessage)msg;
                if (reply.valueInBytes != null) {
                    this.getReply = reply;
                }
                this.returnValueReceived = true;
            }
            super.process(msg);
        }

        public Object getValue(boolean preferCD) throws RemoteOperationException {
            GetReplyMessage reply = this.getReply;
            try {
                if (reply != null) {
                    if (reply.valueIsByteArray) {
                        return reply.valueInBytes;
                    }
                    if (preferCD) {
                        return CachedDeserializableFactory.create(reply.valueInBytes);
                    }
                    return BlobHelper.deserializeBlob(reply.valueInBytes, reply.remoteVersion, null);
                }
                return null;
            }
            catch (IOException e) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_IOEXCEPTION.toLocalizedString(), e);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_CLASSNOTFOUNDEXCEPTION.toLocalizedString(), e);
            }
        }

        public Object waitForResponse(boolean preferCD) throws RemoteOperationException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                String msg = "RemoteGetResponse got RemoteOperationException; rethrowing";
                logger.debug("RemoteGetResponse got RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.getValue(preferCD);
        }
    }

    public static final class GetReplyMessage
    extends ReplyMessage {
        private transient BucketRegion.RawValue rawVal;
        public boolean valueIsByteArray;
        public transient byte[] valueInBytes;
        public transient Version remoteVersion;

        public GetReplyMessage() {
        }

        private GetReplyMessage(int processorId, BucketRegion.RawValue val) {
            this.setProcessorId(processorId);
            this.rawVal = val;
            this.valueIsByteArray = val.isValueByteArray();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, BucketRegion.RawValue val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            GetReplyMessage m = new GetReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "GetReplyMessage process invoking reply processor with processorId:{}", this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.DM, "GetReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "{} Processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -25;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.valueIsByteArray ? 1 : 0);
            this.rawVal.writeAsByteArray(out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.valueIsByteArray = in.readByte() == 1;
            this.valueInBytes = DataSerializer.readByteArray(in);
            if (!this.valueIsByteArray) {
                this.remoteVersion = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GetReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning serialized value=").append(this.rawVal);
            return sb.toString();
        }
    }
}

