/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.internal.BridgePoolImpl;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Logger;

public class PoolFactoryImpl
implements PoolFactory {
    private static final Logger logger = LogService.getLogger();
    private PoolAttributes attributes = new PoolAttributes();
    private final PoolManagerImpl pm;

    public PoolFactoryImpl(PoolManagerImpl pm) {
        this.pm = pm;
    }

    @Override
    public PoolFactory setFreeConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout <= 0) {
            throw new IllegalArgumentException("connectionTimeout must be greater than zero");
        }
        this.attributes.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public PoolFactory setLoadConditioningInterval(int connectionLifetime) {
        if (connectionLifetime < -1) {
            throw new IllegalArgumentException("connectionLifetime must be greater than or equal to -1");
        }
        this.attributes.connectionLifetime = connectionLifetime;
        return this;
    }

    @Override
    public PoolFactory setSocketBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("socketBufferSize must be greater than zero");
        }
        this.attributes.socketBufferSize = bufferSize;
        return this;
    }

    @Override
    public PoolFactory setThreadLocalConnections(boolean threadLocalConnections) {
        this.attributes.threadLocalConnections = threadLocalConnections;
        return this;
    }

    @Override
    public PoolFactory setIdleTimeout(long idleTimout) {
        if (idleTimout < -1L) {
            throw new IllegalArgumentException("idleTimeout must be greater than or equal to -1");
        }
        this.attributes.idleTimeout = idleTimout;
        return this;
    }

    @Override
    public PoolFactory setMaxConnections(int maxConnections) {
        if (maxConnections < this.attributes.minConnections && maxConnections != -1) {
            throw new IllegalArgumentException("maxConnections must be greater than or equal to minConnections (" + this.attributes.minConnections + ")");
        }
        if (maxConnections <= 0 && maxConnections != -1) {
            throw new IllegalArgumentException("maxConnections must be greater than 0, or set to -1 (no max)");
        }
        this.attributes.maxConnections = maxConnections;
        return this;
    }

    @Override
    public PoolFactory setMinConnections(int minConnections) {
        if (minConnections > this.attributes.maxConnections && this.attributes.maxConnections != -1) {
            throw new IllegalArgumentException("must be less than or equal to maxConnections (" + this.attributes.maxConnections + ")");
        }
        if (minConnections < 0) {
            throw new IllegalArgumentException("must be greater than or equal to 0");
        }
        this.attributes.minConnections = minConnections;
        return this;
    }

    @Override
    public PoolFactory setPingInterval(long pingInterval) {
        if (pingInterval <= 0L) {
            throw new IllegalArgumentException("pingInterval must be greater than zero");
        }
        this.attributes.pingInterval = pingInterval;
        return this;
    }

    @Override
    public PoolFactory setStatisticInterval(int statisticInterval) {
        if (statisticInterval < -1) {
            throw new IllegalArgumentException("statisticInterval must be greater than or equal to -1");
        }
        this.attributes.statisticInterval = statisticInterval;
        return this;
    }

    @Override
    public PoolFactory setRetryAttempts(int retryAttempts) {
        if (retryAttempts < -1) {
            throw new IllegalArgumentException("retryAttempts must be greater than or equal to -1");
        }
        this.attributes.retryAttempts = retryAttempts;
        return this;
    }

    @Override
    public PoolFactory setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("readTimeout must be greater than or equal to zero");
        }
        this.attributes.readTimeout = timeout;
        return this;
    }

    @Override
    public PoolFactory setServerGroup(String group) {
        if (group == null) {
            group = "";
        }
        this.attributes.serverGroup = group;
        return this;
    }

    @Override
    public PoolFactory setSubscriptionEnabled(boolean enabled) {
        this.attributes.queueEnabled = enabled;
        return this;
    }

    @Override
    public PoolFactory setPRSingleHopEnabled(boolean enabled) {
        this.attributes.prSingleHopEnabled = enabled;
        return this;
    }

    @Override
    public PoolFactory setMultiuserAuthentication(boolean enabled) {
        this.attributes.multiuserSecureModeEnabled = enabled;
        return this;
    }

    public PoolFactory setStartDisabled(boolean disable) {
        this.attributes.startDisabled = disable;
        return this;
    }

    public PoolFactory setLocatorDiscoveryCallback(LocatorDiscoveryCallback callback) {
        this.attributes.locatorCallback = callback;
        return this;
    }

    @Override
    public PoolFactory setSubscriptionRedundancy(int redundancyLevel) {
        if (redundancyLevel < -1) {
            throw new IllegalArgumentException("queueRedundancyLevel must be greater than or equal to -1");
        }
        this.attributes.queueRedundancyLevel = redundancyLevel;
        return this;
    }

    @Override
    public PoolFactory setSubscriptionMessageTrackingTimeout(int messageTrackingTimeout) {
        if (messageTrackingTimeout <= 0) {
            throw new IllegalArgumentException("queueMessageTrackingTimeout must be greater than zero");
        }
        this.attributes.queueMessageTrackingTimeout = messageTrackingTimeout;
        return this;
    }

    private PoolFactory add(String host, int port, List l) {
        if (port == 0) {
            throw new IllegalArgumentException("port must be greater than 0 but was " + port);
        }
        try {
            InetAddress hostAddr = InetAddress.getByName(host);
            InetSocketAddress sockAddr = new InetSocketAddress(hostAddr, port);
            l.add(sockAddr);
        }
        catch (UnknownHostException cause) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            logger.fatal(LocalizedMessage.create(LocalizedStrings.PoolFactoryImpl_HOSTNAME_UNKNOWN, host));
            InetSocketAddress sockAddr = new InetSocketAddress(host, port);
            l.add(sockAddr);
        }
        return this;
    }

    @Override
    public PoolFactory setSubscriptionAckInterval(int ackInterval) {
        if (ackInterval <= 0) {
            throw new IllegalArgumentException("ackInterval must be greater than 0");
        }
        this.attributes.queueAckInterval = ackInterval;
        return this;
    }

    @Override
    public PoolFactory addLocator(String host, int port) {
        if (this.attributes.servers.size() > 0) {
            throw new IllegalStateException("A server has already been added. You can only add locators or servers; not both.");
        }
        return this.add(host, port, this.attributes.locators);
    }

    @Override
    public PoolFactory addServer(String host, int port) {
        if (this.attributes.locators.size() > 0) {
            throw new IllegalStateException("A locator has already been added. You can only add locators or servers; not both.");
        }
        return this.add(host, port, this.attributes.servers);
    }

    @Override
    public PoolFactory reset() {
        boolean sd = this.attributes.startDisabled;
        this.attributes = new PoolAttributes();
        this.attributes.startDisabled = sd;
        return this;
    }

    public void init(Pool cp) {
        this.setFreeConnectionTimeout(cp.getFreeConnectionTimeout());
        this.setLoadConditioningInterval(cp.getLoadConditioningInterval());
        this.setSocketBufferSize(cp.getSocketBufferSize());
        this.setReadTimeout(cp.getReadTimeout());
        this.setMinConnections(cp.getMinConnections());
        this.setMaxConnections(cp.getMaxConnections());
        this.setRetryAttempts(cp.getRetryAttempts());
        this.setIdleTimeout(cp.getIdleTimeout());
        this.setPingInterval(cp.getPingInterval());
        this.setStatisticInterval(cp.getStatisticInterval());
        this.setThreadLocalConnections(cp.getThreadLocalConnections());
        this.setSubscriptionEnabled(cp.getSubscriptionEnabled());
        this.setPRSingleHopEnabled(cp.getPRSingleHopEnabled());
        this.setSubscriptionRedundancy(cp.getSubscriptionRedundancy());
        this.setSubscriptionMessageTrackingTimeout(cp.getSubscriptionMessageTrackingTimeout());
        this.setSubscriptionAckInterval(cp.getSubscriptionAckInterval());
        this.setServerGroup(cp.getServerGroup());
        this.setMultiuserAuthentication(cp.getMultiuserAuthentication());
        this.attributes.locators.addAll(cp.getLocators());
        this.attributes.servers.addAll(cp.getServers());
    }

    public void init(Properties properties, boolean usedByBridgeWriter, boolean usedByGateway, GatewaySender sender) {
        this.attributes.setGatewaySender(sender);
        this.init(properties, usedByBridgeWriter, usedByGateway);
    }

    public void init(Properties properties, boolean usedByBridgeWriter, boolean usedByGateway) {
        String str;
        String strRetryAttempts;
        String pv;
        String locatorObject;
        this.attributes.setBridge(usedByBridgeWriter || !usedByGateway);
        this.attributes.setBridgeWriter(usedByBridgeWriter);
        this.attributes.setGateway(usedByGateway);
        this.setIdleTimeout(-1L);
        this.setLoadConditioningInterval(-1);
        this.setMaxConnections(-1);
        int endpointCount = 0;
        boolean useLocators = false;
        boolean useEndPoints = false;
        Throwable exception = null;
        if (properties.containsKey("locators") && (locatorObject = properties.getProperty("locators")) != null && !locatorObject.equals("")) {
            StringTokenizer locatorsOnThisVM = new StringTokenizer(locatorObject, ",");
            while (locatorsOnThisVM.hasMoreTokens()) {
                String localLocator = locatorsOnThisVM.nextToken();
                DistributionLocatorId locatorId = new DistributionLocatorId(localLocator);
                this.addLocator(locatorId.getHost().getHostName(), locatorId.getPort());
            }
            useLocators = true;
        }
        if (!useLocators && properties.containsKey("endpoints")) {
            useEndPoints = true;
            pv = properties.getProperty("endpoints");
            StringTokenizer tokenizer = new StringTokenizer(pv, ",");
            while (tokenizer.hasMoreTokens()) {
                String port;
                String serverdetail = tokenizer.nextToken();
                int cIndex = serverdetail.indexOf("=");
                String remainder = serverdetail.substring(cIndex + 1);
                String host = remainder.substring(0, cIndex = remainder.lastIndexOf(":"));
                if (host != null) {
                    host = host.trim();
                }
                if ((port = remainder.substring(cIndex + 1)) != null) {
                    port = port.trim();
                }
                try {
                    this.addServer(host, Integer.parseInt(port));
                    ++endpointCount;
                }
                catch (IllegalArgumentException e) {
                    if (!(e.getCause() instanceof UnknownHostException)) {
                        throw e;
                    }
                    exception = e;
                }
            }
            if (endpointCount == 0 && exception != null) {
                IllegalArgumentException ex = new IllegalArgumentException("Couldn't find any Endpoint. " + exception.getMessage());
                ex.initCause(exception.getCause());
                throw ex;
            }
        }
        if (!useLocators && !useEndPoints) {
            throw new IllegalArgumentException("Property 'locators ' or 'endpoints' must be specified");
        }
        BridgePoolImpl.LBPolicy policy = new BridgePoolImpl.LBPolicy(properties.getProperty("LBPolicy", "Sticky"));
        this.setThreadLocalConnections(policy.isSticky());
        if (properties.containsKey("retryAttempts")) {
            strRetryAttempts = properties.getProperty("retryAttempts");
            this.setRetryAttempts(Integer.parseInt(strRetryAttempts));
        }
        if (properties.containsKey("retryInterval")) {
            strRetryAttempts = properties.getProperty("retryInterval");
            this.setPingInterval(Integer.parseInt(strRetryAttempts));
        }
        if (properties.containsKey("establishCallbackConnection")) {
            str = properties.getProperty("establishCallbackConnection");
            this.setSubscriptionEnabled(Boolean.valueOf(str));
        }
        if (properties.containsKey("enablePRSingleHop")) {
            str = properties.getProperty("enablePRSingleHop");
            this.setPRSingleHopEnabled(Boolean.valueOf(str));
        }
        if (properties.containsKey("connectionsPerServer")) {
            str = properties.getProperty("connectionsPerServer");
            this.setMinConnections(Integer.parseInt(str) * endpointCount);
        } else {
            this.setMinConnections(1 * endpointCount);
        }
        if (properties.containsKey("redundancyLevel")) {
            str = properties.getProperty("redundancyLevel");
            this.setSubscriptionRedundancy(Integer.parseInt(str));
        }
        if (properties.containsKey("readTimeout")) {
            String strReadTimeout = properties.getProperty("readTimeout");
            this.setReadTimeout(Integer.parseInt(strReadTimeout));
        }
        if (properties.containsKey("socketBufferSize")) {
            String strSocketBufferSize = properties.getProperty("socketBufferSize");
            this.setSocketBufferSize(Integer.parseInt(strSocketBufferSize));
        }
        if (properties.containsKey("messageTrackingTimeout")) {
            pv = properties.getProperty("messageTrackingTimeout");
            this.setSubscriptionMessageTrackingTimeout(Integer.parseInt(pv));
        }
        if (properties.containsKey("clientAckInterval")) {
            pv = properties.getProperty("clientAckInterval");
            this.setSubscriptionAckInterval(Integer.parseInt(pv));
        }
        if (usedByGateway && exception != null) {
            throw exception;
        }
    }

    @Override
    public Pool create(String name) throws CacheException {
        TypeRegistry registry;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && (registry = cache.getPdxRegistry()) != null && !this.attributes.isGateway()) {
            registry.creatingPool();
        }
        if (this.attributes.isBridge()) {
            return new BridgePoolImpl(this.pm, name, this.attributes);
        }
        return PoolImpl.create(this.pm, name, this.attributes);
    }

    public PoolAttributes getPoolAttributes() {
        return this.attributes;
    }

    public static class PoolAttributes
    implements Pool,
    DataSerializable {
        private static final long serialVersionUID = 1L;
        public int connectionTimeout = 10000;
        public int connectionLifetime = 300000;
        public int socketBufferSize = 32768;
        public boolean threadLocalConnections = false;
        public int readTimeout = 10000;
        public int minConnections = 1;
        public int maxConnections = -1;
        public long idleTimeout = 5000L;
        public int retryAttempts = -1;
        public long pingInterval = 10000L;
        public int statisticInterval = -1;
        public boolean queueEnabled = false;
        public boolean prSingleHopEnabled = true;
        public int queueRedundancyLevel = 0;
        public int queueMessageTrackingTimeout = 900000;
        public int queueAckInterval = 100;
        public String serverGroup = "";
        public boolean multiuserSecureModeEnabled = false;
        public ArrayList locators = new ArrayList();
        public ArrayList servers = new ArrayList();
        public transient boolean startDisabled = false;
        public transient LocatorDiscoveryCallback locatorCallback = null;
        public GatewaySender gatewaySender = null;
        public boolean bridge = false;
        public boolean bridgeWriter = false;
        public boolean gateway = false;

        @Override
        public int getFreeConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public int getLoadConditioningInterval() {
            return this.connectionLifetime;
        }

        @Override
        public int getSocketBufferSize() {
            return this.socketBufferSize;
        }

        @Override
        public int getMinConnections() {
            return this.minConnections;
        }

        @Override
        public int getMaxConnections() {
            return this.maxConnections;
        }

        @Override
        public long getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public int getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public long getPingInterval() {
            return this.pingInterval;
        }

        @Override
        public int getStatisticInterval() {
            return this.statisticInterval;
        }

        @Override
        public boolean getThreadLocalConnections() {
            return this.threadLocalConnections;
        }

        @Override
        public int getReadTimeout() {
            return this.readTimeout;
        }

        @Override
        public boolean getSubscriptionEnabled() {
            return this.queueEnabled;
        }

        @Override
        public boolean getPRSingleHopEnabled() {
            return this.prSingleHopEnabled;
        }

        @Override
        public int getSubscriptionRedundancy() {
            return this.queueRedundancyLevel;
        }

        @Override
        public int getSubscriptionMessageTrackingTimeout() {
            return this.queueMessageTrackingTimeout;
        }

        @Override
        public int getSubscriptionAckInterval() {
            return this.queueAckInterval;
        }

        @Override
        public String getServerGroup() {
            return this.serverGroup;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        public void setBridge(boolean v) {
            this.bridge = v;
        }

        public boolean isBridgeWriter() {
            return this.bridgeWriter;
        }

        public void setBridgeWriter(boolean v) {
            this.bridgeWriter = v;
        }

        public boolean isGateway() {
            return this.gateway;
        }

        public void setGateway(boolean v) {
            this.gateway = v;
        }

        public void setGatewaySender(GatewaySender sender) {
            this.gatewaySender = sender;
        }

        public GatewaySender getGatewaySender() {
            return this.gatewaySender;
        }

        @Override
        public boolean getMultiuserAuthentication() {
            return this.multiuserSecureModeEnabled;
        }

        public void setMultiuserSecureModeEnabled(boolean v) {
            this.multiuserSecureModeEnabled = v;
        }

        public List getLocators() {
            if (this.locators.size() == 0 && this.servers.size() == 0) {
                throw new IllegalStateException("At least one locator or server must be added before a connection pool can be created.");
            }
            return Collections.unmodifiableList(new ArrayList(this.locators));
        }

        public List getServers() {
            if (this.locators.size() == 0 && this.servers.size() == 0) {
                throw new IllegalStateException("At least one locator or server must be added before a connection pool can be created.");
            }
            return Collections.unmodifiableList(new ArrayList(this.servers));
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() throws CacheException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy(boolean keepAlive) throws CacheException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDestroyed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void releaseThreadLocalConnection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public QueryService getQueryService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPendingEventCount() {
            throw new UnsupportedOperationException();
        }

        public RegionService createAuthenticatedCacheView(Properties properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            DataSerializer.writePrimitiveInt(this.connectionTimeout, out);
            DataSerializer.writePrimitiveInt(this.connectionLifetime, out);
            DataSerializer.writePrimitiveInt(this.socketBufferSize, out);
            DataSerializer.writePrimitiveInt(this.readTimeout, out);
            DataSerializer.writePrimitiveInt(this.minConnections, out);
            DataSerializer.writePrimitiveInt(this.maxConnections, out);
            DataSerializer.writePrimitiveInt(this.retryAttempts, out);
            DataSerializer.writePrimitiveLong(this.idleTimeout, out);
            DataSerializer.writePrimitiveLong(this.pingInterval, out);
            DataSerializer.writePrimitiveInt(this.queueRedundancyLevel, out);
            DataSerializer.writePrimitiveInt(this.queueMessageTrackingTimeout, out);
            DataSerializer.writePrimitiveBoolean(this.threadLocalConnections, out);
            DataSerializer.writePrimitiveBoolean(this.queueEnabled, out);
            DataSerializer.writeString(this.serverGroup, out);
            DataSerializer.writeArrayList(this.locators, out);
            DataSerializer.writeArrayList(this.servers, out);
            DataSerializer.writePrimitiveBoolean(this.bridge, out);
            DataSerializer.writePrimitiveInt(this.statisticInterval, out);
            DataSerializer.writePrimitiveBoolean(this.multiuserSecureModeEnabled, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.connectionTimeout = DataSerializer.readPrimitiveInt(in);
            this.connectionLifetime = DataSerializer.readPrimitiveInt(in);
            this.socketBufferSize = DataSerializer.readPrimitiveInt(in);
            this.readTimeout = DataSerializer.readPrimitiveInt(in);
            this.minConnections = DataSerializer.readPrimitiveInt(in);
            this.maxConnections = DataSerializer.readPrimitiveInt(in);
            this.retryAttempts = DataSerializer.readPrimitiveInt(in);
            this.idleTimeout = DataSerializer.readPrimitiveLong(in);
            this.pingInterval = DataSerializer.readPrimitiveLong(in);
            this.queueRedundancyLevel = DataSerializer.readPrimitiveInt(in);
            this.queueMessageTrackingTimeout = DataSerializer.readPrimitiveInt(in);
            this.threadLocalConnections = DataSerializer.readPrimitiveBoolean(in);
            this.queueEnabled = DataSerializer.readPrimitiveBoolean(in);
            this.serverGroup = DataSerializer.readString(in);
            this.locators = DataSerializer.readArrayList(in);
            this.servers = DataSerializer.readArrayList(in);
            this.bridge = DataSerializer.readPrimitiveBoolean(in);
            this.statisticInterval = DataSerializer.readPrimitiveInt(in);
            this.multiuserSecureModeEnabled = DataSerializer.readPrimitiveBoolean(in);
        }
    }
}

