/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.internal.ServerRegionDataAccess;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReliableReplyException;
import com.gemstone.gemfire.distributed.internal.ReliableReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.JtaAfterCompletionMessage;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXRemoteCommitMessage;
import com.gemstone.gemfire.internal.cache.TXRemoteRollbackMessage;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TXStateStub;
import com.gemstone.gemfire.internal.cache.tx.AbstractPeerTXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.DistributedTXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.PartitionedTXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.TXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.TransactionalOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PeerTXStateStub
extends TXStateStub {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedMember originatingMember = null;
    private TXCommitMessage commitMessage = null;

    public PeerTXStateStub(TXStateProxy stateProxy, DistributedMember target, InternalDistributedMember onBehalfOfClient) {
        super(stateProxy, target);
        this.originatingMember = onBehalfOfClient;
    }

    @Override
    public void rollback() {
        block12: {
            ReliableReplyProcessor21 response = TXRemoteRollbackMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), this.target);
            if (this.internalAfterSendRollback != null) {
                this.internalAfterSendRollback.run();
            }
            try {
                response.waitForReplies();
            }
            catch (PrimaryBucketException pbe) {
            }
            catch (ReplyException e) {
                this.proxy.getCache().getCancelCriterion().checkCancelInProgress(e);
                if (e.getCause() != null && e.getCause() instanceof CancelException) {
                    if (this.internalAfterSendRollback != null) {
                        this.internalAfterSendRollback.run();
                    }
                    break block12;
                }
                throw new TransactionException(LocalizedStrings.TXStateStub_ROLLBACK_ON_NODE_0_FAILED.toLocalizedString(this.target), e);
            }
            catch (Exception e) {
                this.getCache().getCancelCriterion().checkCancelInProgress(e);
                throw new TransactionException(LocalizedStrings.TXStateStub_ROLLBACK_ON_NODE_0_FAILED.toLocalizedString(this.target), e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    @Override
    public void commit() throws CommitConflictException {
        assert (this.target != null);
        TXRemoteCommitMessage.RemoteCommitResponse message = TXRemoteCommitMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), this.target);
        if (this.internalAfterSendCommit != null) {
            this.internalAfterSendCommit.run();
        }
        try {
            this.commitMessage = message.waitForResponse();
        }
        catch (CommitConflictException e) {
            throw e;
        }
        catch (TransactionException te) {
            throw te;
        }
        catch (ReliableReplyException e) {
            if (e.getCause() != null) {
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CommitConflictException) {
                throw (CommitConflictException)e.getCause();
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        catch (Exception e) {
            this.getCache().getCancelCriterion().checkCancelInProgress(e);
            if (e.getCause() != null) {
                if (e.getCause() instanceof ForceReattemptException) {
                    Throwable e2 = e.getCause();
                    if (e2.getCause() != null && e2.getCause() instanceof PrimaryBucketException) {
                        TransactionDataRebalancedException tdnce = new TransactionDataRebalancedException(e2.getCause().getMessage());
                        tdnce.initCause(e2.getCause());
                        throw tdnce;
                    }
                    TransactionInDoubtException tdnce = new TransactionInDoubtException(e.getCause().getMessage());
                    tdnce.initCause(e.getCause());
                    throw tdnce;
                }
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        for (TXRegionStub regionStub : this.regionStubs.values()) {
            regionStub.cleanup();
        }
    }

    @Override
    protected TXRegionStub generateRegionStub(LocalRegion region) {
        AbstractPeerTXRegionStub stub = null;
        stub = region.getPartitionAttributes() == null ? new DistributedTXRegionStub(this, region) : new PartitionedTXRegionStub(this, region);
        return stub;
    }

    @Override
    protected void validateRegionCanJoinTransaction(LocalRegion region) throws TransactionException {
        if (region.hasServerProxy()) {
            throw new TransactionException("Can't involve c/s region in peer tx");
        }
    }

    @Override
    public void afterCompletion(int status) {
        TXRemoteCommitMessage.RemoteCommitResponse response = JtaAfterCompletionMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), status, this.target);
        try {
            this.proxy.getTxMgr().setTXState(null);
            this.commitMessage = response.waitForResponse();
            if (logger.isDebugEnabled()) {
                logger.debug("afterCompletion received commit response of {}", this.commitMessage);
            }
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return this.originatingMember;
    }

    public void setOriginatingMember(InternalDistributedMember clientMemberId) {
        this.originatingMember = clientMemberId;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return this.getOriginatingMember() != null;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key2, Object[] arguments) {
    }
}

