/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledIndexOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledLiteral;
import com.gemstone.gemfire.cache.query.internal.CompiledOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CompiledSortCriterion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.PRQueryTraceInfo;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.streaming.StreamingOperation;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PRQueryProcessor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.VMCachedDeserializable;
import com.gemstone.gemfire.internal.cache.partitioned.QueryMessage;
import com.gemstone.gemfire.internal.cache.partitioned.StreamingPartitionOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.PdxString;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionQueryEvaluator
extends StreamingPartitionOperation {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_PR_QUERY_RETRIES = Integer.getInteger("gemfire.MAX_PR_QUERY_RETRIES", 10);
    private final PartitionedRegion pr;
    private volatile Map node2bucketIds;
    private final DefaultQuery query;
    private final Object[] parameters;
    private SelectResults cumulativeResults;
    private final ConcurrentMap<InternalDistributedMember, Collection<Collection>> resultsPerMember;
    private ConcurrentLinkedQueue<PRQueryTraceInfo> prQueryTraceInfoList = null;
    private final Set<Integer> bucketsToQuery;
    private final TIntHashSet successfulBuckets;
    private Set<InternalDistributedMember> failedMembers;

    public PartitionedRegionQueryEvaluator(InternalDistributedSystem sys, PartitionedRegion pr2, DefaultQuery query, Object[] parameters, SelectResults cumulativeResults, Set<Integer> bucketsToQuery) {
        super(sys, pr2.getPRId());
        this.pr = pr2;
        this.query = query;
        this.parameters = parameters;
        this.cumulativeResults = cumulativeResults;
        this.bucketsToQuery = bucketsToQuery;
        this.successfulBuckets = new TIntHashSet(this.bucketsToQuery.size());
        this.resultsPerMember = new ConcurrentHashMap<InternalDistributedMember, Collection<Collection>>();
        this.node2bucketIds = Collections.EMPTY_MAP;
        if (query != null && query.isTraced()) {
            this.prQueryTraceInfoList = new ConcurrentLinkedQueue();
        }
    }

    @Override
    protected DistributionMessage createRequestMessage(Set recipients, ReplyProcessor21 processor) {
        throw new UnsupportedOperationException();
    }

    protected DistributionMessage createRequestMessage(InternalDistributedMember recipient, ReplyProcessor21 processor, List bucketIds) {
        return new QueryMessage(recipient, this.pr.getPRId(), processor, this.query, this.parameters, bucketIds);
    }

    @Override
    public Set<InternalDistributedMember> getPartitionedDataFrom(Set recipients) throws TimeoutException, InterruptedException, QueryException, ForceReattemptException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (recipients.isEmpty()) {
            return Collections.emptySet();
        }
        StreamingQueryPartitionResponse processor = new StreamingQueryPartitionResponse(this.sys, recipients);
        DistributionMessage m = this.createRequestMessage(recipients, processor);
        this.sys.getDistributionManager().putOutgoing(m);
        Set failedMembers = processor.waitForCacheOrQueryException();
        return failedMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processData(List objects, InternalDistributedMember sender, int sequenceNum, boolean lastInSequence) {
        Object traceObject;
        Object object;
        Collection results = (Collection)this.resultsPerMember.get(sender);
        if (results == null) {
            object = this.resultsPerMember;
            synchronized (object) {
                results = (Collection)this.resultsPerMember.get(sender);
                if (results == null) {
                    results = new MemberResultsList();
                    this.resultsPerMember.put(sender, results);
                }
            }
        }
        if (objects.size() > 0 && (traceObject = objects.get(0)) instanceof PRQueryTraceInfo) {
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook("Pull off PR Query Trace Info");
            }
            PRQueryTraceInfo queryTrace = (PRQueryTraceInfo)objects.remove(0);
            queryTrace.setSender(sender);
            if (this.prQueryTraceInfoList != null) {
                this.prQueryTraceInfoList.add(queryTrace);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Results per member, for {} size: {}", sender, objects.size());
        }
        object = results;
        synchronized (object) {
            if (QueryMonitor.isLowMemory()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("query canceled while gathering results, aborting");
                }
                String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
                this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
                return false;
            }
            results.add(objects);
            if (lastInSequence) {
                ((MemberResultsList)results).setLastChunkReceived(true);
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean executeQueryOnRemoteAndLocalNodes(TestHook th) throws InterruptedException, QueryException {
        block34: {
            isDebugEnabled = PartitionedRegionQueryEvaluator.logger.isDebugEnabled();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            n2b = new HashMap<K, V>(this.node2bucketIds);
            n2b.remove(this.pr.getMyId());
            if (this.query.isQueryWithFunctionContext() && !n2b.isEmpty()) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("Remote buckets found for query executed in a Function.");
                }
                throw new QueryInvocationTargetException("Data movement detected accross PartitionRegion nodes while executing the Query with function filter.");
            }
            if (isDebugEnabled) {
                PartitionedRegionQueryEvaluator.logger.debug("Sending query execution request to {} remote members for the query:{}", new Object[]{n2b.size(), this.query.getQueryString()});
            }
            processor = null;
            requiresRetry = false;
            if (n2b.isEmpty()) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("No remote members with buckets to query.");
                }
            } else {
                processor = new StreamingQueryPartitionResponse(this.sys, n2b.keySet());
                for (Map.Entry<K, V> me : n2b.entrySet()) {
                    rcp = (InternalDistributedMember)me.getKey();
                    bucketIds = (List)me.getValue();
                    m = this.createRequestMessage(rcp, processor, bucketIds);
                    notReceivedMembers = this.sys.getDistributionManager().putOutgoing(m);
                    if (th != null) {
                        th.hook(4);
                    }
                    if (notReceivedMembers == null || notReceivedMembers.isEmpty()) continue;
                    requiresRetry = true;
                    processor.removeFailedSenders(notReceivedMembers);
                    if (!isDebugEnabled) continue;
                    PartitionedRegionQueryEvaluator.logger.debug("Failed sending to members {} retry required", new Object[]{notReceivedMembers});
                }
                if (th != null) {
                    th.hook(5);
                }
            }
            localFault = null;
            localNeedsRetry = false;
            if (this.node2bucketIds.containsKey(this.pr.getMyId())) {
                if (isDebugEnabled) {
                    PartitionedRegionQueryEvaluator.logger.debug("Started query execution on local data for query:{}", new Object[]{this.query.getQueryString()});
                }
                try {
                    localNeedsRetry = this.executeQueryOnLocalNode();
                    if (th == null) ** GOTO lbl54
                    th.hook(0);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    localFault = t;
                }
            } else if (isDebugEnabled) {
                PartitionedRegionQueryEvaluator.logger.debug("No local buckets to query.");
            }
lbl54:
            // 6 sources

            if (processor != null) {
                try {
                    this.failedMembers = processor.waitForCacheOrQueryException();
                    for (InternalDistributedMember member : this.failedMembers) {
                        this.memberStreamCorrupted(member);
                    }
                    requiresRetry |= this.failedMembers.isEmpty() == false;
                    if (isDebugEnabled) {
                        PartitionedRegionQueryEvaluator.logger.debug("Following remote members failed {} and retry flag is set to: {}", new Object[]{this.failedMembers, requiresRetry});
                    }
                }
                catch (TimeoutException e) {
                    if (localFault == null) {
                        throw new QueryException(e);
                    }
                }
                catch (ReplyException e) {
                    if (localFault == null) {
                        throw e;
                    }
                }
                catch (Error e) {
                    if (localFault == null) {
                        throw e;
                    }
                }
                catch (RuntimeException e) {
                    if (localFault != null) break block34;
                    throw e;
                }
            }
        }
        if (this.query.isCanceled()) {
            throw this.query.getQueryCanceledException();
        }
        if (localFault != null) {
            if (localFault instanceof QueryException) {
                throw (QueryException)localFault;
            }
            if (localFault instanceof InterruptedException) {
                throw (InterruptedException)localFault;
            }
            if (localFault instanceof Error) {
                throw (Error)localFault;
            }
            if (localFault instanceof RuntimeException) {
                throw (RuntimeException)localFault;
            }
        }
        return requiresRetry | localNeedsRetry;
    }

    public void queryBuckets(TestHook th) throws QueryException, InterruptedException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (isDebugEnabled) {
            logger.debug("PRQE query :{}", this.query.getQueryString());
        }
        Assert.assertTrue(this.bucketsToQuery != null && !this.bucketsToQuery.isEmpty(), "bucket set is empty.");
        this.node2bucketIds = this.buildNodeToBucketMap();
        Assert.assertTrue(!this.node2bucketIds.isEmpty(), " There are no data stores hosting any of the buckets.");
        boolean needsRetry = true;
        int retry = 0;
        while (needsRetry && retry < MAX_PR_QUERY_RETRIES) {
            needsRetry = this.executeQueryOnRemoteAndLocalNodes(th);
            if (th != null) {
                th.hook(1);
            }
            if (needsRetry) {
                if (this.query.isQueryWithFunctionContext()) {
                    if (!isDebugEnabled) break;
                    logger.debug("No of retry attempts are: {}", retry);
                    break;
                }
                Map b2n = this.buildNodeToBucketMapForBuckets(this.caclulateRetryBuckets());
                if (th != null) {
                    th.hook(2);
                }
                this.node2bucketIds = b2n;
                if (isDebugEnabled) {
                    logger.debug("PR Query retry: {} total: {}", retry, this.pr.getCachePerfStats().getPRQueryRetries());
                }
                this.pr.getCachePerfStats().incPRQueryRetries();
                ++retry;
                this.waitBeforeRetry();
            }
            if (th == null) continue;
            th.hook(3);
        }
        if (needsRetry) {
            String msg = "Failed to query all the partitioned region dataset (buckets) after " + retry + " attempts.";
            if (isDebugEnabled) {
                logger.debug("{} Unable to query some of the buckets from the set :{}", msg, this.caclulateRetryBuckets());
            }
            throw new QueryException(msg);
        }
        this.addResultsToResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitBeforeRetry() {
        boolean interrupted = Thread.interrupted();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException intEx) {
            interrupted = true;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean anyOfTheseBucketsHasStorage(Set<Integer> failedBuckets) {
        boolean haveStorage = false;
        for (Integer bid : failedBuckets) {
            if (!this.pr.getRegionAdvisor().isStorageAssignedForBucket(bid)) continue;
            Set<InternalDistributedMember> ownrs = this.pr.getRegionAdvisor().getBucketOwners(bid);
            for (InternalDistributedMember mem : ownrs) {
                TaintableArrayList tal = (TaintableArrayList)this.resultsPerMember.get(mem);
                if (tal != null && tal.isTainted()) continue;
                haveStorage = true;
            }
        }
        return haveStorage;
    }

    private Set<Integer> caclulateRetryBuckets() {
        Iterator memberToBucketList = this.node2bucketIds.entrySet().iterator();
        HashSet<Integer> retryBuckets = new HashSet<Integer>();
        while (memberToBucketList.hasNext()) {
            Map.Entry e = memberToBucketList.next();
            InternalDistributedMember m = (InternalDistributedMember)e.getKey();
            if (this.resultsPerMember.containsKey(m) && ((MemberResultsList)this.resultsPerMember.get(m)).isLastChunkReceived()) continue;
            retryBuckets.addAll((Collection)e.getValue());
            this.resultsPerMember.remove(m);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer logStr = new StringBuffer();
            logStr.append("Query ").append(this.query.getQueryString()).append(" needs to retry bucketsIds: [");
            for (Integer i : retryBuckets) {
                logStr.append("," + i);
            }
            logStr.append("]");
            logger.debug(logStr);
        }
        return retryBuckets;
    }

    private void addResultsToResultSet() throws QueryException {
        int numElementsInResult = 0;
        boolean isStructBag = false;
        boolean isResultBag = false;
        boolean isDistinct = false;
        boolean isCount = false;
        int limit = -1;
        CompiledSelect cs = null;
        boolean getDeserializedObject = false;
        if (this.query != null) {
            cs = this.query.getSimpleSelect();
            limit = this.query.getLimit(this.parameters);
            isDistinct = cs != null ? cs.isDistinct() : true;
            boolean bl = isCount = cs != null ? cs.isCount() : false;
        }
        if (isCount && !isDistinct) {
            this.addTotalCountForMemberToResults(limit);
            return;
        }
        if (this.cumulativeResults instanceof StructBag) {
            isStructBag = true;
        } else if (this.cumulativeResults instanceof ResultsBag) {
            isResultBag = true;
        } else if (this.cumulativeResults.getCollectionType().isOrdered() && cs.getOrderByAttrs() != null) {
            this.buildSortedResult(cs, limit);
            return;
        }
        InternalDistributedMember me = this.pr.getMyId();
        if (DefaultQuery.testHook != null) {
            DefaultQuery.testHook.doTestHook(4);
        }
        boolean localResults = false;
        block4: for (Map.Entry e : this.resultsPerMember.entrySet()) {
            boolean getDomainObjectForPdx;
            this.checkLowMemory();
            if (((InternalDistributedMember)e.getKey()).equals(me)) {
                getDomainObjectForPdx = false;
                localResults = true;
            } else {
                boolean bl = getDomainObjectForPdx = !this.pr.getCache().getPdxReadSerializedByAnyGemFireServices();
                if (!getDeserializedObject && !this.query.isKeepSerialized()) {
                    getDeserializedObject = true;
                }
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            block5: for (Collection res : (Collection)e.getValue()) {
                this.checkLowMemory();
                if (res == null) continue;
                if (isDebugEnabled) {
                    logger.debug("Query Result from member :{}: {}", e.getKey(), res.size());
                }
                if (limit == -1 && !getDomainObjectForPdx && !getDeserializedObject && !isDistinct && localResults) {
                    this.cumulativeResults.addAll(res);
                    continue;
                }
                if (numElementsInResult == limit) continue block4;
                for (Object obj : res) {
                    this.checkLowMemory();
                    int occurence = 0;
                    if (isStructBag) {
                        StructImpl simpl = (StructImpl)obj;
                        if (getDomainObjectForPdx) {
                            try {
                                if (simpl.isHasPdx()) {
                                    occurence = ((ResultsBag)this.cumulativeResults).addAndGetOccurence(simpl.getPdxFieldValues());
                                }
                                occurence = ((ResultsBag)this.cumulativeResults).addAndGetOccurence(simpl.getFieldValues());
                            }
                            catch (Exception ex) {
                                throw new QueryException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage());
                            }
                        } else {
                            int i;
                            Object[] values = simpl.getFieldValues();
                            if (getDeserializedObject) {
                                for (i = 0; i < values.length; ++i) {
                                    if (!(values[i] instanceof VMCachedDeserializable)) continue;
                                    values[i] = ((VMCachedDeserializable)values[i]).getDeserializedForReading();
                                }
                            }
                            if (simpl.isHasPdx() && isDistinct && localResults) {
                                for (i = 0; i < values.length; ++i) {
                                    if (!(values[i] instanceof PdxString)) continue;
                                    values[i] = ((PdxString)values[i]).toString();
                                }
                            }
                            occurence = ((ResultsBag)this.cumulativeResults).addAndGetOccurence(values);
                        }
                    } else {
                        if (getDomainObjectForPdx) {
                            if (obj instanceof PdxInstance) {
                                try {
                                    obj = ((PdxInstance)obj).getObject();
                                }
                                catch (Exception ex) {
                                    throw new QueryException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage());
                                }
                            } else if (obj instanceof PdxString) {
                                obj = ((PdxString)obj).toString();
                            }
                        } else if (isDistinct && localResults && obj instanceof PdxString) {
                            obj = ((PdxString)obj).toString();
                        }
                        if (isResultBag) {
                            if (getDeserializedObject && obj instanceof VMCachedDeserializable) {
                                obj = ((VMCachedDeserializable)obj).getDeserializedForReading();
                            }
                            occurence = ((ResultsBag)this.cumulativeResults).addAndGetOccurence(obj);
                        } else {
                            if (getDeserializedObject && obj instanceof VMCachedDeserializable) {
                                obj = ((VMCachedDeserializable)obj).getDeserializedForReading();
                            }
                            int n = occurence = this.cumulativeResults.add(obj) ? 1 : 0;
                        }
                    }
                    if (occurence != 1 && (occurence <= 1 || isDistinct) || ++numElementsInResult != limit) continue;
                    continue block5;
                }
            }
        }
        if (this.prQueryTraceInfoList != null && this.query.isTraced() && logger.isInfoEnabled()) {
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook("Create PR Query Trace String");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(LocalizedStrings.PartitionedRegion_QUERY_TRACE_LOG.toLocalizedString(this.query.getQueryString())).append("\n");
            for (PRQueryTraceInfo queryTraceInfo : this.prQueryTraceInfoList) {
                sb.append(queryTraceInfo.createLogLine(me)).append("\n");
            }
            logger.info(sb.toString());
        }
    }

    private void checkLowMemory() {
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
            this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook(5);
            }
            throw this.query.getQueryCanceledException();
        }
    }

    private void addTotalCountForMemberToResults(int limit) {
        int count = 0;
        for (Collection results : this.resultsPerMember.values()) {
            for (Collection res : results) {
                if (res == null) continue;
                for (Object obj : res) {
                    if (limit > -1 && count >= limit) {
                        count = limit;
                        break;
                    }
                    count += ((Integer)obj).intValue();
                }
                res.clear();
            }
        }
        this.cumulativeResults.clear();
        this.cumulativeResults.add(count);
    }

    private void buildSortedResult(CompiledSelect cs, int limit) throws QueryException {
        List projAttrs = cs.getProjectionAttributes();
        List orderByAttrs = cs.getOrderByAttrs();
        String eMsg = "Unable to apply order-by on the partition region cumulative results.";
        Assert.assertTrue(orderByAttrs != null, eMsg + " Null order-by attributes.");
        List iterators = cs.getIterators();
        Object projFields = null;
        LinkedList<String> projectionFields = new LinkedList<String>();
        try {
            StringBuffer temp;
            QueryExecutionContext localContext = new QueryExecutionContext(this.parameters, this.pr.cache);
            localContext.newScope(0);
            for (CompiledIteratorDef iterDef : iterators) {
                localContext.addDependencies(cs, iterDef.computeDependencies(localContext));
                RuntimeIterator rIter = iterDef.getRuntimeIterator(localContext);
                localContext.addToIndependentRuntimeItrMap(iterDef);
                localContext.bindIterator(rIter);
            }
            ObjectType type = cs.prepareResultType(localContext);
            StringBuffer tempQueryBuffer = new StringBuffer(" order by ");
            if (type.isStructType()) {
                StructType structType = (StructType)type;
                String[] fieldNames = structType.getFieldNames();
                if (projAttrs == null) {
                    List runTimeItrs = localContext.getCurrentIterators();
                    Iterator itr = runTimeItrs.iterator();
                    while (itr.hasNext()) {
                        StringBuffer temp2 = new StringBuffer();
                        RuntimeIterator rIter = (RuntimeIterator)itr.next();
                        rIter.setIndexInternalID(null);
                        rIter.generateCanonicalizedExpression(temp2, localContext);
                        projectionFields.add(temp2.toString());
                    }
                } else {
                    Iterator itr = projAttrs.iterator();
                    while (itr.hasNext()) {
                        temp = new StringBuffer();
                        Object[] values = (Object[])itr.next();
                        ((CompiledValue)values[1]).generateCanonicalizedExpression(temp, localContext);
                        projectionFields.add(temp.toString());
                    }
                }
                for (int i = 0; i < orderByAttrs.size(); ++i) {
                    Object o = orderByAttrs.get(i);
                    if (!(o instanceof CompiledSortCriterion)) continue;
                    CompiledSortCriterion csc = (CompiledSortCriterion)o;
                    CompiledValue cv = csc.getExpr();
                    StringBuffer temp3 = new StringBuffer();
                    cv.generateCanonicalizedExpression(temp3, localContext);
                    Iterator projFieldItr = projectionFields.iterator();
                    int index2 = 0;
                    boolean foundMatch = false;
                    String orderBy = temp3.toString();
                    while (projFieldItr.hasNext() && !foundMatch) {
                        String projStr = (String)projFieldItr.next();
                        if (orderBy.equals(projStr)) {
                            tempQueryBuffer.append(' ');
                            tempQueryBuffer.append(fieldNames[index2]);
                            tempQueryBuffer.append(' ');
                            tempQueryBuffer.append(csc.getCriterion() ? " desc " : " asc ");
                            tempQueryBuffer.append(',');
                            foundMatch = true;
                        } else if (orderBy.startsWith(projStr)) {
                            tempQueryBuffer.append(fieldNames[index2]);
                            tempQueryBuffer.append(temp3.substring(projStr.length()));
                            tempQueryBuffer.append(' ');
                            tempQueryBuffer.append(csc.getCriterion() ? " desc " : " asc ");
                            tempQueryBuffer.append(',');
                            foundMatch = true;
                        }
                        ++index2;
                    }
                    if (foundMatch) continue;
                    throw new QueryException("Order by clause " + orderBy + " not derivable from any projection attribute");
                }
                tempQueryBuffer.deleteCharAt(tempQueryBuffer.length() - 1);
            } else {
                String projStr = null;
                if (projAttrs == null) {
                    List runTimeItrs = localContext.getCurrentIterators();
                    Iterator itr = runTimeItrs.iterator();
                    temp = new StringBuffer();
                    RuntimeIterator rIter = (RuntimeIterator)itr.next();
                    rIter.setIndexInternalID(null);
                    rIter.generateCanonicalizedExpression(temp, localContext);
                    projStr = temp.toString();
                } else {
                    Iterator itr = projAttrs.iterator();
                    StringBuffer temp4 = new StringBuffer();
                    Object[] values = (Object[])itr.next();
                    ((CompiledValue)values[1]).generateCanonicalizedExpression(temp4, localContext);
                    projStr = temp4.toString();
                }
                for (int i = 0; i < orderByAttrs.size(); ++i) {
                    Object o = orderByAttrs.get(i);
                    if (!(o instanceof CompiledSortCriterion)) continue;
                    CompiledSortCriterion csc = (CompiledSortCriterion)o;
                    CompiledValue cv = csc.getExpr();
                    StringBuffer temp5 = new StringBuffer();
                    cv.generateCanonicalizedExpression(temp5, localContext);
                    String orderBy = temp5.toString();
                    if (orderBy.equals(projStr)) {
                        tempQueryBuffer.append(' ');
                        tempQueryBuffer.append("iter");
                        tempQueryBuffer.append(' ');
                    } else if (orderBy.startsWith(projStr)) {
                        tempQueryBuffer.append(' ');
                        tempQueryBuffer.append(temp5.substring(projStr.length() + 1));
                    } else {
                        throw new QueryException("Order by clause " + orderBy + " not derivable from projection attribute " + projStr);
                    }
                    tempQueryBuffer.append(' ');
                    tempQueryBuffer.append(csc.getCriterion() ? " desc " : " asc ");
                    tempQueryBuffer.append(',');
                }
                tempQueryBuffer.deleteCharAt(tempQueryBuffer.length() - 1);
            }
            tempQueryBuffer.insert(0, " SELECT DISTINCT * FROM $1 iter ");
            if (logger.isDebugEnabled()) {
                logger.debug("The temp query generated to evaluate order-by on PR commulative results: {}", tempQueryBuffer.toString());
            }
            DefaultQuery q = (DefaultQuery)this.pr.getCache().getQueryService().newQuery(tempQueryBuffer.toString());
            InternalDistributedMember me = this.pr.getMyId();
            for (Collection memberResults : this.resultsPerMember.values()) {
                for (Collection res : memberResults) {
                    if (res == null) continue;
                    QueryExecutionContext context = new QueryExecutionContext(new Object[]{res}, this.pr.getCache(), this.cumulativeResults, q);
                    q.executeUsingContext(context);
                }
            }
        }
        catch (Exception ex) {
            throw new QueryException("Unable to apply order-by on the partition region cumulative results.", ex);
        }
    }

    private String getQueryAttributes(CompiledValue cv, StringBuffer fromPath) throws QueryException {
        String clause = "";
        if (cv instanceof CompiledID) {
            clause = ((CompiledID)cv).getId() + clause;
        } else {
            do {
                if (cv instanceof CompiledPath || cv instanceof CompiledIndexOperation) {
                    if (cv instanceof CompiledIndexOperation) {
                        CompiledIndexOperation cio = (CompiledIndexOperation)cv;
                        CompiledLiteral cl = (CompiledLiteral)cio.getExpression();
                        StringBuffer sb = new StringBuffer();
                        cl.generateCanonicalizedExpression(sb, null);
                        cv = ((CompiledIndexOperation)cv).getReceiver();
                        if (sb.length() > 0) {
                            clause = "[" + sb.toString() + "]" + clause;
                        }
                    }
                    clause = "." + ((CompiledPath)cv).getTailID() + clause;
                    continue;
                }
                if (cv instanceof CompiledOperation) {
                    clause = "." + ((CompiledOperation)cv).getMethodName() + "()" + clause;
                    continue;
                }
                throw new QueryException("Failed to evaluate order by attributes, found unsupported type  " + cv.getType() + " Unable to apply order-by on the partition region cumulative results.");
            } while (!((cv = cv.getReceiver()) instanceof CompiledID));
            if (cv instanceof CompiledID) {
                clause = ((CompiledID)cv).getId() + clause;
                if (fromPath != null) {
                    fromPath.append(((CompiledID)cv).getId());
                }
            }
        }
        return clause;
    }

    private void buildSortedResultBackup(CompiledSelect cs, int limit) throws QueryException {
        List projAttrs = cs.getProjectionAttributes();
        List orderByAttrs = cs.getOrderByAttrs();
        List pIterators = cs.getIterators();
        String eMsg = "Unable to apply order-by on the partition region cumulative results.";
        Assert.assertTrue(orderByAttrs != null, eMsg + " Null order-by attributes.");
        StringBuffer fromPath = new StringBuffer();
        String projFields = null;
        HashMap<String, String> orderByFields = new HashMap<String, String>();
        try {
            int i;
            String fromIter = "";
            if (projAttrs == null) {
                for (i = 1; i < pIterators.size(); ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)pIterators.get(i - 1);
                    fromIter = fromIter + iterDef.getName() + ".";
                }
            } else if (projAttrs.size() == 1) {
                AbstractCompiledValue cp;
                Object[] projDef = (Object[])projAttrs.get(0);
                if (projDef[1] instanceof CompiledID) {
                    projFields = ((CompiledID)projDef[1]).getId();
                } else if (projDef[1] instanceof CompiledPath) {
                    cp = (CompiledPath)projDef[1];
                    projFields = ((CompiledID)((CompiledPath)cp).getReceiver()).getId() + "." + ((CompiledPath)cp).getTailID();
                } else if (projDef[1] instanceof CompiledOperation) {
                    cp = (CompiledOperation)projDef[1];
                    projFields = ((CompiledID)((CompiledOperation)cp).getReceiver(null)).getId() + "." + ((CompiledOperation)cp).getMethodName() + "()";
                } else {
                    throw new QueryException("Failed to evaluate projection attributes. " + eMsg);
                }
            }
            for (i = 0; i < orderByAttrs.size(); ++i) {
                Object o = orderByAttrs.get(i);
                String orderByClause = "";
                if (!(o instanceof CompiledSortCriterion)) continue;
                CompiledSortCriterion csc = (CompiledSortCriterion)o;
                CompiledValue cv = csc.getExpr();
                if (cv instanceof CompiledID) {
                    orderByClause = ((CompiledID)cv).getId() + orderByClause;
                } else {
                    do {
                        if (cv instanceof CompiledPath || cv instanceof CompiledIndexOperation) {
                            if (cv instanceof CompiledIndexOperation) {
                                CompiledIndexOperation cio = (CompiledIndexOperation)cv;
                                CompiledLiteral cl = (CompiledLiteral)cio.getExpression();
                                StringBuffer sb = new StringBuffer();
                                cl.generateCanonicalizedExpression(sb, null);
                                cv = ((CompiledIndexOperation)cv).getReceiver();
                                if (sb.length() > 0) {
                                    orderByClause = "[" + sb.toString() + "]" + orderByClause;
                                }
                            }
                            orderByClause = "." + ((CompiledPath)cv).getTailID() + orderByClause;
                            continue;
                        }
                        if (cv instanceof CompiledOperation) {
                            orderByClause = "." + ((CompiledOperation)cv).getMethodName() + "()" + orderByClause;
                            continue;
                        }
                        if (cv instanceof CompiledIndexOperation) {
                            StringBuffer sb = new StringBuffer();
                            continue;
                        }
                        throw new QueryException("Failed to evaluate order by attributes, found unsupported type  " + cv.getType() + " " + eMsg);
                    } while (!((cv = cv.getReceiver()) instanceof CompiledID));
                    if (cv instanceof CompiledID) {
                        orderByClause = ((CompiledID)cv).getId() + orderByClause;
                        if (i == 0) {
                            fromPath.append(((CompiledID)cv).getId());
                        }
                    }
                }
                orderByFields.put(fromIter + orderByClause, csc.getCriterion() ? " desc " : " asc ");
            }
            StringBuffer tmpSortQuery = new StringBuffer("SELECT DISTINCT * FROM $1 ");
            if (projFields != null && orderByFields.containsKey(projFields)) {
                if (fromPath.length() > 0) {
                    tmpSortQuery.append(fromPath).append(" ORDER BY ").append(fromPath).append(" ").append((String)orderByFields.get(projFields));
                } else {
                    tmpSortQuery.append(fromPath).append("p ORDER BY p").append((String)orderByFields.get(projFields));
                }
            } else {
                tmpSortQuery.append(fromPath).append(" ORDER BY ");
                Iterator iter = orderByFields.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    tmpSortQuery.append((String)e.getKey()).append(" ").append((String)e.getValue());
                    if (!iter.hasNext()) continue;
                    tmpSortQuery.append(", ");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The temp query generated to evaluate order-by on PR commulative results: {}", tmpSortQuery);
            }
            DefaultQuery q = (DefaultQuery)this.pr.getCache().getQueryService().newQuery(tmpSortQuery.toString());
            for (TaintableArrayList res : this.resultsPerMember.values()) {
                if (res == null || !res.isConsumable()) continue;
                QueryExecutionContext context = new QueryExecutionContext(new Object[]{res}, this.pr.getCache(), this.cumulativeResults, q);
                q.executeUsingContext(context);
                res.clear();
            }
        }
        catch (Exception ex) {
            throw new QueryException("Unable to apply order-by on the partition region cumulative results.", ex);
        }
    }

    Map buildNodeToBucketMap() throws QueryException {
        return this.buildNodeToBucketMapForBuckets(this.bucketsToQuery);
    }

    private Map buildNodeToBucketMapForBuckets(Set<Integer> bucketIdsToConsider) throws QueryException {
        HashMap ret = new HashMap();
        if (bucketIdsToConsider.isEmpty()) {
            return ret;
        }
        ArrayList<Integer> bucketIds = new ArrayList<Integer>();
        PartitionedRegionDataStore dataStore = this.pr.getDataStore();
        int totalBucketsToQuery = bucketIdsToConsider.size();
        if (dataStore != null) {
            for (Integer bid : bucketIdsToConsider) {
                if (!dataStore.isManagingBucket(bid)) continue;
                bucketIds.add(bid);
            }
            if (bucketIds.size() > 0) {
                ret.put(this.pr.getMyId(), new ArrayList(bucketIds));
                if (bucketIds.size() == totalBucketsToQuery) {
                    return ret;
                }
            }
        }
        ArrayList<InternalDistributedMember> allNodes = new ArrayList<InternalDistributedMember>(this.pr.getRegionAdvisor().adviseDataStore());
        if (this.failedMembers != null && !this.failedMembers.isEmpty()) {
            allNodes.removeAll(this.failedMembers);
            allNodes.addAll(this.failedMembers);
        }
        Iterator dsItr = allNodes.iterator();
        while (dsItr.hasNext() && bucketIds.size() < totalBucketsToQuery) {
            InternalDistributedMember nd = (InternalDistributedMember)dsItr.next();
            ArrayList<Integer> buckets = new ArrayList<Integer>();
            for (Integer bid : bucketIdsToConsider) {
                Set<InternalDistributedMember> owners;
                if (bucketIds.contains(bid) || !(owners = this.pr.getRegionAdvisor().getBucketOwners(bid)).contains(nd)) continue;
                buckets.add(bid);
                bucketIds.add(bid);
            }
            if (buckets.isEmpty()) continue;
            ret.put(nd, buckets);
        }
        if (bucketIds.size() != totalBucketsToQuery) {
            bucketIdsToConsider.removeAll(bucketIds);
            throw new QueryException("Data loss detected, unable to find the hosting  node for some of the dataset. [dataset/bucket ids:" + bucketIdsToConsider + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Node to bucketId map: {}", ret);
        }
        return ret;
    }

    private boolean executeQueryOnLocalNode() throws QueryException, InterruptedException {
        long startTime = 0L;
        if (this.query.isTraced()) {
            startTime = NanoTimer.getTime();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.pr.getDataStore() != null) {
            this.pr.getDataStore().invokeBucketReadHook();
            InternalDistributedMember me = this.pr.getMyId();
            List bucketList = (List)this.node2bucketIds.get(me);
            try {
                PRQueryProcessor qp = new PRQueryProcessor(this.pr, this.query, this.parameters, bucketList);
                MemberResultsList resultCollector = new MemberResultsList();
                qp.executeQuery(resultCollector);
                if (!this.query.isRemoteQuery() && this.pr.getCompressor() == null && this.pr.getCache().isCopyOnRead() && (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL || qp.isIndexUsed() && DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL)) {
                    MemberResultsList tmpResultCollector = new MemberResultsList();
                    for (Object o : resultCollector) {
                        if (o instanceof Collection) {
                            Collection results = (Collection)o;
                            ArrayList tmpResults = new ArrayList();
                            for (Object collectionObject : results) {
                                tmpResults.add(CopyHelper.copy(collectionObject));
                            }
                            tmpResultCollector.add(tmpResults);
                            continue;
                        }
                        tmpResultCollector.add(CopyHelper.copy(o));
                    }
                    resultCollector = tmpResultCollector;
                }
                if (this.query.isTraced() && this.prQueryTraceInfoList != null) {
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook("Create PR Query Trace Info From Local Node");
                    }
                    PRQueryTraceInfo queryTraceInfo = new PRQueryTraceInfo();
                    queryTraceInfo.setNumResults(queryTraceInfo.calculateNumberOfResults(resultCollector));
                    queryTraceInfo.setTimeInMillis((float)(NanoTimer.getTime() - startTime) / 1000000.0f);
                    queryTraceInfo.setSender(me);
                    this.prQueryTraceInfoList.add(queryTraceInfo);
                }
                resultCollector.setLastChunkReceived(true);
                this.resultsPerMember.put(me, resultCollector);
            }
            catch (ForceReattemptException retryRequired) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught exception during local portion of query {}", this.query.getQueryString(), retryRequired);
                }
                return true;
            }
        }
        return false;
    }

    protected void memberStreamCorrupted(InternalDistributedMember sender) {
        this.resultsPerMember.remove(sender);
    }

    private void failMissingBuckets() throws QueryException {
        HashMap<InternalDistributedMember, ArrayList<Integer>> n2b = new HashMap<InternalDistributedMember, ArrayList<Integer>>();
        for (Integer bId : this.bucketsToQuery) {
            InternalDistributedMember node = this.findNodeForBucket(bId);
            ArrayList<Integer> listOfInts = (ArrayList<Integer>)n2b.get(node);
            if (listOfInts == null) {
                listOfInts = new ArrayList<Integer>();
                n2b.put(node, listOfInts);
            }
            listOfInts.add(bId);
        }
        this.pr.getCancelCriterion().checkCancelInProgress(null);
        String msg = "Query failed; unable to get results from the following node/buckets: " + n2b;
        logger.fatal(msg);
        throw new QueryException(msg);
    }

    private InternalDistributedMember findNodeForBucket(Integer bucketId) {
        for (Map.Entry entry : this.node2bucketIds.entrySet()) {
            List blist = (List)entry.getValue();
            for (Integer bid : blist) {
                if (!bid.equals(bucketId)) continue;
                return (InternalDistributedMember)entry.getKey();
            }
        }
        String msg = "Unable to get node for bucket id " + bucketId + " node to bucket map is " + this.node2bucketIds;
        logger.fatal(msg);
        throw new InternalGemFireError(msg);
    }

    public Map getResultsPerMember() {
        return this.resultsPerMember;
    }

    public class StreamingQueryPartitionResponse
    extends StreamingPartitionOperation.StreamingPartitionResponse {
        public StreamingQueryPartitionResponse(InternalDistributedSystem system, Set members) {
            super(PartitionedRegionQueryEvaluator.this, system, members);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            this.msgsBeingProcessed.incrementAndGet();
            try {
                StreamingOperation.StreamingReplyMessage m = (StreamingOperation.StreamingReplyMessage)msg;
                boolean isLast = true;
                List objects = m.getObjects();
                if (m.isCanceled()) {
                    String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString();
                    PartitionedRegionQueryEvaluator.this.query.setCanceled(true, new QueryExecutionLowMemoryException(reason));
                    this.abort = true;
                }
                if (objects != null) {
                    boolean isAborted = this.abort;
                    if (!isAborted) {
                        boolean bl = isAborted = !PartitionedRegionQueryEvaluator.this.processChunk(objects, m.getSender(), m.getMessageNumber(), m.isLastMessage());
                        if (isAborted) {
                            this.abort = true;
                        }
                    }
                    isLast = isAborted || this.trackMessage(m);
                } else {
                    isLast = true;
                }
                if (isLast) {
                    super.process(msg, false);
                }
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
            }
        }
    }

    public static class PRQueryResultCollector {
        private BlockingQueue resultQueue = new LinkedBlockingQueue();
        private final Map<String, IndexTrackingQueryObserver.IndexInfo> usedIndexInfoMap = new THashMap();

        public boolean isEmpty() {
            return this.resultQueue.isEmpty();
        }

        public void setResultQueue(BlockingQueue resultQueue) {
            this.resultQueue = resultQueue;
        }

        public Map getIndexInfoMap() {
            return this.usedIndexInfoMap;
        }

        public int size() {
            return this.resultQueue.size();
        }

        public Object get() throws InterruptedException {
            return this.resultQueue.take();
        }

        public void put(Object obj) throws InterruptedException {
            this.resultQueue.put(obj);
        }
    }

    public static interface TestHook {
        public void hook(int var1) throws RuntimeException;
    }

    public static class MemberResultsList
    extends ArrayList {
        private boolean isLastChunkReceived = false;

        public boolean isLastChunkReceived() {
            return this.isLastChunkReceived;
        }

        public void setLastChunkReceived(boolean isLastChunkReceived) {
            this.isLastChunkReceived = isLastChunkReceived;
        }
    }

    public static class TaintableArrayList
    extends ArrayList {
        private boolean isPoison = false;

        public synchronized void taint() {
            this.isPoison = true;
            super.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Object arg0) {
            TaintableArrayList taintableArrayList = this;
            synchronized (taintableArrayList) {
                if (this.isPoison) {
                    return false;
                }
                return super.add(arg0);
            }
        }

        public synchronized boolean isConsumable() {
            return !this.isPoison && this.size() > 0;
        }

        public synchronized boolean isTainted() {
            return this.isPoison;
        }

        public synchronized void untaint() {
            this.isPoison = false;
        }
    }
}

