/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.LocalRegionDataView;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import java.util.Set;

public class PartitionedRegionDataView
extends LocalRegionDataView {
    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        pr2.updateEntryVersionInBucket(event);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        pr2.invalidateInBucket(event);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        pr2.destroyInBucket(event, expectedOldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) {
        TXStateProxy tx = localRegion.cache.getTXMgr().internalSuspend();
        try {
            PartitionedRegion pr2 = (PartitionedRegion)localRegion;
            Region.Entry<?, ?> entry = pr2.nonTXGetEntry(keyInfo, false, allowTombstones);
            return entry;
        }
        finally {
            localRegion.cache.getTXMgr().resume(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findObject(KeyInfo key2, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value2, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        TXStateProxy tx = r.cache.getTXMgr().internalSuspend();
        try {
            Object object = r.findObjectInSystem(key2, isCreate, tx, generateCallbacks, value2, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
            return object;
        }
        finally {
            r.cache.getTXMgr().resume(tx);
        }
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.nonTXContainsKey(keyInfo);
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo keyInfo, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.getDataStore().getSerializedLocally(keyInfo, doNotLockEntry, clientEvent, returnTombstones);
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        return pr2.getDataStore().putLocally(event.getKeyInfo().getBucketId(), event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified);
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        pr2.getDataStore().destroyLocally(event.getKeyInfo().getBucketId(), event, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        pr2.getDataStore().invalidateLocally(event.getKeyInfo().getBucketId(), event);
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.getBucketKeys(bucketId, allowTombstones);
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.getDataStore().getEntryLocally(keyInfo.getBucketId(), keyInfo.getKey(), false, allowTombstones);
    }

    @Override
    public Object getKeyForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        return curr.getKey();
    }

    @Override
    public Region.Entry<?, ?> getEntryForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberRead, boolean allowTombstones) {
        return currRgn.nonTXGetEntry(keyInfo, false, allowTombstones);
    }
}

