/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ExternalizableDSFID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.Node;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.util.Versionable;
import com.gemstone.gemfire.internal.util.VersionedArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PartitionRegionConfig
extends ExternalizableDSFID
implements Versionable {
    int prId;
    PartitionAttributesImpl pAttrs;
    Scope scope = null;
    private VersionedArrayList nodes = null;
    private boolean isDestroying = false;
    private boolean isColocationComplete;
    private volatile boolean firstDataStoreCreated = false;
    private String fullPath = null;
    private String partitionResolver = null;
    private String colocatedWith = null;
    private EvictionAttributes ea = new EvictionAttributesImpl();
    private ExpirationAttributes regionTimeToLive = null;
    private ExpirationAttributes regionIdleTimeout = null;
    private ExpirationAttributes entryTimeToLive = null;
    private ExpirationAttributes entryIdleTimeout = null;
    private Set<FixedPartitionAttributesImpl> elderFPAs = null;
    private ArrayList<String> partitionListenerClassNames = new ArrayList();
    private Set<String> gatewaySenderIds = Collections.emptySet();

    public Set<String> getGatewaySenderIds() {
        return this.gatewaySenderIds;
    }

    public PartitionRegionConfig() {
    }

    PartitionRegionConfig(int prId, String path, PartitionAttributes prAtt, Scope sc) {
        this.prId = prId;
        this.pAttrs = (PartitionAttributesImpl)prAtt;
        this.scope = sc;
        this.isDestroying = false;
        this.nodes = new VersionedArrayList();
        if (prAtt.getPartitionResolver() != null) {
            this.partitionResolver = prAtt.getPartitionResolver().getClass().getName();
        }
        this.colocatedWith = prAtt.getColocatedWith();
        this.isColocationComplete = this.colocatedWith == null;
        this.fullPath = path;
        this.firstDataStoreCreated = prAtt.getLocalMaxMemory() > 0;
        this.elderFPAs = new LinkedHashSet<FixedPartitionAttributesImpl>();
        PartitionListener[] prListeners = prAtt.getPartitionListeners();
        if (prListeners != null && prListeners.length != 0) {
            for (int i = 0; i < prListeners.length; ++i) {
                PartitionListener listener = prListeners[i];
                this.partitionListenerClassNames.add(listener.getClass().getName());
            }
        }
    }

    PartitionRegionConfig(int prId, String path, PartitionAttributes prAtt, Scope sc, EvictionAttributes ea, ExpirationAttributes regionIdleTimeout, ExpirationAttributes regionTimeToLive, ExpirationAttributes entryIdleTimeout, ExpirationAttributes entryTimeToLive, Set<String> gatewaySenderIds) {
        this.prId = prId;
        this.pAttrs = (PartitionAttributesImpl)prAtt;
        this.scope = sc;
        this.isDestroying = false;
        this.nodes = new VersionedArrayList();
        if (prAtt.getPartitionResolver() != null) {
            this.partitionResolver = prAtt.getPartitionResolver().getClass().getName();
        }
        this.colocatedWith = prAtt.getColocatedWith();
        if (prAtt.getLocalMaxMemory() > 0) {
            this.ea = ea;
            this.firstDataStoreCreated = prAtt.getLocalMaxMemory() > 0;
        }
        this.regionIdleTimeout = regionIdleTimeout;
        this.regionTimeToLive = regionTimeToLive;
        this.entryIdleTimeout = entryIdleTimeout;
        this.entryTimeToLive = entryTimeToLive;
        this.isColocationComplete = this.colocatedWith == null;
        this.fullPath = path;
        this.elderFPAs = new LinkedHashSet<FixedPartitionAttributesImpl>();
        PartitionListener[] prListeners = prAtt.getPartitionListeners();
        if (prListeners != null && prListeners.length != 0) {
            for (int i = 0; i < prListeners.length; ++i) {
                PartitionListener listener = prListeners[i];
                this.partitionListenerClassNames.add(listener.getClass().getName());
            }
        }
        this.gatewaySenderIds = gatewaySenderIds;
    }

    Set<Node> getNodes() {
        if (this.nodes != null) {
            return this.nodes.getListCopy();
        }
        return null;
    }

    int getNumberOfNodes() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    boolean containsNode(Node check) {
        if (this.nodes != null) {
            return this.nodes.contains(check);
        }
        return false;
    }

    boolean containsMember(InternalDistributedMember memberId) {
        if (this.nodes != null) {
            for (Node node : this.nodes) {
                if (!memberId.equals(node.getMemberId())) continue;
                return true;
            }
        }
        return false;
    }

    void addNode(Node newNode) {
        if (this.nodes != null) {
            this.nodes.add(newNode);
        }
    }

    void removeNode(Node targetNode) {
        if (this.nodes != null) {
            this.nodes.remove(targetNode);
        }
    }

    public int getPRId() {
        return this.prId;
    }

    PartitionAttributes getPartitionAttrs() {
        return this.pAttrs;
    }

    Scope getScope() {
        return this.scope;
    }

    public String toString() {
        String ret = "PartitionRegionConfig@" + System.identityHashCode(this) + ";prId=" + this.prId + ";scope=" + this.scope + ";partition attributes=" + this.pAttrs + ";partitionResolver=" + this.partitionResolver + ";colocatedWith=" + this.colocatedWith + ";eviction attributes=" + this.ea + ";regionIdleTimeout= " + this.regionIdleTimeout + ";regionTimeToLive= " + this.regionTimeToLive + ";entryIdleTimeout= " + this.entryIdleTimeout + ";entryTimeToLive= " + this.entryTimeToLive + "'elderFPAs=" + this.elderFPAs + "'gatewaySenderIds=" + this.gatewaySenderIds + ";nodes=";
        if (this.nodes != null) {
            return ret + this.nodes;
        }
        return ret + "null";
    }

    @Override
    public int getDSFID() {
        return -100;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.prId);
        out.writeByte(this.scope.ordinal);
        InternalDataSerializer.invokeToData(this.pAttrs, out);
        out.writeBoolean(this.isDestroying);
        out.writeBoolean(this.isColocationComplete);
        InternalDataSerializer.invokeToData(this.nodes, out);
        DataSerializer.writeString(this.partitionResolver, out);
        DataSerializer.writeString(this.colocatedWith, out);
        DataSerializer.writeString(this.fullPath, out);
        InternalDataSerializer.invokeToData(this.ea, out);
        InternalDataSerializer.invokeToData(this.regionIdleTimeout, out);
        InternalDataSerializer.invokeToData(this.regionTimeToLive, out);
        InternalDataSerializer.invokeToData(this.entryIdleTimeout, out);
        InternalDataSerializer.invokeToData(this.entryTimeToLive, out);
        out.writeBoolean(this.firstDataStoreCreated);
        DataSerializer.writeObject(this.elderFPAs, out);
        DataSerializer.writeArrayList(this.partitionListenerClassNames, out);
        if (this.gatewaySenderIds.isEmpty()) {
            DataSerializer.writeObject(null, out);
        } else {
            DataSerializer.writeObject(this.gatewaySenderIds, out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.prId = in.readInt();
        this.scope = Scope.fromOrdinal(in.readByte());
        this.pAttrs = PartitionAttributesImpl.createFromData(in);
        this.isDestroying = in.readBoolean();
        this.isColocationComplete = in.readBoolean();
        this.nodes = new VersionedArrayList();
        InternalDataSerializer.invokeFromData(this.nodes, in);
        this.partitionResolver = DataSerializer.readString(in);
        this.colocatedWith = DataSerializer.readString(in);
        this.fullPath = DataSerializer.readString(in);
        this.ea = EvictionAttributesImpl.createFromData(in);
        this.regionIdleTimeout = ExpirationAttributes.createFromData(in);
        this.regionTimeToLive = ExpirationAttributes.createFromData(in);
        this.entryIdleTimeout = ExpirationAttributes.createFromData(in);
        this.entryTimeToLive = ExpirationAttributes.createFromData(in);
        this.firstDataStoreCreated = in.readBoolean();
        this.elderFPAs = (Set)DataSerializer.readObject(in);
        if (this.elderFPAs == null) {
            this.elderFPAs = new LinkedHashSet<FixedPartitionAttributesImpl>();
        }
        this.partitionListenerClassNames = DataSerializer.readArrayList(in);
        this.gatewaySenderIds = (Set)DataSerializer.readObject(in);
        if (this.gatewaySenderIds == null) {
            this.gatewaySenderIds = Collections.emptySet();
        }
    }

    boolean getIsDestroying() {
        return this.isDestroying;
    }

    void setIsDestroying() {
        this.isDestroying = true;
    }

    void setColocationComplete() {
        this.isColocationComplete = true;
    }

    public boolean isGreaterNodeListVersion(PartitionRegionConfig other) {
        return this.nodes.isNewerThan(other.nodes);
    }

    @Override
    public Comparable getVersion() {
        return this.nodes.getVersion();
    }

    @Override
    public boolean isNewerThan(Versionable other) {
        return this.nodes.isNewerThan(other);
    }

    @Override
    public boolean isSame(Versionable other) {
        return this.nodes.isSame(other);
    }

    @Override
    public boolean isOlderThan(Versionable other) {
        return this.nodes.isOlderThan(other);
    }

    public String getResolverClassName() {
        return this.partitionResolver;
    }

    public String getColocatedWith() {
        return this.colocatedWith;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isColocationComplete() {
        return this.isColocationComplete;
    }

    public EvictionAttributes getEvictionAttributes() {
        return this.ea;
    }

    public final ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    public final ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    public final ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    public final ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    public boolean isFirstDataStoreCreated() {
        return this.firstDataStoreCreated;
    }

    public void addFPAs(List<FixedPartitionAttributesImpl> fpaList) {
        if (this.elderFPAs != null) {
            this.elderFPAs.addAll(fpaList);
        }
    }

    public Set<FixedPartitionAttributesImpl> getElderFPAs() {
        return this.elderFPAs;
    }

    public ArrayList<String> getPartitionListenerClassNames() {
        return this.partitionListenerClassNames;
    }

    public boolean hasSameDataStoreMembers(PartitionRegionConfig prConfig) {
        for (Node node : this.getNodes()) {
            if (prConfig.containsMember(node.getMemberId()) || node.getPRType() != 3 && node.getPRType() != 5) continue;
            return false;
        }
        for (Node node : prConfig.getNodes()) {
            if (this.containsMember(node.getMemberId()) || node.getPRType() != 3 && node.getPRType() != 5) continue;
            return false;
        }
        return true;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public void setDatastoreCreated(EvictionAttributes evictionAttributes) {
        this.firstDataStoreCreated = true;
        this.ea = evictionAttributes;
    }
}

