/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.SearchLoadAndWriteProcessor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class LoaderHelperImpl
implements LoaderHelper {
    public static final StringId NET_SEARCH_LOCAL = LocalizedStrings.LoaderHelperImpl_CANNOT_NETSEARCH_FOR_A_SCOPELOCAL_OBJECT;
    private final Object key;
    private final boolean netSearchAllowed;
    private final boolean netLoadAllowed;
    private final Region region;
    private final Object aCallbackArgument;
    private SearchLoadAndWriteProcessor searcher = null;

    public LoaderHelperImpl(Region region, Object key2, Object aCallbackArgument, boolean netSearchAllowed, SearchLoadAndWriteProcessor searcher) {
        this.region = region;
        this.key = key2;
        this.aCallbackArgument = aCallbackArgument;
        this.netSearchAllowed = netSearchAllowed;
        this.netLoadAllowed = true;
        this.searcher = searcher;
    }

    public LoaderHelperImpl(Region region, Object key2, Object aCallbackArgument, boolean netSearchAllowed, boolean netLoadAllowed, SearchLoadAndWriteProcessor searcher) {
        this.region = region;
        this.key = key2;
        this.aCallbackArgument = aCallbackArgument;
        this.netSearchAllowed = netSearchAllowed;
        this.netLoadAllowed = netLoadAllowed;
        this.searcher = searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object netSearch(boolean doNetLoad) throws CacheLoaderException, TimeoutException {
        if (this.region.getAttributes().getScope().isLocal()) {
            throw new CacheLoaderException(NET_SEARCH_LOCAL.toLocalizedString());
        }
        boolean removeSearcher = false;
        if (this.searcher == null) {
            this.searcher = SearchLoadAndWriteProcessor.getProcessor();
            removeSearcher = true;
        }
        try {
            if (removeSearcher) {
                this.searcher.initialize((LocalRegion)this.region, this.key, this.aCallbackArgument);
            }
            Object obj = null;
            if (this.netSearchAllowed) {
                obj = this.searcher.doNetSearch();
                if (this.searcher.resultIsSerialized()) {
                    obj = EntryEventImpl.deserialize((byte[])obj);
                }
            }
            if (doNetLoad && obj == null && this.netLoadAllowed) {
                obj = this.searcher.doNetLoad();
                if (this.searcher.resultIsSerialized()) {
                    obj = EntryEventImpl.deserialize((byte[])obj);
                }
            }
            Object object = obj;
            return object;
        }
        finally {
            if (removeSearcher) {
                this.searcher.remove();
            }
        }
    }

    public Object getKey() {
        return this.key;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Object getArgument() {
        return this.aCallbackArgument;
    }

    public String toString() {
        return "LoaderHelper region: " + this.getRegion() + " key: " + this.getKey() + " argument: " + this.getArgument();
    }
}

