/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXMessage;
import com.gemstone.gemfire.internal.cache.TXRemoteCommitMessage;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class JtaAfterCompletionMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();
    private int status;
    private int processorType;

    public JtaAfterCompletionMessage() {
    }

    @Override
    public int getProcessorType() {
        return this.processorType;
    }

    public JtaAfterCompletionMessage(int status, int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
        this.status = status;
    }

    public static TXRemoteCommitMessage.RemoteCommitResponse send(Cache cache, int txId, InternalDistributedMember onBehalfOfClientMember, int status, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        TXRemoteCommitMessage.RemoteCommitResponse response = new TXRemoteCommitMessage.RemoteCommitResponse(system, recipients);
        JtaAfterCompletionMessage msg = new JtaAfterCompletionMessage(status, txId, onBehalfOfClientMember, response);
        msg.setRecipients(recipients);
        msg.processorType = system.threadOwnsResources() ? 74 : 75;
        system.getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        TXManagerImpl txMgr = GemFireCacheImpl.getInstance().getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("JTA: Calling afterCompletion for :{}", txId);
        }
        TXStateProxy txState = txMgr.getTXState();
        txState.setCommitOnBehalfOfRemoteStub(true);
        txState.afterCompletion(this.status);
        TXCommitMessage cmsg = txState.getCommitMessage();
        TXRemoteCommitMessage.TXRemoteCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        txMgr.removeHostedTXState(txId);
        return false;
    }

    @Override
    public int getDSFID() {
        return -115;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.status);
        out.writeInt(this.processorType);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.status = in.readInt();
        this.processorType = in.readInt();
    }
}

