/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.ProcessorKeeper21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class InitialImageFlowControl
implements MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private static final ProcessorKeeper21 keeper = new ProcessorKeeper21(false);
    private int id;
    private int maxPermits = InitialImageOperation.CHUNK_PERMITS;
    private final Semaphore permits = new Semaphore(this.maxPermits);
    private final DM dm;
    private final InternalDistributedMember target;
    private final AtomicBoolean aborted = new AtomicBoolean();

    public static InitialImageFlowControl register(DM dm, InternalDistributedMember target) {
        int id;
        InitialImageFlowControl control = new InitialImageFlowControl(dm, target);
        control.id = id = keeper.put(control);
        Set availableIds = dm.addMembershipListenerAndGetDistributionManagerIds(control);
        if (!availableIds.contains(target)) {
            control.abort();
        }
        return control;
    }

    private InitialImageFlowControl(DM dm, InternalDistributedMember target) {
        this.dm = dm;
        this.target = target;
    }

    private void releasePermit() {
        this.permits.release();
        this.incMessagesInFlight(-1);
    }

    private void incMessagesInFlight(int val) {
        this.dm.getStats().incInitialImageMessagesInFlight(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquirePermit() {
        long startWaitTime = System.currentTimeMillis();
        while (!this.aborted.get()) {
            this.checkCancellation();
            boolean interrupted = false;
            try {
                this.basicWait(startWaitTime);
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.checkCancellation();
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
        if (!this.aborted.get()) {
            this.incMessagesInFlight(1);
        }
    }

    private void basicWait(long startWaitTime) throws InterruptedException {
        long timeout = (long)this.getAckWaitThreshold() * 1000L;
        long timeSoFar = System.currentTimeMillis() - startWaitTime;
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        if (!this.aborted.get() && !this.permits.tryAcquire(timeout - timeSoFar - 1L, TimeUnit.MILLISECONDS)) {
            this.checkCancellation();
            Set activeMembers = this.dm.getDistributionManagerIds();
            Object[] msgArgs = new Object[]{this.getAckWaitThreshold(), this, this.dm.getId(), activeMembers};
            StringId msg = LocalizedStrings.ReplyProcessor21_0_SEC_HAVE_ELAPSED_WHILE_WAITING_FOR_REPLIES_1_ON_2_WHOSE_CURRENT_MEMBERSHIP_LIST_IS_3;
            logger.warn(LocalizedMessage.create(msg, msgArgs));
            this.permits.acquire();
            logger.info(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_WAIT_FOR_REPLIES_COMPLETED_1, "InitialImageFlowControl"));
        }
    }

    private int getAckWaitThreshold() {
        return this.dm.getConfig().getAckWaitThreshold();
    }

    private void checkCancellation() {
        this.dm.getCancelCriterion().checkCancelInProgress(null);
    }

    public void unregister() {
        this.dm.removeMembershipListener(this);
        keeper.remove(this.id);
        this.abort();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        if (id.equals(this.target)) {
            this.abort();
        }
    }

    private void abort() {
        if (!this.aborted.getAndSet(true)) {
            this.incMessagesInFlight(-(this.maxPermits - this.permits.availablePermits()));
            this.permits.release(0x3FFFFFFF);
        }
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    public String toString() {
        return "<InitialImageFlowControl for GII to " + this.target + " with " + this.permits.availablePermits() + " available permits>";
    }

    public static class FlowControlPermitMessage
    extends DistributionMessage
    implements DataSerializableFixedID {
        private int keeperId;

        private FlowControlPermitMessage(int keeperId2) {
            this.keeperId = keeperId2;
        }

        public FlowControlPermitMessage() {
        }

        public static void send(DM dm, InternalDistributedMember recipient, int keeperId) {
            FlowControlPermitMessage message = new FlowControlPermitMessage(keeperId);
            message.setRecipient(recipient);
            dm.putOutgoing(message);
        }

        @Override
        public int getProcessorType() {
            return 73;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        @Override
        protected void process(DistributionManager dm) {
            InitialImageFlowControl control = (InitialImageFlowControl)keeper.retrieve(this.keeperId);
            if (control != null) {
                control.releasePermit();
            }
        }

        @Override
        public int getDSFID() {
            return 2120;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.keeperId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.keeperId);
        }
    }
}

