/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class IdentityArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 449125332499184497L;
    private transient Object[] elementData;
    private int size;

    public IdentityArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(LocalizedStrings.IdentityArrayList_ILLEGAL_CAPACITY_0.toLocalizedString(initialCapacity));
        }
        this.elementData = new Object[initialCapacity];
    }

    public IdentityArrayList() {
        this(10);
    }

    public IdentityArrayList(Collection c) {
        this.size = c.size();
        this.elementData = new Object[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        c.toArray(this.elementData);
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public Object[] getArrayRef() {
        return this.elementData;
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elementData[i] != elem) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.elementData[i] != elem) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IdentityArrayList v = (IdentityArrayList)super.clone();
            v.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Object get(int index2) {
        this.RangeCheck(index2);
        return this.elementData[index2];
    }

    public Object set(int index2, Object element) {
        this.RangeCheck(index2);
        Object oldValue = this.elementData[index2];
        this.elementData[index2] = element;
        return oldValue;
    }

    @Override
    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    public void add(int index2, Object element) {
        if (index2 > this.size || index2 < 0) {
            throw new IndexOutOfBoundsException(LocalizedStrings.IdentityArrayList_INDEX_0_SIZE_1.toLocalizedString(index2, this.size));
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index2, this.elementData, index2 + 1, this.size - index2);
        this.elementData[index2] = element;
        ++this.size;
    }

    public Object remove(int index2) {
        this.RangeCheck(index2);
        ++this.modCount;
        Object oldValue = this.elementData[index2];
        int numMoved = this.size - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index2 + 1, this.elementData, index2, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    public boolean addAll(int index2, Collection c) {
        if (index2 > this.size || index2 < 0) {
            throw new IndexOutOfBoundsException(LocalizedStrings.IdentityArrayList_INDEX_0_SIZE_1.toLocalizedString(index2, this.size));
        }
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index2;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index2, this.elementData, index2 + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index2, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = null;
        }
    }

    private void RangeCheck(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException(LocalizedStrings.IdentityArrayList_INDEX_0_SIZE_1.toLocalizedString(index2, this.size));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new Object[arrayLength];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = s.readObject();
        }
    }
}

