/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireCacheException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheEventProcessor;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientRegionFactoryImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.snapshot.CacheSnapshotService;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.PooledExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.ResourceEventsListener;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SocketIOWithTimeout;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.AddCacheServerProfileMessage;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.CacheLifecycleListener;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CloseCacheMessage;
import com.gemstone.gemfire.internal.cache.ClusterConfigurationLoader;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreMonitor;
import com.gemstone.gemfire.internal.cache.DiskStoreTask;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DynamicRegionFactoryImpl;
import com.gemstone.gemfire.internal.cache.EventTracker;
import com.gemstone.gemfire.internal.cache.ExpirationScheduler;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GemfireCacheHelper;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.HasCachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalCache;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.MinimumSystemRequirements;
import com.gemstone.gemfire.internal.cache.PRContainsValueFunction;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.RegionFactoryImpl;
import com.gemstone.gemfire.internal.cache.ReliableMessageQueueFactory;
import com.gemstone.gemfire.internal.cache.ReliableMessageQueueFactoryImpl;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXEntryStateFactory;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.UserSpecifiedRegionAttributes;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.gemstone.gemfire.internal.cache.execute.util.FindRestEnabledServersFunction;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.ExtensionPoint;
import com.gemstone.gemfire.internal.cache.extension.SimpleExtensionPoint;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.locks.TXLockService;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import com.gemstone.gemfire.internal.cache.persistence.BackupManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.query.TemporaryResultSetFactory;
import com.gemstone.gemfire.internal.cache.snapshot.CacheSnapshotServiceImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientHealthMonitor;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverFactoryImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlPropertyResolver;
import com.gemstone.gemfire.internal.cache.xmlcache.PropertyResolver;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jndi.JNDIInvoker;
import com.gemstone.gemfire.internal.jta.TransactionManagerImpl;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.process.ClusterConfigurationNotAvailableException;
import com.gemstone.gemfire.internal.sequencelog.SequenceLoggerImpl;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.internal.util.concurrent.FutureResult;
import com.gemstone.gemfire.lang.Identifiable;
import com.gemstone.gemfire.management.internal.JmxManagerAdvisee;
import com.gemstone.gemfire.management.internal.JmxManagerAdvisor;
import com.gemstone.gemfire.management.internal.RestAgent;
import com.gemstone.gemfire.management.internal.beans.ManagementListener;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationResponse;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxInstanceFactory;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.ReflectionBasedAutoSerializer;
import com.gemstone.gemfire.pdx.internal.AutoSerializableManager;
import com.gemstone.gemfire.pdx.internal.PdxInstanceFactoryImpl;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.logging.log4j.Logger;

public class GemFireCacheImpl
implements InternalCache,
ClientCache,
HasCachePerfStats,
DistributionAdvisee,
Extensible<Cache> {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_LOCK_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultLockTimeout", 60);
    public static final int DEFAULT_LOCK_LEASE = Integer.getInteger("gemfire.Cache.defaultLockLease", 120);
    public static final boolean DEFAULT_COPY_ON_READ = false;
    private static volatile GemFireCacheImpl instance = null;
    private static volatile GemFireCacheImpl pdxInstance = null;
    public static final int DEFAULT_SEARCH_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultSearchTimeout", 300);
    private static final Set<CacheLifecycleListener> cacheLifecycleListeners = new HashSet<CacheLifecycleListener>();
    public static final boolean ASYNC_EVENT_LISTENERS = Boolean.getBoolean("gemfire.Cache.ASYNC_EVENT_LISTENERS");
    public static boolean DELTAS_RECALCULATE_SIZE = Boolean.getBoolean("gemfire.DELTAS_RECALCULATE_SIZE");
    public static final int EVENT_QUEUE_LIMIT = Integer.getInteger("gemfire.Cache.EVENT_QUEUE_LIMIT", 4096);
    public static final int MAX_QUERY_EXECUTION_TIME = Integer.getInteger("gemfire.Cache.MAX_QUERY_EXECUTION_TIME", -1);
    public final boolean QUERY_MONITOR_DISABLED_FOR_LOW_MEM = Boolean.getBoolean("gemfire.Cache.DISABLE_QUERY_MONITOR_FOR_LOW_MEMORY");
    public static Boolean QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER = Boolean.FALSE;
    public static final String FIND_REST_ENABLED_SERVERS_FUNCTION_ID = FindRestEnabledServersFunction.class.getName();
    private static final int FIVE_HOURS = 18000000;
    public int TEST_MAX_QUERY_EXECUTION_TIME = -1;
    public boolean TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION = false;
    private final InternalDistributedSystem system;
    private final DM dm;
    private final HashMap rootRegions;
    private final boolean isClient;
    private PoolFactory clientpf;
    private Pool defaultPool;
    private final ConcurrentMap pathToRegion = new ConcurrentHashMap();
    protected volatile boolean isClosing = false;
    protected volatile boolean closingGatewayHubsByShutdownAll = false;
    protected volatile boolean closingGatewaySendersByShutdownAll = false;
    protected volatile boolean closingGatewayReceiversByShutdownAll = false;
    private int lockTimeout = DEFAULT_LOCK_TIMEOUT;
    private int lockLease = DEFAULT_LOCK_LEASE;
    private int searchTimeout = DEFAULT_SEARCH_TIMEOUT;
    private final CachePerfStats cachePerfStats;
    private final Date creationDate;
    private final ThreadPoolExecutor eventThreadPool;
    private boolean sqlfSystem;
    private volatile DistributionAdvisee sqlfAdvisee;
    private volatile List allBridgeServers = new CopyOnWriteArrayList();
    public final Object allGatewaySendersLock = new Object();
    private volatile Set<GatewaySender> allGatewaySenders = Collections.emptySet();
    private volatile Set<AsyncEventQueue> allAsyncEventQueues = new CopyOnWriteArraySet<AsyncEventQueue>();
    public final Object allGatewayReceiversLock = new Object();
    private volatile Set<GatewayReceiver> allGatewayReceivers = Collections.emptySet();
    private final HashSet<PartitionedRegion> partitionedRegions = new HashSet();
    private final ConcurrentMap<String, DistributedRegion> regionsInDestroy = new ConcurrentHashMap<String, DistributedRegion>();
    private volatile GatewayHubImpl[] allGatewayHubs = new GatewayHubImpl[0];
    public final Object allGatewayHubsLock = new Object();
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean isServer = false;
    private final TXManagerImpl txMgr;
    private RestAgent restAgent;
    private boolean isRESTServiceRunning = false;
    private volatile boolean copyOnRead = false;
    private final Map namedRegionAttributes = Collections.synchronizedMap(new HashMap());
    private boolean forcedDisconnect;
    protected volatile Throwable disconnectCause = null;
    public Exception creationStack = null;
    private EventTracker.ExpiryTask recordedEventSweeper;
    private TombstoneService tombstoneService;
    private DistributedLockService prLockService;
    private final Object prLockServiceLock = new Object();
    private volatile DistributedLockService gatewayLockService;
    private final Object gatewayLockServiceLock = new Object();
    private final InternalResourceManager resourceManager;
    private final AtomicReference<BackupManager> backupManager = new AtomicReference();
    private HeapEvictor heapEvictor = null;
    private final Object heapEvictorLock = new Object();
    private ResourceEventsListener listener;
    private static final boolean DEBUG_CREATION_STACK = false;
    private volatile QueryMonitor queryMonitor;
    private final Object queryMonitorLock = new Object();
    private final PersistentMemberManager persistentMemberManager;
    private ClientMetadataService clientMetadatService = null;
    private final Object clientMetaDatServiceLock = new Object();
    private volatile boolean isShutDownAll = false;
    private final HashSet<InternalDistributedMember> unInitializedMembers = new HashSet();
    private final LinkedHashSet<BucketAdvisor> deferredVolunteerForPrimary = new LinkedHashSet();
    private final ResourceAdvisor resourceAdvisor;
    private final JmxManagerAdvisor jmxAdvisor;
    private final int serialNumber;
    public static final String SQLFABRIC_PRODUCT_PROP = "sqlfabric.product";
    private final TXEntryStateFactory txEntryStateFactory;
    static final String SQLF_ENTRY_FACTORY_PROVIDER = "com.gemstone.sqlfabric.internal.engine.store.entry.RegionEntryFactoryProvider";
    private final CacheConfig cacheConfig;
    private final DiskStoreMonitor diskMonitor;
    private final Map<Declarable, Properties> declarablePropertiesMap = new ConcurrentHashMap<Declarable, Properties>();
    protected static PropertyResolver resolver;
    protected static boolean xmlParameterizationEnabled;
    private GemFireMemcachedServer memcachedServer;
    private SimpleExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<GemFireCacheImpl>(this, this);
    public static final int DEFAULT_CLIENT_FUNCTION_TIMEOUT = 0;
    private static int clientFunctionTimeout;
    private final ConcurrentMap reinitializingRegions = new ConcurrentHashMap();
    public static File testCacheXml;
    private final Stopper stopper = new Stopper();
    private boolean keepAlive;
    private static volatile boolean emergencyClassesLoaded;
    private static final int shutdownAllPoolSize;
    private final boolean DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE = Boolean.getBoolean("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
    private final AtomicBoolean diskStoreTaskSync = new AtomicBoolean(false);
    private ThreadPoolExecutor diskStoreTaskPool = null;
    private final ConcurrentMap<String, DiskStoreImpl> diskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    private final ConcurrentMap<String, DiskStoreImpl> regionOwnedDiskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    public static String DEFAULT_DS_NAME;
    private SystemTimer ccpTimer;
    private final Object ccpTimerMutex = new Object();
    private final ExpirationScheduler expirationScheduler;
    private static final ThreadLocal xmlCache;
    private ReliableMessageQueueFactory rmqFactory;
    private List<File> backupFiles = Collections.emptyList();
    private final AtomicInteger registerInterestsInProgress = new AtomicInteger();
    private final ArrayList<SimpleWaiter> riWaiters = new ArrayList();
    private TypeRegistry pdxRegistry;
    private Declarable initializer;
    private Properties initializerProps;
    private TemporaryResultSetFactory resultSetFactory;

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("GemFireCache[");
        sb.append("id = " + System.identityHashCode(this));
        sb.append("; isClosing = " + this.isClosing);
        sb.append("; isShutDownAll = " + this.isShutDownAll);
        sb.append("; closingGatewayHubsByShutdownAll = " + this.closingGatewayHubsByShutdownAll);
        sb.append("; created = " + this.creationDate);
        sb.append("; server = " + this.isServer);
        sb.append("; copyOnRead = " + this.copyOnRead);
        sb.append("; lockLease = " + this.lockLease);
        sb.append("; lockTimeout = " + this.lockTimeout);
        if (this.creationStack != null) {
            sb.append("\nCreation context:\n");
            OutputStream os = new OutputStream(){

                @Override
                public void write(int i) {
                    sb.append((char)i);
                }
            };
            PrintStream ps = new PrintStream(os);
            this.creationStack.printStackTrace(ps);
        }
        sb.append("]");
        return sb.toString();
    }

    public static GemFireCacheImpl getInstance() {
        return instance;
    }

    public static final GemFireCacheImpl getExisting() {
        GemFireCacheImpl result = instance;
        if (result != null && !result.isClosing) {
            return result;
        }
        if (result != null) {
            throw result.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
    }

    public static GemFireCacheImpl getExisting(String reason) {
        GemFireCacheImpl result = GemFireCacheImpl.getInstance();
        if (result == null) {
            throw new CacheClosedException(reason);
        }
        return result;
    }

    public static GemFireCacheImpl getForPdx(String reason) {
        GemFireCacheImpl result = pdxInstance;
        if (result == null) {
            throw new CacheClosedException(reason);
        }
        return result;
    }

    public static GemFireCacheImpl create(boolean isClient, PoolFactory pf, DistributedSystem system, CacheConfig cacheConfig) {
        return new GemFireCacheImpl(true, pf, system, cacheConfig).init();
    }

    public static GemFireCacheImpl create(DistributedSystem system, CacheConfig cacheConfig) {
        return new GemFireCacheImpl(false, null, system, cacheConfig).init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GemFireCacheImpl(boolean isClient, PoolFactory pf, DistributedSystem system, CacheConfig cacheConfig) {
        this.isClient = isClient;
        this.clientpf = pf;
        this.cacheConfig = cacheConfig;
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            JNDIInvoker.mapTransactions();
            this.system = (InternalDistributedSystem)system;
            this.dm = this.system.getDistributionManager();
            if (!this.isClient && PoolManager.getAll().isEmpty()) {
                this.listener = new ManagementListener();
                this.system.addResourceListener(this.listener);
            } else {
                this.listener = null;
            }
            DM dm = this.system.getDistributionManager();
            if (dm instanceof DistributionManager && ((DistributionManager)dm).getDMType() == 12) {
                throw new IllegalStateException(LocalizedStrings.GemFireCache_CANNOT_CREATE_A_CACHE_IN_AN_ADMINONLY_VM.toLocalizedString());
            }
            this.rootRegions = new HashMap();
            this.initReliableMessageQueueFactory();
            this.cachePerfStats = new CachePerfStats(system);
            CachePerfStats.enableClockStats = this.system.getConfig().getEnableTimeStatistics();
            this.txMgr = new TXManagerImpl(this.cachePerfStats, this);
            dm.addMembershipListener(this.txMgr);
            this.creationDate = new Date();
            this.persistentMemberManager = new PersistentMemberManager();
            if (ASYNC_EVENT_LISTENERS) {
                final LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Message Event Threads", logger);
                ThreadFactory tf = new ThreadFactory(){

                    @Override
                    public Thread newThread(final Runnable command) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                ConnectionTable.threadWantsSharedResources();
                                command.run();
                            }
                        };
                        Thread thread = new Thread(group, r, "Message Event Thread");
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(EVENT_QUEUE_LIMIT);
                this.eventThreadPool = new PooledExecutorWithDMStats(q, 16, this.cachePerfStats.getEventPoolHelper(), tf, 1000, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            } else {
                this.eventThreadPool = null;
            }
            this.resourceAdvisor = ResourceAdvisor.createResourceAdvisor(this);
            this.jmxAdvisor = JmxManagerAdvisor.createJmxManagerAdvisor(new JmxManagerAdvisee(this));
            this.resourceManager = InternalResourceManager.createResourceManager(this);
            this.serialNumber = DistributionAdvisor.createSerialNumber();
            this.getResourceManager().addResourceListener(this.getHeapEvictor());
            this.recordedEventSweeper = EventTracker.startTrackerServices(this);
            this.tombstoneService = TombstoneService.initialize(this);
            TypeRegistry.init();
            this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
            TypeRegistry.open();
            if (!this.isClient()) {
                HARegionQueue.setMessageSyncInterval(1);
            }
            FunctionService.registerFunction(new PRContainsValueFunction());
            this.expirationScheduler = new ExpirationScheduler(this.system);
            this.sqlfSystem = Boolean.getBoolean(SQLFABRIC_PRODUCT_PROP);
            if (this.sqlfSystem) {
                String provider = SQLF_ENTRY_FACTORY_PROVIDER;
                try {
                    TXEntryStateFactory ref;
                    Class<?> factoryProvider = Class.forName(provider);
                    Method method = factoryProvider.getDeclaredMethod("getTXEntryStateFactory", new Class[0]);
                    this.txEntryStateFactory = ref = (TXEntryStateFactory)method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new CacheRuntimeException("Exception in obtaining SQLFabric RegionEntry Factory provider class", e){
                        private static final long serialVersionUID = -6456778743822843838L;
                    };
                }
            } else {
                this.txEntryStateFactory = TXEntryState.getFactory();
            }
            if (xmlParameterizationEnabled) {
                Properties userProps = this.system.getConfig().getUserDefinedProps();
                resolver = userProps != null && !userProps.isEmpty() ? new CacheXmlPropertyResolver(false, 1, userProps) : new CacheXmlPropertyResolver(false, 1, null);
            }
            SystemFailure.signalCacheCreate();
            this.diskMonitor = new DiskStoreMonitor();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public boolean isRESTServiceRunning() {
        return this.isRESTServiceRunning;
    }

    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        this.isRESTServiceRunning = isRESTServiceRunning;
    }

    public RestAgent getRestAgent() {
        return this.restAgent;
    }

    public void requestAndApplySharedConfiguration() {
        DistributionConfig config = this.system.getConfig();
        if (this.dm instanceof DistributionManager && !this.sqlfSystem && ((DistributionManager)this.dm).getDMType() != 11 && !this.isClient && Locator.getLocator() == null) {
            boolean useSharedConfiguration = config.getUseSharedConfiguration();
            if (useSharedConfiguration) {
                Map<InternalDistributedMember, Collection<String>> scl = this.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration();
                if (!scl.isEmpty()) {
                    String groupsString = config.getGroups();
                    ConfigurationResponse response = null;
                    List<String> locatorConnectionStrings = this.getSharedConfigLocatorConnectionStringList();
                    try {
                        response = ClusterConfigurationLoader.requestConfigurationFromLocators(ClusterConfigurationLoader.getGroups(groupsString), locatorConnectionStrings);
                        logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_RECEIVED_SHARED_CONFIGURATION_FROM_LOCATORS));
                        logger.info(response.describeConfig());
                        ClusterConfigurationLoader.deployJarsReceivedFromClusterConfiguration(this, response);
                        ClusterConfigurationLoader.applyClusterConfiguration(this, response, ClusterConfigurationLoader.getGroups(groupsString));
                    }
                    catch (ClusterConfigurationNotAvailableException e) {
                        throw new CacheRuntimeException(LocalizedStrings.GemFireCache_SHARED_CONFIGURATION_NOT_AVAILABLE.toLocalizedString(), e){
                            private static final long serialVersionUID = 1L;
                        };
                    }
                    catch (IOException e) {
                        throw new CacheRuntimeException(LocalizedStrings.GemFireCache_EXCEPTION_OCCURED_WHILE_DEPLOYING_JARS_FROM_SHARED_CONDFIGURATION.toLocalizedString(), e){
                            private static final long serialVersionUID = 1L;
                        };
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheRuntimeException(LocalizedStrings.GemFireCache_EXCEPTION_OCCURED_WHILE_DEPLOYING_JARS_FROM_SHARED_CONDFIGURATION.toLocalizedString(), e){
                            private static final long serialVersionUID = 1L;
                        };
                    }
                } else {
                    logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_NO_LOCATORS_FOUND_WITH_SHARED_CONFIGURATION));
                }
            } else {
                logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_NOT_USING_SHARED_CONFIGURATION));
            }
        }
    }

    public List<String> getSharedConfigLocatorConnectionStringList() {
        ArrayList<String> locatorConnectionStringList = new ArrayList<String>();
        Map<InternalDistributedMember, Collection<String>> scl = this.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration();
        if (!scl.isEmpty()) {
            Set<Map.Entry<InternalDistributedMember, Collection<String>>> locs = scl.entrySet();
            for (Map.Entry<InternalDistributedMember, Collection<String>> loc : locs) {
                Collection<String> locStrings = loc.getValue();
                Iterator<String> locStringIter = locStrings.iterator();
                while (locStringIter.hasNext()) {
                    locatorConnectionStringList.add(locStringIter.next());
                }
            }
        }
        return locatorConnectionStringList;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean hasPool() {
        return this.isClient || !this.getAllPools().isEmpty();
    }

    private Collection<Pool> getAllPools() {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        return pools;
    }

    @Override
    public Pool getDefaultPool() {
        return this.defaultPool;
    }

    private void setDefaultPool(Pool v) {
        this.defaultPool = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GemFireCacheImpl init() {
        if (instance != null) {
            Assert.assertTrue(instance == null, "Cache instance already in place: " + instance);
        }
        instance = this;
        pdxInstance = this;
        MinimumSystemRequirements.checkAndLog();
        for (CacheLifecycleListener listener : cacheLifecycleListeners) {
            listener.cacheCreated(this);
        }
        ClassPathLoader.setLatestToDefault();
        SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CREATE);
        this.resourceAdvisor.initializationGate();
        FunctionService.registerFunction(new FindRestEnabledServersFunction());
        this.jmxAdvisor.initializationGate();
        this.system.handleResourceEvent(ResourceEvent.CACHE_CREATE, this);
        boolean completedCacheXml = false;
        try {
            new JarDeployer(this.system.getConfig().getDeployWorkingDir()).loadPreviouslyDeployedJars();
            this.requestAndApplySharedConfiguration();
            this.initializeDeclarativeCache();
            completedCacheXml = true;
        }
        finally {
            if (!completedCacheXml) {
                try {
                    this.close();
                }
                catch (Throwable ignore) {}
            }
        }
        this.clientpf = null;
        this.startColocatedJmxManagerLocator();
        this.startMemcachedServer();
        this.startRestAgentServer(this);
        int time = Integer.getInteger("gemfire.CLIENT_FUNCTION_TIMEOUT", 0);
        clientFunctionTimeout = time >= 0 ? time : 0;
        return this;
    }

    private boolean isNotJmxManager() {
        return !this.system.getConfig().getJmxManagerStart();
    }

    private boolean isServerNode() {
        return this.system.getDistributedMember().getVmKind() != 11 && this.system.getDistributedMember().getVmKind() != 12 && !this.isClient();
    }

    private void startRestAgentServer(GemFireCacheImpl cache) {
        if (this.system.getConfig().getStartDevRestApi() && this.isNotJmxManager() && this.isServerNode()) {
            this.restAgent = new RestAgent(this.system.getConfig());
            this.restAgent.start(cache);
        } else {
            this.restAgent = null;
        }
    }

    private void startMemcachedServer() {
        int port = this.system.getConfig().getMemcachedPort();
        if (port != 0) {
            String protocol = this.system.getConfig().getMemcachedProtocol();
            assert (protocol != null);
            String bindAddress = this.system.getConfig().getMemcachedBindAddress();
            assert (bindAddress != null);
            if (bindAddress.equals("")) {
                logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_MEMCACHED_SERVER_ON_PORT_0_FOR_1_PROTOCOL, new Object[]{port, protocol}));
            } else {
                logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_MEMCACHED_SERVER_ON_BIND_ADDRESS_0_PORT_1_FOR_2_PROTOCOL, new Object[]{bindAddress, port, protocol}));
            }
            this.memcachedServer = new GemFireMemcachedServer(bindAddress, port, GemFireMemcachedServer.Protocol.valueOf(protocol.toUpperCase()));
            this.memcachedServer.start();
        }
    }

    public URL getCacheXmlURL() {
        File defaultFile;
        if (this.getMyId().getVmKind() == 11) {
            return null;
        }
        File xmlFile = testCacheXml;
        if (xmlFile == null) {
            xmlFile = this.system.getConfig().getCacheXmlFile();
        }
        if ("".equals(xmlFile.getName())) {
            return null;
        }
        URL url = null;
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            String resource = xmlFile.getPath();
            if ((resource = resource.replaceAll("\\\\", "/")).length() > 1 && resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            url = ClassPathLoader.getLatest().getResource(this.getClass(), resource);
        } else {
            try {
                url = xmlFile.toURL();
            }
            catch (IOException ex) {
                throw new CacheXmlException(LocalizedStrings.GemFireCache_COULD_NOT_CONVERT_XML_FILE_0_TO_AN_URL.toLocalizedString(xmlFile), ex);
            }
        }
        if (url == null && !xmlFile.equals(defaultFile = DistributionConfig.DEFAULT_CACHE_XML_FILE)) {
            if (!xmlFile.exists()) {
                throw new CacheXmlException(LocalizedStrings.GemFireCache_DECLARATIVE_CACHE_XML_FILERESOURCE_0_DOES_NOT_EXIST.toLocalizedString(xmlFile));
            }
            throw new CacheXmlException(LocalizedStrings.GemFireCache_DECLARATIVE_XML_FILE_0_IS_NOT_A_FILE.toLocalizedString(xmlFile));
        }
        return url;
    }

    private void initializeDeclarativeCache() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        block16: {
            URL url = this.getCacheXmlURL();
            String cacheXmlDescription = this.cacheConfig.getCacheXMLDescription();
            if (url == null && cacheXmlDescription == null) {
                if (this.isClient()) {
                    this.determineDefaultPool();
                    GemFireCacheImpl.initializeClientRegionShortcuts(this);
                } else {
                    GemFireCacheImpl.initializeRegionShortcuts(this);
                }
                this.initializePdxRegistry();
                this.readyDynamicRegionFactory();
                return;
            }
            try {
                InputStream stream = null;
                if (cacheXmlDescription != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("initializing cache with generated XML: {}", cacheXmlDescription);
                    }
                    stream = new StringBufferInputStream(cacheXmlDescription);
                } else {
                    stream = url.openStream();
                }
                this.loadCacheXml(stream);
                try {
                    stream.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (cacheXmlDescription == null) {
                    StringBuilder sb = new StringBuilder();
                    try {
                        String EOLN = System.getProperty("line.separator");
                        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                        String l = br.readLine();
                        while (l != null) {
                            if (!l.isEmpty()) {
                                sb.append(EOLN).append(l);
                            }
                            l = br.readLine();
                        }
                        br.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_CACHE_INITIALIZED_USING__0__1, new Object[]{url.toString(), sb.toString()}));
                    break block16;
                }
                logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_CACHE_INITIALIZED_USING__0__1, new Object[]{"generated description from old cache", cacheXmlDescription}));
            }
            catch (IOException ex) {
                throw new CacheXmlException(LocalizedStrings.GemFireCache_WHILE_OPENING_CACHE_XML_0_THE_FOLLOWING_ERROR_OCCURRED_1.toLocalizedString(url.toString(), ex));
            }
            catch (CacheXmlException ex) {
                CacheXmlException newEx = new CacheXmlException(LocalizedStrings.GemFireCache_WHILE_READING_CACHE_XML_0_1.toLocalizedString(url, ex.getMessage()));
                newEx.setStackTrace(ex.getStackTrace());
                newEx.initCause(ex.getCause());
                throw newEx;
            }
        }
    }

    public synchronized void initializePdxRegistry() {
        if (this.pdxRegistry == null) {
            this.pdxRegistry = this.getMyId().getVmKind() == 11 ? new TypeRegistry(this, true) : new TypeRegistry(this, false);
            this.pdxRegistry.initialize();
        }
    }

    public void readyDynamicRegionFactory() {
        try {
            ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).internalInit(this);
        }
        catch (CacheException ce) {
            throw new GemFireCacheException(LocalizedStrings.GemFireCache_DYNAMIC_REGION_INITIALIZATION_FAILED.toLocalizedString(), ce);
        }
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return new DiskStoreFactoryImpl(this, attrs);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public boolean forcedDisconnect() {
        return this.forcedDisconnect || this.system.forcedDisconnect();
    }

    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        CacheClosedException result = cause != null ? new CacheClosedException(reason, cause) : (this.disconnectCause != null ? new CacheClosedException(reason, this.disconnectCause) : new CacheClosedException(reason));
        return result;
    }

    public Throwable getDisconnectCause() {
        return this.disconnectCause;
    }

    public boolean keepDurableSubscriptionsAlive() {
        return this.keepAlive;
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        InternalDistributedSystem.loadEmergencyClasses();
        AcceptorImpl.loadEmergencyClasses();
        GatewayHubImpl.loadEmergencyClasses();
        PoolManagerImpl.loadEmergencyClasses();
    }

    public static void emergencyClose() {
        boolean DEBUG = false;
        GemFireCacheImpl inst = instance;
        if (inst == null) {
            return;
        }
        instance = null;
        pdxInstance = null;
        InternalDistributedSystem ids = inst.system;
        if (ids != null) {
            ids.emergencyClose();
        }
        inst.disconnectCause = SystemFailure.getFailure();
        inst.isClosing = true;
        for (BridgeServerImpl bs : inst.allBridgeServers) {
            AcceptorImpl ai = bs.getAcceptor();
            if (ai == null) continue;
            ai.emergencyClose();
        }
        PoolManagerImpl.emergencyClose();
        GatewayHubImpl[] snap = inst.allGatewayHubs;
        for (int i = 0; i < snap.length; ++i) {
            snap[i].emergencyClose();
        }
        inst.rootRegions.clear();
        inst.partitionedRegions.clear();
    }

    public boolean isCacheAtShutdownAll() {
        return this.isShutDownAll;
    }

    void shutdownSubTreeGracefully(Map<String, PartitionedRegion> prSubMap) {
        for (PartitionedRegion pr2 : prSubMap.values()) {
            this.shutDownOnePRGracefully(pr2);
        }
    }

    public synchronized void shutDownAll() {
        boolean testIGE = Boolean.getBoolean("TestInternalGemFireError");
        if (testIGE) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            throw assErr;
        }
        if (this.isCacheAtShutdownAll()) {
            return;
        }
        this.isShutDownAll = true;
        TreeMap<String, Map<String, PartitionedRegion>> prTrees = this.getPRTrees();
        if (prTrees.size() > 1 && shutdownAllPoolSize != 1) {
            ExecutorService es = this.getShutdownAllExecutorService(prTrees.size());
            for (final Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                es.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionTable.threadWantsSharedResources();
                        GemFireCacheImpl.this.shutdownSubTreeGracefully(prSubMap);
                    }
                });
            }
            es.shutdown();
            try {
                es.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.debug("Shutdown all interrupted while waiting for PRs to be shutdown gracefully.");
            }
        } else {
            for (Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                this.shutdownSubTreeGracefully(prSubMap);
            }
        }
        this.close("Shut down all members", null, false, true);
    }

    private ExecutorService getShutdownAllExecutorService(int size2) {
        final LoggingThreadGroup thrGrp = LoggingThreadGroup.createThreadGroup("ShutdownAllGroup", logger);
        ThreadFactory thrFactory = new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(thrGrp, r, "ShutdownAll-" + this.threadCount.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        ExecutorService es = Executors.newFixedThreadPool(shutdownAllPoolSize == -1 ? size2 : shutdownAllPoolSize, thrFactory);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownOnePRGracefully(PartitionedRegion pr2) {
        boolean acquiredLock = false;
        try {
            pr2.acquireDestroyLock();
            acquiredLock = true;
            PRHARedundancyProvider pRHARedundancyProvider = pr2.getRedundancyProvider();
            synchronized (pRHARedundancyProvider) {
                if (pr2.isDataStore() && pr2.getDataStore() != null && pr2.getDataPolicy() == DataPolicy.PERSISTENT_PARTITION) {
                    int numBuckets = pr2.getTotalNumberOfBuckets();
                    Map[] bucketMaps = new Map[numBuckets];
                    PartitionedRegionDataStore prds = pr2.getDataStore();
                    Set<Map.Entry<Integer, BucketRegion>> bucketEntries = prds.getAllLocalBuckets();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        BucketRegion br = e.getValue();
                        if (br == null || br.isDestroyed) continue;
                        br.getBucketAdvisor().tryLockIfPrimary();
                        bucketMaps[br.getId()] = br.getBucketAdvisor().adviseInitializedPersistentMembers();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: initialized persistent members for {}:{}", pr2.getName(), br.getId(), bucketMaps[br.getId()]);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: All buckets for PR {} are locked.", pr2.getName());
                    }
                    pr2.setShutDownAllStatus(1);
                    new UpdateAttributesProcessor(pr2).distribute(false);
                    pr2.getRegionAdvisor().waitForProfileStatus(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all bucketlock profiles received.", pr2.getName());
                    }
                    if (!pr2.getAttributes().isDiskSynchronous()) {
                        pr2.getDiskStore().forceFlush();
                        pr2.setShutDownAllStatus(2);
                        new UpdateAttributesProcessor(pr2).distribute(false);
                        pr2.getRegionAdvisor().waitForProfileStatus(2);
                        if (logger.isDebugEnabled()) {
                            logger.debug("shutDownAll: PR {}: all flush profiles received.", pr2.getName());
                        }
                    }
                    Set<InternalDistributedMember> membersToPersistOfflineEqual = pr2.getRegionAdvisor().adviseDataStore();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        Map<InternalDistributedMember, PersistentMemberID> persistMap;
                        BucketRegion br = e.getValue();
                        if (br == null || br.isDestroyed || (persistMap = this.getSubMapForLiveMembers(pr2, membersToPersistOfflineEqual, bucketMaps[br.getId()])) == null) continue;
                        br.getPersistenceAdvisor().persistMembersOfflineAndEqual(persistMap);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: pesisting bucket {}:{}", pr2.getName(), br.getId(), persistMap);
                    }
                    pr2.setShutDownAllStatus(3);
                    new UpdateAttributesProcessor(pr2).distribute(false);
                    pr2.getRegionAdvisor().waitForProfileStatus(3);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all offline_equal profiles received.", pr2.getName());
                    }
                }
                RegionEventImpl event = new RegionEventImpl((Region)pr2, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), true);
                try {
                    pr2.basicDestroyRegion(event, false, false, true);
                }
                catch (CacheWriterException e) {
                    throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
                }
                catch (TimeoutException e) {
                    throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
                }
            }
        }
        catch (CacheClosedException cce) {
            logger.debug("Encounter CacheClosedException when shutDownAll is closing PR: {}:{}", pr2.getFullPath(), cce.getMessage());
        }
        catch (CancelException ce) {
            logger.debug("Encounter CancelException when shutDownAll is closing PR: {}:{}", pr2.getFullPath(), ce.getMessage());
        }
        catch (RegionDestroyedException rde) {
            logger.debug("Encounter CacheDestroyedException when shutDownAll is closing PR: {}:{}", pr2.getFullPath(), rde.getMessage());
        }
        finally {
            if (acquiredLock) {
                pr2.releaseDestroyLock();
            }
        }
    }

    private Map<InternalDistributedMember, PersistentMemberID> getSubMapForLiveMembers(PartitionedRegion pr2, Set<InternalDistributedMember> membersToPersistOfflineEqual, Map<InternalDistributedMember, PersistentMemberID> bucketMap) {
        if (bucketMap == null) {
            return null;
        }
        HashMap<InternalDistributedMember, PersistentMemberID> persistMap = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (InternalDistributedMember idm : membersToPersistOfflineEqual) {
            if (!bucketMap.containsKey(idm)) continue;
            persistMap.put(idm, bucketMap.get(idm));
        }
        return persistMap;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean keepalive) {
        this.close("Normal disconnect", null, keepalive, false);
    }

    public void close(String reason, Throwable optionalCause) {
        this.close(reason, optionalCause, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DistributedLockService getPartitionedRegionLockService() {
        Object object = this.prLockServiceLock;
        synchronized (object) {
            block6: {
                this.stopper.checkCancelInProgress(null);
                if (this.prLockService == null) {
                    try {
                        this.prLockService = DLockService.create("__PRLS", this.getDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.prLockService = DistributedLockService.getServiceNamed("__PRLS");
                        if (this.prLockService != null) break block6;
                        throw e;
                    }
                }
            }
            return this.prLockService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLockService getGatewaySenderLockService() {
        if (this.gatewayLockService == null) {
            Object object = this.gatewayLockServiceLock;
            synchronized (object) {
                block7: {
                    this.stopper.checkCancelInProgress(null);
                    if (this.gatewayLockService == null) {
                        try {
                            this.gatewayLockService = DLockService.create("gatewayEventIdIndexMetaData_lockService", this.getDistributedSystem(), true, true, true);
                        }
                        catch (IllegalArgumentException e) {
                            this.gatewayLockService = DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService");
                            if (this.gatewayLockService != null) break block7;
                            throw e;
                        }
                    }
                }
            }
        }
        return this.gatewayLockService;
    }

    private void destroyPartitionedRegionLockService() {
        try {
            DistributedLockService.destroy("__PRLS");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void destroyGatewaySenderLockService() {
        if (DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService") != null) {
            try {
                DistributedLockService.destroy("gatewayEventIdIndexMetaData_lockService");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapEvictor getHeapEvictor() {
        Object object = this.heapEvictorLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.heapEvictor == null) {
                this.heapEvictor = new HeapEvictor(this);
            }
            return this.heapEvictor;
        }
    }

    public PersistentMemberManager getPersistentMemberManager() {
        return this.persistentMemberManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMetadataService getClientMetadataService() {
        Object object = this.clientMetaDatServiceLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.clientMetadatService == null) {
                this.clientMetadatService = new ClientMetadataService(this);
            }
            return this.clientMetadatService;
        }
    }

    public void close(String reason, Throwable systemFailureCause, boolean keepalive) {
        this.close(reason, systemFailureCause, keepalive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, Throwable systemFailureCause, boolean keepalive, boolean keepDS) {
        if (this.isClosed()) {
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            if (this.isClosed()) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            this.system.handleResourceEvent(ResourceEvent.CACHE_REMOVE, this);
            if (this.listener != null) {
                this.system.removeResourceListener(this.listener);
                this.listener = null;
            }
            if (systemFailureCause != null) {
                this.forcedDisconnect = systemFailureCause instanceof ForcedDisconnectException;
                this.disconnectCause = this.forcedDisconnect ? new ForcedDisconnectException(reason) : systemFailureCause;
            }
            this.isClosing = true;
            logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_0_NOW_CLOSING, this));
            if (instance == this) {
                instance = null;
            }
            if (systemFailureCause == null) {
                PartitionedRegion.clearPRIdMap();
            }
            TXStateProxy tx = null;
            try {
                this.keepAlive = keepalive;
                PoolManagerImpl.setKeepAlive(keepalive);
                if (this.txMgr != null) {
                    tx = this.txMgr.internalSuspend();
                }
                this.resourceManager.close();
                try {
                    this.resourceAdvisor.close();
                }
                catch (CancelException e) {
                    // empty catch block
                }
                try {
                    this.jmxAdvisor.close();
                }
                catch (CancelException e) {
                    // empty catch block
                }
                try {
                    GatewaySenderAdvisor advisor = null;
                    for (GatewaySender sender : this.getAllGatewaySenders()) {
                        ((AbstractGatewaySender)sender).stop();
                        advisor = ((AbstractGatewaySender)sender).getSenderAdvisor();
                        if (advisor == null) continue;
                        if (isDebugEnabled) {
                            logger.debug("Stopping the GatewaySender advisor");
                        }
                        advisor.close();
                    }
                }
                catch (CancelException ce) {
                    // empty catch block
                }
                this.destroyGatewaySenderLockService();
                if (ASYNC_EVENT_LISTENERS) {
                    if (isDebugEnabled) {
                        logger.debug("{}: stopping event thread pool...", this);
                    }
                    this.eventThreadPool.shutdown();
                }
                try {
                    HeapEvictor he;
                    ClientMetadataService cms;
                    block75: {
                        block74: {
                            this.stopServers();
                            this.stopMemcachedServer();
                            if (this.partitionedRegions != null) {
                                if (isDebugEnabled) {
                                    logger.debug("{}: clearing partitioned regions...", this);
                                }
                                HashSet<PartitionedRegion> ce = this.partitionedRegions;
                                synchronized (ce) {
                                    int prSize = -this.partitionedRegions.size();
                                    this.partitionedRegions.clear();
                                    this.getCachePerfStats().incPartitionedRegions(prSize);
                                }
                            }
                            this.prepareDiskStoresForClose();
                            if (pdxInstance == this) {
                                pdxInstance = null;
                            }
                            ArrayList rootRegionValues = null;
                            HashMap prSize = this.rootRegions;
                            synchronized (prSize) {
                                rootRegionValues = new ArrayList(this.rootRegions.values());
                            }
                            Operation op = this.forcedDisconnect ? Operation.FORCED_DISCONNECT : (this.isReconnecting() ? Operation.CACHE_RECONNECT : Operation.CACHE_CLOSE);
                            LocalRegion prRoot = null;
                            for (LocalRegion lr : rootRegionValues) {
                                if (isDebugEnabled) {
                                    logger.debug("{}: processing region {}", this, lr.getFullPath());
                                }
                                if ("__PR".equals(lr.getName())) {
                                    prRoot = lr;
                                    continue;
                                }
                                if (lr.getName().contains("_PARALLEL_GATEWAY_SENDER_QUEUE")) continue;
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing region {}...", this, lr.getFullPath());
                                }
                                try {
                                    lr.handleCacheClose(op);
                                }
                                catch (Exception e) {
                                    if (!isDebugEnabled && this.forcedDisconnect) continue;
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.GemFireCache_0_ERROR_CLOSING_REGION_1, new Object[]{this, lr.getFullPath()}), (Throwable)e);
                                }
                            }
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: finishing partitioned region close...", this);
                                }
                                PartitionedRegion.afterRegionsClosedByCacheClose(this);
                                if (prRoot != null) {
                                    prRoot.handleCacheClose(op);
                                }
                            }
                            catch (CancelException e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.GemFireCache_0_ERROR_IN_LAST_STAGE_OF_PARTITIONEDREGION_CACHE_CLOSE, this), (Throwable)e);
                            }
                            this.destroyPartitionedRegionLockService();
                            this.closeDiskStores();
                            this.diskMonitor.close();
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing CQ service...", this);
                                }
                                CqService.closeCqService();
                            }
                            catch (Exception ex) {
                                logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_FAILED_TO_GET_THE_CQSERVICE_TO_CLOSE_DURING_CACHE_CLOSE_1));
                            }
                            PoolManager.close(keepalive);
                            if (isDebugEnabled) {
                                logger.debug("{}: closing reliable message queue...", this);
                            }
                            try {
                                this.getReliableMessageQueueFactory().close(true);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled) break block74;
                                logger.debug("Ignored cancellation while closing reliable message queue", (Throwable)e);
                            }
                        }
                        if (isDebugEnabled) {
                            logger.debug("{}: notifying admins of close...", this);
                        }
                        try {
                            SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CLOSE);
                        }
                        catch (CancelException e) {
                            if (!logger.isDebugEnabled()) break block75;
                            logger.debug("Ignored cancellation while notifying admins");
                        }
                    }
                    if (isDebugEnabled) {
                        logger.debug("{}: stopping destroyed entries processor...", this);
                    }
                    this.tombstoneService.stop();
                    DM dm = null;
                    try {
                        dm = this.system.getDistributionManager();
                        dm.removeMembershipListener(this.txMgr);
                    }
                    catch (CancelException e) {
                        // empty catch block
                    }
                    if (dm != null) {
                        if (isDebugEnabled) {
                            logger.debug("{}: sending CloseCache to peers...", this);
                        }
                        Set otherMembers = dm.getOtherDistributionManagerIds();
                        ReplyProcessor21 processor = new ReplyProcessor21(this.system, (Collection)otherMembers);
                        CloseCacheMessage msg = new CloseCacheMessage();
                        msg.setMulticast(this.system.getConfig().getMcastPort() != 0);
                        msg.setRecipients(otherMembers);
                        msg.setProcessorId(processor.getProcessorId());
                        dm.putOutgoing(msg);
                        try {
                            processor.waitForReplies();
                        }
                        catch (InterruptedException ex) {
                        }
                        catch (ReplyException ex) {
                            // empty catch block
                        }
                    }
                    if ((cms = this.clientMetadatService) != null) {
                        cms.close();
                    }
                    if ((he = this.heapEvictor) != null) {
                        he.close();
                    }
                }
                catch (CancelException e) {
                    this.closeDiskStores();
                }
                try {
                    CqService.closeCqService();
                }
                catch (Exception ex) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_FAILED_TO_GET_THE_CQSERVICE_TO_CLOSE_DURING_CACHE_CLOSE_2));
                }
                this.cachePerfStats.close();
                TXLockService.destroyServices();
                EventTracker.stopTrackerServices(this);
                Object ex = this.ccpTimerMutex;
                synchronized (ex) {
                    if (this.ccpTimer != null) {
                        this.ccpTimer.cancel();
                    }
                }
                this.expirationScheduler.cancel();
                if (this.queryMonitor != null) {
                    this.queryMonitor.stopMonitoring();
                }
                this.stopDiskStoreTaskPool();
            }
            finally {
                if (this.txMgr != null) {
                    this.txMgr.close();
                }
                ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).close();
                if (this.txMgr != null) {
                    this.txMgr.resume(tx);
                }
                TXCommitMessage.getTracker().clearForCacheClose();
            }
            TransactionManagerImpl.refresh();
            if (!keepDS && !this.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE) {
                this.system.disconnect();
            }
            TypeRegistry.close();
            TypeRegistry.setPdxSerializer(null);
            for (CacheLifecycleListener listener : cacheLifecycleListeners) {
                listener.cacheClosed(this);
            }
            this.stopRestAgentServer();
            SequenceLoggerImpl.signalCacheClose();
            SystemFailure.signalCacheClose();
            SocketIOWithTimeout.stopSelectorCleanUpThread();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isReconnecting() {
        return this.system.isReconnecting();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        return this.system.waitUntilReconnected(time, units);
    }

    @Override
    public void stopReconnecting() {
        this.system.stopReconnecting();
    }

    @Override
    public Cache getReconnectedCache() {
        GemFireCacheImpl c = GemFireCacheImpl.getInstance();
        if (c == this) {
            c = null;
        }
        return c;
    }

    private void stopMemcachedServer() {
        if (this.memcachedServer != null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_MEMCACHED_SERVER_ON_PORT_0_IS_SHUTTING_DOWN, new Object[]{this.system.getConfig().getMemcachedPort()}));
            this.memcachedServer.shutdown();
        }
    }

    private void stopRestAgentServer() {
        if (this.restAgent != null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_REST_SERVER_ON_PORT_0_IS_SHUTTING_DOWN, new Object[]{this.system.getConfig().getHttpServicePort()}));
            this.restAgent.stop();
        }
    }

    private void prepareDiskStoresForClose() {
        String pdxDSName = TypeRegistry.getPdxDiskStoreName(this);
        DiskStoreImpl pdxdsi = null;
        for (DiskStoreImpl dsi : this.diskStores.values()) {
            if (dsi.getName().equals(pdxDSName)) {
                pdxdsi = dsi;
                continue;
            }
            dsi.prepareForClose();
        }
        if (pdxdsi != null) {
            pdxdsi.prepareForClose();
        }
    }

    private void createDiskStoreTaskPool() {
        int MAXT = DiskStoreImpl.MAX_CONCURRENT_COMPACTIONS;
        LoggingThreadGroup compactThreadGroup = LoggingThreadGroup.createThreadGroup("Oplog Compactor Thread Group", logger);
        ThreadFactory compactThreadFactory = GemfireCacheHelper.CreateThreadFactory(compactThreadGroup, "Idle OplogCompactor");
        this.diskStoreTaskPool = new ThreadPoolExecutor(MAXT, MAXT, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), compactThreadFactory);
    }

    public void addDiskStore(DiskStoreImpl dsi) {
        this.diskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.getDiskStoreMonitor().addDiskStore(dsi);
        }
    }

    public void removeDiskStore(DiskStoreImpl dsi) {
        this.diskStores.remove(dsi.getName());
        this.regionOwnedDiskStores.remove(dsi.getName());
        if (!dsi.getOwnedByRegion()) {
            this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, dsi);
        }
    }

    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        this.regionOwnedDiskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.getDiskStoreMonitor().addDiskStore(dsi);
        }
    }

    public void closeDiskStores() {
        Iterator it = this.diskStores.values().iterator();
        while (it.hasNext()) {
            try {
                DiskStoreImpl dsi = (DiskStoreImpl)it.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("closing {}", dsi);
                }
                dsi.close();
                this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, dsi);
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.Disk_Store_Exception_During_Cache_Close), (Throwable)e);
            }
            it.remove();
        }
    }

    public static void setDefaultDiskStoreName(String dsName) {
        DEFAULT_DS_NAME = dsName;
    }

    public static void unsetDefaultDiskStoreName() {
        DEFAULT_DS_NAME = "DEFAULT";
    }

    public static String getDefaultDiskStoreName() {
        return DEFAULT_DS_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        DiskStoreImpl result = (DiskStoreImpl)this.findDiskStore(null);
        if (result == null) {
            GemFireCacheImpl gemFireCacheImpl = this;
            synchronized (gemFireCacheImpl) {
                result = (DiskStoreImpl)this.findDiskStore(null);
                if (result == null) {
                    result = (DiskStoreImpl)this.createDiskStoreFactory().create(DEFAULT_DS_NAME);
                }
            }
        }
        return result;
    }

    @Override
    public DiskStore findDiskStore(String name) {
        if (name == null) {
            name = DEFAULT_DS_NAME;
        }
        return (DiskStore)this.diskStores.get(name);
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStores() {
        return Collections.unmodifiableCollection(this.diskStores.values());
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStoresIncludingDefault() {
        return Collections.unmodifiableCollection(this.listDiskStores());
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStoresIncludingRegionOwned() {
        HashSet<DiskStoreImpl> allDiskStores = new HashSet<DiskStoreImpl>();
        allDiskStores.addAll(this.diskStores.values());
        allDiskStores.addAll(this.regionOwnedDiskStores.values());
        return allDiskStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDiskStoreTask(DiskStoreTask r) {
        AtomicBoolean atomicBoolean = this.diskStoreTaskSync;
        synchronized (atomicBoolean) {
            block7: {
                if (!this.diskStoreTaskSync.get()) {
                    if (this.diskStoreTaskPool == null) {
                        this.createDiskStoreTaskPool();
                    }
                    try {
                        this.diskStoreTaskPool.execute(r);
                        return true;
                    }
                    catch (RejectedExecutionException ex) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("Ignored compact schedule during shutdown", (Throwable)ex);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDiskStoreTaskPool() {
        AtomicBoolean atomicBoolean = this.diskStoreTaskSync;
        synchronized (atomicBoolean) {
            this.diskStoreTaskSync.set(true);
            if (this.diskStoreTaskPool != null) {
                List<Runnable> l = this.diskStoreTaskPool.shutdownNow();
                for (Runnable runnable : l) {
                    if (!(l instanceof DiskStoreTask)) continue;
                    ((DiskStoreTask)((Object)l)).taskCancelled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopGatewayHubs(boolean byShutdownAll) {
        int cnt = 0;
        this.closingGatewayHubsByShutdownAll = byShutdownAll;
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            for (int i = 0; i < this.allGatewayHubs.length; ++i) {
                GatewayHubImpl hub = this.allGatewayHubs[i];
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: stopping gateway hub {}", this, hub);
                }
                try {
                    hub.stop();
                    ++cnt;
                    continue;
                }
                catch (CancelException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignored cache closure while closing hub {}", hub, e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: finished stopping {} gateway hub(s), total is {}", this, cnt, this.allGatewayHubs.length);
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopGatewaySenders(boolean byShutdownAll) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        int cnt = 0;
        this.closingGatewaySendersByShutdownAll = byShutdownAll;
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            GatewaySenderAdvisor advisor = null;
            for (GatewaySender sender : this.allGatewaySenders) {
                if (isDebugEnabled) {
                    logger.debug("{}: stopping gateway sender {}", this, sender);
                }
                try {
                    sender.stop();
                    advisor = ((AbstractGatewaySender)sender).getSenderAdvisor();
                    if (advisor != null) {
                        if (isDebugEnabled) {
                            logger.debug("Stopping the GatewaySender advisor");
                        }
                        advisor.close();
                    }
                    ++cnt;
                }
                catch (CancelException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("Ignored cache closure while closing sender {}", sender, e);
                }
            }
        }
        this.destroyGatewaySenderLockService();
        if (isDebugEnabled) {
            logger.debug("{}: finished stopping {} gateway sender(s), total is {}", this, cnt, this.allGatewaySenders.size());
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopGatewayReceivers(boolean byShutdownAll) {
        int cnt = 0;
        this.closingGatewayReceiversByShutdownAll = byShutdownAll;
        Object object = this.allGatewayReceiversLock;
        synchronized (object) {
            for (GatewayReceiver receiver : this.allGatewayReceivers) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: stopping gateway receiver {}", this, receiver);
                }
                try {
                    receiver.stop();
                    ++cnt;
                }
                catch (CancelException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignored cache closure while closing receiver {}", receiver, e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: finished stopping {} gateway receiver(s), total is {}", this, cnt, this.allGatewayReceivers.size());
        }
        return cnt;
    }

    void stopServers() {
        block13: {
            boolean isDebugEnabled;
            block12: {
                isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("{}: stopping bridge servers...", this);
                }
                for (BridgeServerImpl bridge : this.allBridgeServers) {
                    block11: {
                        if (isDebugEnabled) {
                            logger.debug("stopping bridge {}", bridge);
                        }
                        try {
                            bridge.stop();
                        }
                        catch (CancelException e) {
                            if (!isDebugEnabled) break block11;
                            logger.debug("Ignored cache closure while closing bridge {}", bridge, e);
                        }
                    }
                    this.allBridgeServers.remove(bridge);
                }
                this.stopGatewayHubs(false);
                if (isDebugEnabled) {
                    logger.debug("{}: stopping HA services...", this);
                }
                try {
                    HARegionQueue.stopHAServices();
                }
                catch (CancelException e) {
                    if (!isDebugEnabled) break block12;
                    logger.debug("Ignored cache closure while closing HA services", (Throwable)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("{}: stopping client health monitor...", this);
            }
            try {
                ClientHealthMonitor.shutdownInstance();
            }
            catch (CancelException e) {
                if (!isDebugEnabled) break block13;
                logger.debug("Ignored cache closure while closing client health monitor", (Throwable)e);
            }
        }
        ClientProxyMembershipID.resetUniqueIdCounter();
    }

    @Override
    public final InternalDistributedSystem getDistributedSystem() {
        return this.system;
    }

    @Override
    public InternalDistributedMember getMyId() {
        return this.system.getDistributedMember();
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.unmodifiableSet(this.dm.getOtherNormalDistributionManagerIds());
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return this.dm.getAdminMemberSet();
    }

    @Override
    public Set<DistributedMember> getMembers(Region r) {
        if (r instanceof DistributedRegion) {
            DistributedRegion d = (DistributedRegion)r;
            return d.getDistributionAdvisor().adviseCacheOp();
        }
        if (r instanceof PartitionedRegion) {
            PartitionedRegion p = (PartitionedRegion)r;
            return p.getRegionAdvisor().adviseAllPRNodes();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        Map<String, Pool> pools = PoolManager.getAll();
        HashSet<InetSocketAddress> result = null;
        for (Pool p : pools.values()) {
            PoolImpl pi = (PoolImpl)p;
            Iterator<ServerLocation> i$ = pi.getCurrentServers().iterator();
            while (i$.hasNext()) {
                ServerLocation o;
                ServerLocation sl = o = i$.next();
                if (result == null) {
                    result = new HashSet<InetSocketAddress>();
                }
                result.add(new InetSocketAddress(sl.getHostName(), sl.getPort()));
            }
        }
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    @Override
    public LogWriter getLogger() {
        return this.system.getLogWriter();
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.system.getSecurityLogWriter();
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.system.getInternalLogWriter();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.system.getSecurityInternalLogWriter();
    }

    public InternalLogWriter getInternalLogWriter() {
        return this.system.getInternalLogWriter();
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        return this.system.getSecurityInternalLogWriter();
    }

    protected EventTracker.ExpiryTask getEventTrackerTask() {
        return this.recordedEventSweeper;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    @Override
    public String getName() {
        return this.system.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Properties> getDeclarableProperties(String className) {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> entry : this.declarablePropertiesMap.entrySet()) {
                if (!entry.getKey().getClass().getName().equals(className)) continue;
                propertiesList.add(entry.getValue());
            }
        }
        return propertiesList;
    }

    public Properties getDeclarableProperties(Declarable declarable) {
        return this.declarablePropertiesMap.get(declarable);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getUpTime() {
        return (int)((System.currentTimeMillis() - this.creationDate.getTime()) / 1000L);
    }

    public long cacheTimeMillis() {
        if (this.system != null) {
            return this.system.getClock().cacheTimeMillis();
        }
        return System.currentTimeMillis();
    }

    public Region createVMRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, attrs);
    }

    private PoolFactory createDefaultPF() {
        PoolFactory defpf = PoolManager.createFactory();
        try {
            String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
            defpf.addServer(localHostName, 40404);
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Could not determine local host name");
        }
        return defpf;
    }

    public void determineDefaultPool() {
        Pool pool;
        block11: {
            block9: {
                Map<String, Pool> pools;
                block12: {
                    block10: {
                        if (!this.isClient()) {
                            throw new UnsupportedOperationException();
                        }
                        pool = null;
                        if (this.clientpf != null) break block9;
                        pools = PoolManager.getAll();
                        if (!pools.isEmpty()) break block10;
                        this.clientpf = this.createDefaultPF();
                        break block11;
                    }
                    if (pools.size() != 1) break block12;
                    pool = pools.values().iterator().next();
                    break block11;
                }
                if (pool != null) break block11;
                PoolFactoryImpl pfi = (PoolFactoryImpl)this.createDefaultPF();
                for (Pool p : pools.values()) {
                    if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                    pool = p;
                    break;
                }
                if (pool == null) {
                    this.setDefaultPool(null);
                    return;
                }
                break block11;
            }
            PoolFactoryImpl pfi = (PoolFactoryImpl)this.clientpf;
            if (pfi.getPoolAttributes().locators.isEmpty() && pfi.getPoolAttributes().servers.isEmpty()) {
                try {
                    String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
                    pfi.addServer(localHostName, 40404);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalStateException("Could not determine local host name");
                }
            }
            Map<String, Pool> pools = PoolManager.getAll();
            for (Pool p : pools.values()) {
                if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                pool = p;
                break;
            }
        }
        if (pool == null) {
            String poolName = "DEFAULT";
            int count = 1;
            Map<String, Pool> pools = PoolManager.getAll();
            while (pools.containsKey(poolName)) {
                poolName = "DEFAULT" + count;
                ++count;
            }
            pool = this.clientpf.create(poolName);
        }
        this.setDefaultPool(pool);
    }

    public Pool determineDefaultPool(PoolFactory pf) {
        Pool pool = null;
        if (pf == null) {
            Map<String, Pool> pools = PoolManager.getAll();
            if (pools.isEmpty()) {
                throw new IllegalStateException("Since a cache already existed a pool should also exist.");
            }
            if (pools.size() == 1) {
                pool = pools.values().iterator().next();
                if (this.getDefaultPool() != pool) {
                    throw new IllegalStateException("Existing cache's default pool was not the same as the only existing pool");
                }
            } else {
                pool = this.getDefaultPool();
                if (pool == null) {
                    PoolFactoryImpl pfi = (PoolFactoryImpl)this.createDefaultPF();
                    for (Pool p : pools.values()) {
                        if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                        pool = p;
                        break;
                    }
                    if (pool == null) {
                        return null;
                    }
                }
            }
        } else {
            PoolImpl defPool;
            PoolFactoryImpl pfi = (PoolFactoryImpl)pf;
            if (pfi.getPoolAttributes().locators.isEmpty() && pfi.getPoolAttributes().servers.isEmpty()) {
                try {
                    String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
                    pfi.addServer(localHostName, 40404);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalStateException("Could not determine local host name");
                }
            }
            if ((defPool = (PoolImpl)this.getDefaultPool()) != null && defPool.isCompatible(pfi.getPoolAttributes())) {
                pool = defPool;
            } else {
                throw new IllegalStateException("Existing cache's default pool was not compatible");
            }
        }
        return pool;
    }

    public Region createRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return this.basicCreateRegion(name, attrs);
    }

    public Region basicCreateRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        try {
            InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null);
            if (attrs instanceof UserSpecifiedRegionAttributes) {
                ira.setIndexes(((UserSpecifiedRegionAttributes)attrs).getIndexes());
            }
            return this.createVMRegion(name, attrs, ira);
        }
        catch (IOException e) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            assErr.initCause(e);
            throw assErr;
        }
        catch (ClassNotFoundException e) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            assErr.initCause(e);
            throw assErr;
        }
    }

    /*
     * Exception decompiling
     */
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Region getRegion(String path) {
        return this.getRegion(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LocalRegion> getAllRegions() {
        HashSet<LocalRegion> result = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (Object r : this.rootRegions.values()) {
                if (r instanceof PartitionedRegion) {
                    PartitionedRegion p = (PartitionedRegion)r;
                    PartitionedRegionDataStore prds = p.getDataStore();
                    if (prds == null) continue;
                    Set<Map.Entry<Integer, BucketRegion>> bucketEntries = p.getDataStore().getAllLocalBuckets();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        result.add(e.getValue());
                    }
                    continue;
                }
                if (!(r instanceof LocalRegion)) continue;
                LocalRegion l = (LocalRegion)r;
                result.add(l);
                result.addAll(l.basicSubregions(true));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LocalRegion> getApplicationRegions() {
        HashSet<LocalRegion> result = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (Object r : this.rootRegions.values()) {
                LocalRegion rgn = (LocalRegion)r;
                if (rgn.isSecret() || rgn.isUsedForMetaRegion() || rgn instanceof HARegion || rgn.isUsedForPartitionedRegionAdmin() || rgn.isInternalRegion()) continue;
                result.add(rgn);
                result.addAll(rgn.basicSubregions(true));
            }
        }
        return result;
    }

    void setRegionByPath(String path, LocalRegion r) {
        if (r == null) {
            this.pathToRegion.remove(path);
        } else {
            this.pathToRegion.put(path, r);
        }
    }

    private static void validatePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_NULL.toLocalizedString());
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_EMPTY.toLocalizedString());
        }
        if (path.equals("/")) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_0.toLocalizedString("/"));
        }
    }

    public LocalRegion getRegionByPath(String path) {
        GemFireCacheImpl.validatePath(path);
        LocalRegion result = this.getReinitializingRegion(path);
        if (result != null) {
            return result;
        }
        return (LocalRegion)this.pathToRegion.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LocalRegion getRegionByPathForProcessing(String path) {
        LocalRegion result = this.getRegionByPath(path);
        if (result != null) return result;
        this.stopper.checkCancelInProgress(null);
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            String[] pathParts = GemFireCacheImpl.parsePath(path);
            HashMap hashMap = this.rootRegions;
            // MONITORENTER : hashMap
            LocalRegion root = (LocalRegion)this.rootRegions.get(pathParts[0]);
            if (root == null) {
                LocalRegion localRegion = null;
                // MONITOREXIT : hashMap
                return localRegion;
            }
            // MONITOREXIT : hashMap
            if (logger.isDebugEnabled()) {
                logger.debug("GemFireCache.getRegion, calling getSubregion on root({}): {}", pathParts[0], pathParts[1]);
            }
            result = (LocalRegion)root.getSubregion(pathParts[1], true);
            return result;
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String path, boolean returnDestroyedRegion) {
        LocalRegion root;
        this.stopper.checkCancelInProgress(null);
        LocalRegion result = this.getRegionByPath(path);
        if (result != null) {
            result.waitOnInitialization();
            if (!returnDestroyedRegion && result.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            return result;
        }
        String[] pathParts = GemFireCacheImpl.parsePath(path);
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            root = (LocalRegion)this.rootRegions.get(pathParts[0]);
            if (root == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GemFireCache.getRegion, no region found for {}", pathParts[0]);
                }
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            if (!returnDestroyedRegion && root.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("GemFireCache.getRegion, calling getSubregion on root({}): {}", pathParts[0], pathParts[1]);
        }
        return root.getSubregion(pathParts[1], returnDestroyedRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isGlobalRegionInitializing(String fullPath) {
        this.stopper.checkCancelInProgress(null);
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            boolean bl = this.isGlobalRegionInitializing((LocalRegion)this.getRegion(fullPath));
            return bl;
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    boolean isGlobalRegionInitializing(LocalRegion region) {
        boolean result;
        boolean bl = result = region != null && region.scope.isGlobal() && !region.isInitialized();
        if (result && logger.isDebugEnabled()) {
            logger.debug("GemFireCache.isGlobalRegionInitializing ({})", region.getFullPath());
        }
        return result;
    }

    public Set rootRegions() {
        return this.rootRegions(false);
    }

    public final Set rootRegions(boolean includePRAdminRegions) {
        return this.rootRegions(includePRAdminRegions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set rootRegions(boolean includePRAdminRegions, boolean waitForInit) {
        this.stopper.checkCancelInProgress(null);
        HashSet<LocalRegion> regions = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (LocalRegion r : this.rootRegions.values()) {
                if (r.isSecret() || r.isUsedForMetaRegion() || r instanceof HARegion || !includePRAdminRegions && (r.isUsedForPartitionedRegionAdmin() || r.isUsedForPartitionedRegionBucket())) continue;
                regions.add(r);
            }
        }
        if (waitForInit) {
            Iterator r = regions.iterator();
            while (r.hasNext()) {
                LocalRegion lr = (LocalRegion)r.next();
                if (lr.checkForInitialization()) continue;
                r.remove();
            }
        }
        return Collections.unmodifiableSet(regions);
    }

    public void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        try {
            if (this.isClosed()) {
                return;
            }
            for (LocalRegion lr : this.rootRegions(false, false)) {
                lr.cleanupForClient(ccn, client);
            }
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosing;
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.lockTimeout = seconds;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.lockLease = seconds;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.searchTimeout = seconds;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        if (seconds < 0) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_THE_MESSAGESYNCINTERVAL_PROPERTY_FOR_CACHE_CANNOT_BE_NEGATIVE.toLocalizedString());
        }
        HARegionQueue.setMessageSyncInterval(seconds);
    }

    LocalRegion getReinitializingRegion(String fullPath) {
        Future future = (Future)this.reinitializingRegions.get(fullPath);
        if (future == null) {
            return null;
        }
        try {
            LocalRegion region = (LocalRegion)future.get();
            region.waitOnInitialization();
            if (logger.isDebugEnabled()) {
                logger.debug("Returning manifested future for: {}", fullPath);
            }
            return region;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new Error(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString(), e);
        }
        catch (CancellationException e) {
            logger.debug("future cancelled, returning null");
            return null;
        }
    }

    void regionReinitializing(String fullPath) {
        FutureResult old = this.reinitializingRegions.putIfAbsent(fullPath, new FutureResult(this.stopper));
        if (old != null) {
            throw new IllegalStateException(LocalizedStrings.GemFireCache_FOUND_AN_EXISTING_REINITALIZING_REGION_NAMED_0.toLocalizedString(fullPath));
        }
    }

    void regionReinitialized(Region region) {
        String regionName = region.getFullPath();
        FutureResult future = (FutureResult)this.reinitializingRegions.get(regionName);
        if (future == null) {
            throw new IllegalStateException(LocalizedStrings.GemFireCache_COULD_NOT_FIND_A_REINITIALIZING_REGION_NAMED_0.toLocalizedString(regionName));
        }
        future.set(region);
        this.unregisterReinitializingRegion(regionName);
    }

    void unregisterReinitializingRegion(String fullPath) {
        this.reinitializingRegions.remove(fullPath);
    }

    final boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    @Override
    public final boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeRoot(LocalRegion rootRgn) {
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            String rgnName = rootRgn.getName();
            LocalRegion found = (LocalRegion)this.rootRegions.get(rgnName);
            if (found == rootRgn) {
                LocalRegion previous = (LocalRegion)this.rootRegions.remove(rgnName);
                Assert.assertTrue(previous == rootRgn);
                return true;
            }
            return false;
        }
    }

    static String[] parsePath(String p_path) {
        String path = p_path;
        GemFireCacheImpl.validatePath(path);
        String[] result = new String[2];
        result[1] = "";
        int slashIndex = path.indexOf(47);
        if (slashIndex == 0) {
            path = path.substring(1);
            slashIndex = path.indexOf(47);
        }
        result[0] = path;
        if (slashIndex > 0) {
            result[0] = path.substring(0, slashIndex);
            result[1] = path.substring(slashIndex + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCacheLifecycleListener(CacheLifecycleListener l) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            cacheLifecycleListeners.add(l);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCacheLifecycleListener(CacheLifecycleListener l) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cacheLifecycleListeners.remove(l);
        }
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.txMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemTimer getCCPTimer() {
        Object object = this.ccpTimerMutex;
        synchronized (object) {
            if (this.ccpTimer != null) {
                return this.ccpTimer;
            }
            this.ccpTimer = new SystemTimer(this.getDistributedSystem(), true);
            if (this.isClosing) {
                this.ccpTimer.cancel();
            }
            return this.ccpTimer;
        }
    }

    public ExpirationScheduler getExpirationScheduler() {
        return this.expirationScheduler;
    }

    TXManagerImpl getTXMgr() {
        return this.txMgr;
    }

    Executor getEventThreadPool() {
        Assert.assertTrue(this.eventThreadPool != null);
        return this.eventThreadPool;
    }

    @Override
    public BridgeServer addBridgeServer() {
        return (BridgeServer)((Object)this.addCacheServer());
    }

    @Override
    public CacheServer addCacheServer() {
        return this.addCacheServer(false);
    }

    public CacheServer addCacheServer(boolean isGatewayReceiver) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        BridgeServerImpl bridge = new BridgeServerImpl(this, isGatewayReceiver);
        this.allBridgeServers.add(bridge);
        this.sendAddCacheServerProfileMessage();
        return bridge;
    }

    @Override
    public GatewayHub setGatewayHub(String id, int port) {
        return this.addGatewayHub(id, port);
    }

    private int findGatewayHub(GatewayHubImpl[] list, GatewayHubImpl hub) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(hub)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayHub addGatewayHub(String id, int port, int hubType, boolean isCapableOfBecomingPrimary) {
        GatewayHubImpl hub;
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            if (this.alreadyDefinesGatewayHubId(id)) {
                throw new GatewayException(LocalizedStrings.GemFireCache_A_GATEWAYHUB_WITH_ID_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(id));
            }
            if (this.alreadyDefinesGatewayHubPort(port)) {
                throw new GatewayException(LocalizedStrings.GemFireCache_A_GATEWAYHUB_WITH_PORT_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(port));
            }
            Object[] snap = this.allGatewayHubs;
            hub = new GatewayHubImpl(this, id, port, hubType, isCapableOfBecomingPrimary);
            int pos = this.findGatewayHub((GatewayHubImpl[])snap, hub);
            Assert.assertTrue(pos == -1);
            this.allGatewayHubs = (GatewayHubImpl[])ArrayUtils.insert(snap, snap.length, hub);
        }
        object = this.rootRegions;
        synchronized (object) {
            Set<LocalRegion> appRegions = this.getApplicationRegions();
            for (LocalRegion r : appRegions) {
                RegionAttributes ra = r.getAttributes();
                String hubID = ra.getGatewayHubId();
                Set<String> allGatewayHubIdsForRegion = r.getAllGatewayHubIds();
                if (!ra.getEnableGateway() || !hubID.equals("") && !hubID.equals(id) && (allGatewayHubIdsForRegion == null || !allGatewayHubIdsForRegion.contains(id))) continue;
                r.hubCreated(hubType);
            }
        }
        return hub;
    }

    @Override
    public GatewayHub addGatewayHub(String id, int port) {
        return this.addGatewayHub(id, port, 0x1000000, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGatewaySender(GatewaySender sender) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            HashSet<GatewaySender> tmp;
            if (!this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((AbstractGatewaySender)sender).distribute(true);
                tmp = new HashSet<GatewaySender>(this.allGatewaySenders.size() + 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    tmp.addAll(this.allGatewaySenders);
                }
            } else {
                throw new IllegalStateException(LocalizedStrings.GemFireCache_A_GATEWAYSENDER_WITH_ID_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(sender.getId()));
            }
            tmp.add(sender);
            this.allGatewaySenders = Collections.unmodifiableSet(tmp);
        }
        object = this.rootRegions;
        synchronized (object) {
            Set<LocalRegion> appRegions = this.getApplicationRegions();
            for (LocalRegion r : appRegions) {
                Set<String> senders = r.getAllGatewaySenderIds();
                if (!senders.contains(sender.getId()) || sender.isParallel()) continue;
                r.senderCreated();
            }
        }
        if (!sender.isParallel()) {
            Region dynamicMetaRegion = this.getRegion("__DynamicRegions");
            if (dynamicMetaRegion == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" The dynamic region is null. ");
                }
            } else {
                dynamicMetaRegion.getAttributesMutator().addGatewaySenderId(sender.getId());
            }
        }
        if (sender.getRemoteDSId() >= 0) {
            this.system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_CREATE, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGatewaySender(GatewaySender sender) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            if (this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((AbstractGatewaySender)sender, true).distribute(true);
                HashSet<GatewaySender> tmp = new HashSet<GatewaySender>(this.allGatewaySenders.size() - 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    tmp.addAll(this.allGatewaySenders);
                }
                tmp.remove(sender);
                this.allGatewaySenders = Collections.unmodifiableSet(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGatewayReceiver(GatewayReceiver recv) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewayReceiversLock;
        synchronized (object) {
            HashSet<GatewayReceiver> tmp = new HashSet<GatewayReceiver>(this.allGatewayReceivers.size() + 1);
            if (!this.allGatewayReceivers.isEmpty()) {
                tmp.addAll(this.allGatewayReceivers);
            }
            tmp.add(recv);
            this.allGatewayReceivers = Collections.unmodifiableSet(tmp);
        }
    }

    public void addAsyncEventQueue(AsyncEventQueue asyncQueue) {
        this.allAsyncEventQueues.add(asyncQueue);
        this.system.handleResourceEvent(ResourceEvent.ASYNCEVENTQUEUE_CREATE, asyncQueue);
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> tempSet = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.allGatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            tempSet.add(sender);
        }
        return tempSet;
    }

    public Set<GatewaySender> getAllGatewaySenders() {
        return this.allGatewaySenders;
    }

    @Override
    public GatewaySender getGatewaySender(String Id) {
        for (GatewaySender sender : this.allGatewaySenders) {
            if (!sender.getId().equals(Id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.allGatewayReceivers;
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.allAsyncEventQueues;
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.allAsyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    @Override
    public GatewayHub getGatewayHub() {
        GatewayHubImpl[] snap = this.allGatewayHubs;
        if (snap.length == 0) {
            return null;
        }
        return snap[0];
    }

    public boolean hasGatewayHub() {
        return this.allGatewayHubs.length > 0;
    }

    @Override
    public List<GatewayHub> getGatewayHubs() {
        GatewayHubImpl[] snap = this.allGatewayHubs;
        ArrayList<GatewayHub> result = new ArrayList<GatewayHub>();
        for (int i = 0; i < snap.length; ++i) {
            result.add(snap[i]);
        }
        return result;
    }

    @Override
    public GatewayHub getGatewayHub(String id) {
        GatewayHubImpl result = null;
        for (int i = 0; i < this.allGatewayHubs.length; ++i) {
            GatewayHubImpl hub = this.allGatewayHubs[i];
            if (!hub.getId().equals(id)) continue;
            result = hub;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            return this.gatewayConflictResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            this.gatewayConflictResolver = resolver;
        }
    }

    protected boolean alreadyDefinesGatewayHubId(String id) {
        boolean alreadyDefined = false;
        for (int i = 0; i < this.allGatewayHubs.length; ++i) {
            GatewayHubImpl hub = this.allGatewayHubs[i];
            if (!hub.getId().equals(id)) continue;
            alreadyDefined = true;
            break;
        }
        return alreadyDefined;
    }

    protected boolean alreadyDefinesGatewayHubPort(int port) {
        boolean alreadyDefined = false;
        if (port != -1) {
            for (int i = 0; i < this.allGatewayHubs.length; ++i) {
                GatewayHubImpl hub = this.allGatewayHubs[i];
                if (hub.getPort() != port) continue;
                alreadyDefined = true;
                break;
            }
        }
        return alreadyDefined;
    }

    public List getBridgeServers() {
        return this.getCacheServers();
    }

    public List getCacheServers() {
        List bridgeServersWithoutReceiver = null;
        if (!this.allBridgeServers.isEmpty()) {
            for (BridgeServerImpl bridgeServer : this.allBridgeServers) {
                if (bridgeServer.isGatewayReceiver()) continue;
                if (bridgeServersWithoutReceiver == null) {
                    bridgeServersWithoutReceiver = new ArrayList();
                }
                bridgeServersWithoutReceiver.add(bridgeServer);
            }
        }
        if (bridgeServersWithoutReceiver == null) {
            bridgeServersWithoutReceiver = Collections.emptyList();
        }
        return bridgeServersWithoutReceiver;
    }

    public List getBridgeServersAndGatewayReceiver() {
        return this.allBridgeServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requiresPREvents() {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            Iterator<PartitionedRegion> it = this.partitionedRegions.iterator();
            while (it.hasNext()) {
                it.next().cacheRequiresNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionedRegion(PartitionedRegion r) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
            synchronized (hashSet) {
                if (r.isDestroyed()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("GemFireCache#addPartitionedRegion did not add destroyed {}", r);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 8] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                if (this.partitionedRegions.add(r)) {
                    this.getCachePerfStats().incPartitionedRegions(1);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionedRegion> getPartitionedRegions() {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            return new HashSet<PartitionedRegion>(this.partitionedRegions);
        }
    }

    private TreeMap<String, Map<String, PartitionedRegion>> getPRTrees() {
        TreeMap<String, Map<String, PartitionedRegion>> prTrees = new TreeMap<String, Map<String, PartitionedRegion>>();
        TreeMap<String, PartitionedRegion> prMap = this.getPartitionedRegionMap();
        boolean hasColocatedRegion = false;
        for (PartitionedRegion pr2 : prMap.values()) {
            List<PartitionedRegion> childlist = ColocationHelper.getColocatedChildRegions(pr2);
            if (childlist == null || childlist.size() <= 0) continue;
            hasColocatedRegion = true;
            break;
        }
        if (hasColocatedRegion) {
            LinkedHashMap<String, PartitionedRegion> orderedPrMap = this.orderByColocation(prMap);
            prTrees.put("ROOT", orderedPrMap);
        } else {
            for (PartitionedRegion pr2 : prMap.values()) {
                String rootName = pr2.getRoot().getName();
                TreeMap<String, PartitionedRegion> prSubMap = (TreeMap<String, PartitionedRegion>)prTrees.get(rootName);
                if (prSubMap == null) {
                    prSubMap = new TreeMap<String, PartitionedRegion>();
                    prTrees.put(rootName, prSubMap);
                }
                prSubMap.put(pr2.getFullPath(), pr2);
            }
        }
        return prTrees;
    }

    private TreeMap<String, PartitionedRegion> getPartitionedRegionMap() {
        TreeMap<String, PartitionedRegion> prMap = new TreeMap<String, PartitionedRegion>();
        for (Map.Entry entry : this.pathToRegion.entrySet()) {
            String regionName = (String)entry.getKey();
            Region region = (Region)entry.getValue();
            if (!(region instanceof PartitionedRegion)) continue;
            try {
                Region pr2 = this.getRegion(regionName);
                if (!(pr2 instanceof PartitionedRegion)) continue;
                prMap.put(regionName, (PartitionedRegion)pr2);
            }
            catch (CancelException ce) {}
        }
        return prMap;
    }

    private LinkedHashMap<String, PartitionedRegion> orderByColocation(TreeMap<String, PartitionedRegion> prMap) {
        LinkedHashMap<String, PartitionedRegion> orderedPrMap = new LinkedHashMap<String, PartitionedRegion>();
        for (PartitionedRegion pr2 : prMap.values()) {
            this.addColocatedChildRecursively(orderedPrMap, pr2);
        }
        return orderedPrMap;
    }

    private void addColocatedChildRecursively(LinkedHashMap<String, PartitionedRegion> prMap, PartitionedRegion pr2) {
        for (PartitionedRegion colocatedRegion : ColocationHelper.getColocatedChildRegions(pr2)) {
            this.addColocatedChildRecursively(prMap, colocatedRegion);
        }
        prMap.put(pr2.getFullPath(), pr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requiresNotificationFromPR(PartitionedRegion r) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            boolean result;
            boolean hasHubs = this.allGatewayHubs.length > 0;
            boolean hasSerialSenders = this.hasSerialSenders(r);
            boolean bl = result = hasHubs && r.getAttributes().getEnableGateway() || hasSerialSenders;
            if (!result) {
                for (BridgeServerImpl server : this.allBridgeServers) {
                    if (server.getNotifyBySubscription()) continue;
                    result = true;
                    break;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private boolean hasSerialSenders(PartitionedRegion r) {
        boolean hasSenders = false;
        Set<String> senders = r.getAllGatewaySenderIds();
        for (String sender : senders) {
            GatewaySender gs = this.getGatewaySender(sender);
            if (gs == null || gs.isParallel()) continue;
            hasSenders = true;
            break;
        }
        return hasSenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getHighestOrderHubTypeAssociatedWith(Region r) {
        boolean hasHubsAndGtwayEnabled;
        int hubType = -1;
        RegionAttributes ra = r.getAttributes();
        boolean bl = hasHubsAndGtwayEnabled = this.allGatewayHubs.length > 0 && ra.getEnableGateway();
        if (hasHubsAndGtwayEnabled) {
            Object object = this.allGatewayHubsLock;
            synchronized (object) {
                String hubID = ra.getGatewayHubId();
                boolean checkAll = hubID.equals("");
                Set<String> allGatewayHubsForRegion = ((LocalRegion)r).getAllGatewayHubIds();
                boolean checkSome = allGatewayHubsForRegion != null && !allGatewayHubsForRegion.isEmpty();
                for (GatewayHubImpl hub : this.allGatewayHubs) {
                    int temp;
                    if (checkAll) {
                        temp = hub.getHubType();
                        if (temp <= hubType) continue;
                        hubType = temp;
                        continue;
                    }
                    if (checkSome) {
                        if (!allGatewayHubsForRegion.contains(hub.getId()) || (temp = hub.getHubType()) <= hubType) continue;
                        hubType = temp;
                        continue;
                    }
                    if (!hub.getId().equals(hubID)) continue;
                    hubType = hub.getHubType();
                    break;
                }
            }
        }
        return hubType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionedRegion(PartitionedRegion r) {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            if (this.partitionedRegions.remove(r)) {
                this.getCachePerfStats().incPartitionedRegions(-1);
            }
        }
    }

    @Override
    public void setIsServer(boolean isServer) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.isServer = isServer;
    }

    @Override
    public boolean isServer() {
        if (this.isClient()) {
            return false;
        }
        this.stopper.checkCancelInProgress(null);
        if (!this.isServer) {
            return this.allBridgeServers.size() > 0;
        }
        return true;
    }

    @Override
    public QueryService getQueryService() {
        if (this.isClient()) {
            Pool p = this.getDefaultPool();
            if (p == null) {
                throw new IllegalStateException("Client cache does not have a default pool. Use getQueryService(String poolName) instead.");
            }
            return p.getQueryService();
        }
        return new DefaultQueryService(this);
    }

    @Override
    public QueryService getLocalQueryService() {
        return new DefaultQueryService(this);
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    public TransactionManager getJTATransactionManager() {
        return JNDIInvoker.getTransactionManager();
    }

    public FilterProfile getFilterProfile(String regionName) {
        LocalRegion r = (LocalRegion)this.getRegion(regionName, true);
        if (r != null) {
            return r.getFilterProfile();
        }
        return null;
    }

    public RegionAttributes getRegionAttributes(String id) {
        return (RegionAttributes)this.namedRegionAttributes.get(id);
    }

    public void setRegionAttributes(String id, RegionAttributes attrs) {
        if (attrs == null) {
            this.namedRegionAttributes.remove(id);
        } else {
            this.namedRegionAttributes.put(id, attrs);
        }
    }

    public Map listRegionAttributes() {
        return Collections.unmodifiableMap(this.namedRegionAttributes);
    }

    public static GemFireCacheImpl getXmlCache() {
        return (GemFireCacheImpl)xmlCache.get();
    }

    @Override
    public void loadCacheXml(InputStream stream) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Object oldValue = xmlCache.get();
        xmlCache.set(this);
        try {
            CacheXmlParser xml;
            if (xmlParameterizationEnabled) {
                char[] buffer = new char[1024];
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
                StringWriter stringWriter = new StringWriter();
                int n = -1;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)stringWriter).write(buffer, 0, n);
                }
                String replacedXmlString = resolver.processUnresolvableString(((Object)stringWriter).toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "ISO-8859-1");
                writer.write(replacedXmlString);
                writer.flush();
                xml = CacheXmlParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            } else {
                xml = CacheXmlParser.parse(stream);
            }
            xml.create(this);
        }
        catch (IOException e) {
            throw new CacheXmlException("Input Stream could not be read for system property substitutions.");
        }
        finally {
            xmlCache.set(oldValue);
        }
    }

    @Override
    public void readyForEvents() {
        PoolManagerImpl.readyForEvents(this.system, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReliableMessageQueueFactory() {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            if (this.rmqFactory != null) {
                this.rmqFactory.close(false);
            }
            this.rmqFactory = new ReliableMessageQueueFactoryImpl();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ReliableMessageQueueFactory getReliableMessageQueueFactory() {
        return this.rmqFactory;
    }

    @Override
    public InternalResourceManager getResourceManager() {
        return this.getResourceManager(true);
    }

    public InternalResourceManager getResourceManager(boolean checkCancellationInProgress) {
        if (checkCancellationInProgress) {
            this.stopper.checkCancelInProgress(null);
        }
        return this.resourceManager;
    }

    public void setBackupFiles(List<File> backups) {
        this.backupFiles = backups;
    }

    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backupFiles);
    }

    public BackupManager startBackup(InternalDistributedMember sender) throws IOException {
        BackupManager manager = new BackupManager(sender, this);
        if (!this.backupManager.compareAndSet(null, manager)) {
            throw new IOException("Backup already in progress");
        }
        manager.start();
        return manager;
    }

    public void clearBackupManager() {
        this.backupManager.set(null);
    }

    public BackupManager getBackupManager() {
        return this.backupManager.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterestCompleted() {
        if (this.isClosing) {
            return;
        }
        int cv = this.registerInterestsInProgress.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestCompleted: new value = {}", cv);
        }
        if (cv == 0) {
            ArrayList<SimpleWaiter> arrayList = this.riWaiters;
            synchronized (arrayList) {
                cv = this.registerInterestsInProgress.get();
                if (cv == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("registerInterestCompleted: Signalling end of register-interest");
                    }
                    for (SimpleWaiter sw : this.riWaiters) {
                        sw.doNotify();
                    }
                    this.riWaiters.clear();
                }
            }
        }
    }

    public void registerInterestStarted() {
        int newVal = this.registerInterestsInProgress.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestsStarted: new count = {}", newVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRegisterInterestsInProgress() {
        this.getCancelCriterion().checkCancelInProgress(null);
        int count = this.registerInterestsInProgress.get();
        SimpleWaiter sw = null;
        if (count > 0) {
            ArrayList<SimpleWaiter> arrayList = this.riWaiters;
            synchronized (arrayList) {
                count = this.registerInterestsInProgress.get();
                if (count > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("waitForRegisterInterestsInProgress: count ={}", count);
                    }
                    sw = new SimpleWaiter();
                    this.riWaiters.add(sw);
                }
            }
            if (sw != null) {
                sw.doWait();
            }
        }
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setQueryMonitorRequiredForResourceManager(boolean required) {
        QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER = required;
    }

    public boolean isQueryMonitorDisabledForLowMemory() {
        return this.QUERY_MONITOR_DISABLED_FOR_LOW_MEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMonitor getQueryMonitor() {
        boolean monitorRequired = !this.QUERY_MONITOR_DISABLED_FOR_LOW_MEM && QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER != false;
        if (MAX_QUERY_EXECUTION_TIME <= 0 && this.TEST_MAX_QUERY_EXECUTION_TIME <= 0 && !monitorRequired) {
            return null;
        }
        if ((MAX_QUERY_EXECUTION_TIME > 0 || this.TEST_MAX_QUERY_EXECUTION_TIME > 0 || monitorRequired) && this.queryMonitor == null) {
            Object object = this.queryMonitorLock;
            synchronized (object) {
                if (this.queryMonitor == null) {
                    int maxTime;
                    int n = maxTime = MAX_QUERY_EXECUTION_TIME > this.TEST_MAX_QUERY_EXECUTION_TIME ? MAX_QUERY_EXECUTION_TIME : this.TEST_MAX_QUERY_EXECUTION_TIME;
                    if (monitorRequired && maxTime < 0) {
                        maxTime = 18000000;
                    }
                    this.queryMonitor = new QueryMonitor(maxTime);
                    LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("QueryMonitor Thread Group", logger);
                    Thread qmThread = new Thread(group, this.queryMonitor, "QueryMonitor Thread");
                    qmThread.setDaemon(true);
                    qmThread.start();
                    if (logger.isDebugEnabled()) {
                        logger.debug("QueryMonitor thread started.");
                    }
                }
            }
        }
        return this.queryMonitor;
    }

    private void sendAddCacheServerProfileMessage() {
        DM dm = this.getDistributedSystem().getDistributionManager();
        Set otherMembers = dm.getOtherDistributionManagerIds();
        AddCacheServerProfileMessage msg = new AddCacheServerProfileMessage();
        msg.operateOnLocalCache(this);
        if (!otherMembers.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending add cache server profile message to other members.");
            }
            ReplyProcessor21 rp = new ReplyProcessor21(dm, (Collection)otherMembers);
            msg.setRecipients(otherMembers);
            msg.processorId = rp.getProcessorId();
            dm.putOutgoing(msg);
            try {
                rp.waitForReplies();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public TXManagerImpl getTxManager() {
        return this.txMgr;
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut atts) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, atts);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, regionAttributesId);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, regionAttributes);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut atts) {
        return new ClientRegionFactoryImpl(this, atts);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String refid) {
        return new ClientRegionFactoryImpl(this, refid);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        Pool p = PoolManager.find(poolName);
        if (p == null) {
            throw new IllegalStateException("Could not find a pool named " + poolName);
        }
        return p.getQueryService();
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties) {
        Pool pool = this.getDefaultPool();
        if (pool == null) {
            throw new IllegalStateException("This cache does not have a default pool");
        }
        return this.createAuthenticatedCacheView(pool, properties);
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties, String poolName) {
        Pool pool = PoolManager.find(poolName);
        if (pool == null) {
            throw new IllegalStateException("Pool " + poolName + " does not exist");
        }
        return this.createAuthenticatedCacheView(pool, properties);
    }

    public RegionService createAuthenticatedCacheView(Pool pool, Properties properties) {
        if (pool.getMultiuserAuthentication()) {
            return ((PoolImpl)pool).createAuthenticatedCacheView(properties);
        }
        throw new IllegalStateException("The pool " + pool.getName() + " did not have multiuser-authentication set to true");
    }

    public static void initializeRegionShortcuts(Cache c) {
        if (GemFireCacheImpl.sqlfSystem()) {
            return;
        }
        block25: for (RegionShortcut pra : RegionShortcut.values()) {
            switch (pra) {
                case PARTITION: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)pra));
                }
            }
        }
    }

    public static void initializeClientRegionShortcuts(Cache c) {
        block11: for (ClientRegionShortcut pra : ClientRegionShortcut.values()) {
            switch (pra) {
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)pra));
                }
            }
        }
    }

    public void beginDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.putIfAbsent(path, region);
    }

    public void endDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.remove(path, region);
    }

    public DistributedRegion getRegionInDestroy(String path) {
        return (DistributedRegion)this.regionsInDestroy.get(path);
    }

    public DistributionAdvisee getSqlfAdvisee() {
        return this.sqlfAdvisee;
    }

    public void setSqlfAdvisee(DistributionAdvisee advisee) {
        this.sqlfAdvisee = advisee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean updateNodeStatus(InternalDistributedMember member, boolean initialized) {
        HashSet<BucketAdvisor> advisors = null;
        HashSet<InternalDistributedMember> hashSet = this.unInitializedMembers;
        // MONITORENTER : hashSet
        if (!initialized) {
            // MONITOREXIT : hashSet
            return this.unInitializedMembers.add(member);
        }
        if (!this.unInitializedMembers.remove(member)) {
            // MONITOREXIT : hashSet
            return false;
        }
        if (member.equals(this.getMyId())) {
            advisors = new HashSet<BucketAdvisor>(this.deferredVolunteerForPrimary);
            this.deferredVolunteerForPrimary.clear();
        }
        // MONITOREXIT : hashSet
        if (advisors == null) return true;
        Iterator<BucketAdvisor> i$ = advisors.iterator();
        while (i$.hasNext()) {
            BucketAdvisor advisor = i$.next();
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking volunteer for primary for deferred bucket post SQLFabric DDL replay for BucketAdvisor: {}", advisor);
            }
            advisor.volunteerForPrimary();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnInitializedMember(InternalDistributedMember member) {
        HashSet<InternalDistributedMember> hashSet = this.unInitializedMembers;
        synchronized (hashSet) {
            return this.unInitializedMembers.contains(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doVolunteerForPrimary(BucketAdvisor advisor) {
        HashSet<InternalDistributedMember> hashSet = this.unInitializedMembers;
        synchronized (hashSet) {
            if (!this.unInitializedMembers.contains(this.getMyId())) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Deferring volunteer for primary due to uninitialized node (SQLFabric DDL replay) for BucketAdvisor: {}", advisor);
            }
            this.deferredVolunteerForPrimary.add(advisor);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeUnInitializedMembers(Collection<InternalDistributedMember> members) {
        HashSet<InternalDistributedMember> hashSet = this.unInitializedMembers;
        synchronized (hashSet) {
            for (InternalDistributedMember m : this.unInitializedMembers) {
                members.remove(m);
            }
        }
    }

    public final boolean isSqlfSystem() {
        return this.sqlfSystem;
    }

    public static boolean sqlfSystem() {
        return instance != null && instance.isSqlfSystem();
    }

    public void setSqlfSystem() {
        this.sqlfSystem = true;
    }

    public TombstoneService getTombstoneService() {
        return this.tombstoneService;
    }

    public TypeRegistry getPdxRegistry() {
        return this.pdxRegistry;
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.pdxReadSerialized;
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.pdxSerializer;
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.pdxDiskStore;
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.pdxPersistent;
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.pdxIgnoreUnreadFields;
    }

    public boolean getPdxReadSerializedByAnyGemFireServices() {
        return (this.getPdxReadSerialized() || DefaultQuery.getPdxReadSerialized()) && PdxInstanceImpl.getPdxReadSerialized();
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public DM getDistributionManager() {
        return this.dm;
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return new GatewaySenderFactoryImpl(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return new GatewayReceiverFactoryImpl(this);
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.getResourceAdvisor();
    }

    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.resourceAdvisor.createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    @Override
    public String getFullPath() {
        return "ResourceManager";
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        this.resourceManager.fillInProfile(profile);
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    public TXEntryStateFactory getTXEntryStateFactory() {
        return this.txEntryStateFactory;
    }

    public void setPdxSerializer(PdxSerializer v) {
        this.cacheConfig.setPdxSerializer(v);
        this.basicSetPdxSerializer(v);
    }

    private void basicSetPdxSerializer(PdxSerializer v) {
        AutoSerializableManager asm;
        TypeRegistry.setPdxSerializer(v);
        if (v instanceof ReflectionBasedAutoSerializer && (asm = AutoSerializableManager.getInstance((ReflectionBasedAutoSerializer)v)) != null) {
            asm.setRegionService(this);
        }
    }

    public void setReadSerialized(boolean v) {
        this.cacheConfig.setPdxReadSerialized(v);
    }

    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig.setDeclarativeConfig(cacheConfig);
        this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> newEntry : mapOfNewDeclarableProps.entrySet()) {
                Class<?> clazz = newEntry.getKey().getClass();
                Declarable matchingDeclarable = null;
                for (Map.Entry<Declarable, Properties> oldEntry : this.declarablePropertiesMap.entrySet()) {
                    if (!clazz.getName().equals(oldEntry.getKey().getClass().getName()) || !newEntry.getValue().equals(oldEntry.getValue()) && (!(newEntry.getKey() instanceof Identifiable) || !((Identifiable)((Object)oldEntry.getKey())).getId().equals(((Identifiable)((Object)newEntry.getKey())).getId()))) continue;
                    matchingDeclarable = oldEntry.getKey();
                    break;
                }
                if (matchingDeclarable != null) {
                    this.declarablePropertiesMap.remove(matchingDeclarable);
                }
                this.declarablePropertiesMap.put(newEntry.getKey(), newEntry.getValue());
            }
        }
    }

    public static boolean isXmlParameterizationEnabled() {
        return xmlParameterizationEnabled;
    }

    public static void setXmlParameterizationEnabled(boolean isXmlParameterizationEnabled) {
        xmlParameterizationEnabled = isXmlParameterizationEnabled;
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    public void setInitializer(Declarable initializer, Properties initializerProps) {
        this.initializer = initializer;
        this.initializerProps = initializerProps;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return PdxInstanceFactoryImpl.newCreator(className, true);
    }

    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean b) {
        return PdxInstanceFactoryImpl.newCreator(className, b);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return PdxInstanceFactoryImpl.createPdxEnum(className, enumName, enumOrdinal, this);
    }

    public JmxManagerAdvisor getJmxManagerAdvisor() {
        return this.jmxAdvisor;
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        return new CacheSnapshotServiceImpl(this);
    }

    private void startColocatedJmxManagerLocator() {
        InternalLocator loc = InternalLocator.getLocator();
        if (loc != null) {
            loc.startJmxManagerLocationService(this);
        }
    }

    public TemporaryResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public DiskStoreMonitor getDiskStoreMonitor() {
        return this.diskMonitor;
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }

    public static int getClientFunctionTimeout() {
        return clientFunctionTimeout;
    }

    static {
        xmlParameterizationEnabled = !Boolean.getBoolean("gemfire.xml.parameterization.disabled");
        String propertyName = "sun.nio.ch.bugLevel";
        String value2 = System.getProperty(propertyName);
        if (value2 == null) {
            System.setProperty(propertyName, "");
        }
        testCacheXml = null;
        emergencyClassesLoaded = false;
        shutdownAllPoolSize = Integer.getInteger("gemfire.SHUTDOWN_ALL_POOL_SIZE", -1);
        DEFAULT_DS_NAME = "DEFAULT";
        xmlCache = new ThreadLocal();
    }

    private class SimpleWaiter {
        private boolean notified = false;

        SimpleWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doWait() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                while (!this.notified) {
                    GemFireCacheImpl.this.getCancelCriterion().checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doNotify() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                this.notified = true;
                this.notifyAll();
            }
        }
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (GemFireCacheImpl.this.disconnectCause != null) {
                return GemFireCacheImpl.this.disconnectCause.getMessage();
            }
            if (GemFireCacheImpl.this.isClosing) {
                return "The cache is closed.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            if (GemFireCacheImpl.this.disconnectCause == null) {
                return new CacheClosedException(reason, e);
            }
            if (e == null) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
            Throwable nt = e;
            while (nt.getCause() != null) {
                nt = nt.getCause();
            }
            try {
                nt.initCause(GemFireCacheImpl.this.disconnectCause);
                return new CacheClosedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
        }
    }
}

