/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.internal.cache.GatewayEndpointStatus;
import java.io.Serializable;
import java.util.List;

public class GatewayStatus
implements Serializable {
    private static final long serialVersionUID = -6151097585068547412L;
    protected String _id;
    protected boolean _isConnected;
    protected int _queueSize;
    protected GatewayEndpointStatus[] _endpointStatuses;

    public GatewayStatus(Gateway gateway) {
        this.setId(gateway.getId());
        this.setIsConnected(gateway.isConnected());
        this.setQueueSize(gateway.getQueueSize());
        this.initializeEndpointStatuses(gateway);
    }

    public String getId() {
        return this._id;
    }

    protected void setId(String id) {
        this._id = id;
    }

    public boolean getIsConnected() {
        return this._isConnected;
    }

    protected void setIsConnected(boolean isConnected) {
        this._isConnected = isConnected;
    }

    public int getQueueSize() {
        return this._queueSize;
    }

    protected void setQueueSize(int queueSize) {
        this._queueSize = queueSize;
    }

    public GatewayEndpointStatus[] getEndpointStatuses() {
        return this._endpointStatuses;
    }

    protected void initializeEndpointStatuses(Gateway gateway) {
        List endpoints = gateway.getEndpoints();
        this._endpointStatuses = new GatewayEndpointStatus[endpoints.size()];
        int i = 0;
        for (Gateway.Endpoint endpoint : endpoints) {
            this._endpointStatuses[i] = new GatewayEndpointStatus(endpoint);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayStatus[").append("id=").append(this._id).append("; isConnected=").append(this._isConnected).append("; queueSize=").append(this._queueSize);
        if (this._endpointStatuses == null) {
            buffer.append("; endpoints = null");
        } else {
            buffer.append("; endpoints (" + this._endpointStatuses.length + ") = [");
            for (int i = 0; i < this._endpointStatuses.length; ++i) {
                buffer.append(this._endpointStatuses[i].toString());
                if (i == this._endpointStatuses.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

