/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class GatewayHubStats {
    private static final StatisticsType _type;
    private static final String EVENTS_RECEIVED = "eventsReceived";
    private static final String EVENTS_QUEUED = "eventsQueued";
    private static final String EVENT_QUEUE_TIME = "eventQueueTime";
    private static final String EVENT_QUEUE_SIZE = "eventQueueSize";
    private static final String EVENTS_PROCESSED = "eventsProcessed";
    private static final String NUMBER_OF_GATEWAYS = "numberOfGateways";
    private static final int _eventsReceivedId;
    private static final int _eventsQueuedId;
    private static final int _eventQueueTimeId;
    private static final int _eventQueueSizeId;
    private static final int _eventsProcessedId;
    private static final int _numberOfGatewaysId;
    public static final String typeName = "GatewayHubStatistics";
    private final Statistics _stats;

    public GatewayHubStats(StatisticsFactory f, String gatewayHubId) {
        this._stats = f.createAtomicStatistics(_type, "gatewayHubStats-" + gatewayHubId);
    }

    public void close() {
        this._stats.close();
    }

    public boolean isClosed() {
        return this._stats.isClosed();
    }

    public int getNumberOfGateways() {
        return this._stats.getInt(_numberOfGatewaysId);
    }

    public int getEventsReceived() {
        return this._stats.getInt(_eventsReceivedId);
    }

    public int getEventsQueued() {
        return this._stats.getInt(_eventsQueuedId);
    }

    public int getEventQueueSize() {
        return this._stats.getInt(_eventQueueSizeId);
    }

    public int getEventsProcessed() {
        return this._stats.getInt(_eventsProcessedId);
    }

    public void setQueueSize(int size2) {
        this._stats.setInt(_eventQueueSizeId, size2);
    }

    public void incNumberOfGateways() {
        this._stats.incInt(_numberOfGatewaysId, 1);
    }

    public void incNumberOfGateways(int value2) {
        this._stats.incInt(_numberOfGatewaysId, value2);
    }

    public void incEventsReceived() {
        this._stats.incInt(_eventsReceivedId, 1);
    }

    public void incEventsProcessed() {
        this._stats.incInt(_eventsProcessedId, 1);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    public void endPut(long start) {
        long ts = DistributionStats.getStatTime();
        this._stats.incInt(_eventsQueuedId, 1);
        long elapsed = ts - start;
        this._stats.incLong(_eventQueueTimeId, elapsed);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(typeName, typeName, new StatisticDescriptor[]{f.createIntCounter(NUMBER_OF_GATEWAYS, "Number of gateways known to this hub.", "operations"), f.createIntCounter(EVENTS_RECEIVED, "Number of events received by this hub.", "operations"), f.createIntCounter(EVENTS_QUEUED, "Number of events added to the event queue by this hub.", "operations"), f.createLongCounter(EVENT_QUEUE_TIME, "Total time spent queueing events.", "nanoseconds"), f.createIntGauge(EVENT_QUEUE_SIZE, "Size of the event queue.", "operations"), f.createIntCounter(EVENTS_PROCESSED, "Number of events removed from the event queue and processed by this hub.", "operations")});
        _eventsReceivedId = _type.nameToId(EVENTS_RECEIVED);
        _eventsQueuedId = _type.nameToId(EVENTS_QUEUED);
        _eventQueueTimeId = _type.nameToId(EVENT_QUEUE_TIME);
        _eventQueueSizeId = _type.nameToId(EVENT_QUEUE_SIZE);
        _eventsProcessedId = _type.nameToId(EVENTS_PROCESSED);
        _numberOfGatewaysId = _type.nameToId(NUMBER_OF_GATEWAYS);
    }
}

