/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.GatewayCancelledException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractGateway;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GatewayHubStats;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GatewayParallelImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HasCachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantReadWriteLock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class GatewayHubImpl
implements GatewayHub,
MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private final Object controlLock = new Object();
    protected final Stopper stopper;
    private final StoppableReentrantReadWriteLock distributionRWLock;
    private final GemFireCacheImpl _cache;
    protected volatile boolean _isRunning;
    private AcceptorImpl _acceptor;
    private int _port;
    private volatile String _id;
    private int _socketBufferSize;
    private int _maximumTimeBetweenPings;
    protected final Object allGatewaysLock = new Object();
    protected volatile AbstractGateway[] allGateways = new AbstractGateway[0];
    private final List _gatewayIds = new CopyOnWriteArrayList();
    private final List _readOnlyGatewayIds = Collections.unmodifiableList(this._gatewayIds);
    private final LinkedBlockingQueue _executorQueue = new LinkedBlockingQueue();
    private final boolean capableOfBecomingPrimary;
    private final int hubType;
    public static final int NO_HUB = 0;
    public static final int NON_SQLF_HUB = 0x1000000;
    public static final int SQLF_WAN_HUB = 0x2000000;
    public static final int SQLF_ASYNC_EVENT_HUB = 0x3000000;
    public static final int SQLF_ASYNC_DBSYNCH_HUB = 0x4000000;
    private final ThreadPoolExecutor _executor;
    protected DistributedLockService _lockService;
    protected final String _lockToken;
    protected volatile boolean _primary;
    private Thread _lockObtainingThread;
    private GatewayHubStats _statistics;
    private String _startupPolicy;
    private boolean _manualStart;
    private String _bindAddress;
    private int _eventIdIndex;
    private Region<String, Integer> _eventIdIndexMetaDataRegion;
    private int _maxConnections;
    private static final boolean USE_ASYNCHRONOUS_DISTRIBUTION = Boolean.getBoolean("gemfire.asynchronous-gateway-distribution-enabled");
    protected static final boolean ALLOW_CONSERVE_SOCKETS = Boolean.getBoolean("gemfire.gateway-conserve-sockets-allowed");
    public static final String LOCK_SERVICE_NAME = "gatewayEventIdIndexMetaData_lockService";
    protected static final String META_DATA_REGION_NAME = "gatewayEventIdIndexMetaData";
    private final ThreadGroup threadGroup;
    private static volatile boolean emergencyClassesLoaded = false;

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public GatewayHubImpl(GemFireCacheImpl cache, String id, int port, int hubType, boolean isCapableOfBecomingPrimary) {
        final LoggingThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Gateway Hub Logger Group", logger);
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(loggerGroup, command, "Queued Gateway Hub Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        this._executor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)this._executorQueue, tf);
        this.threadGroup = LoggingThreadGroup.createThreadGroup("Gateway Hub Threads");
        this._cache = cache;
        this.stopper = new Stopper(cache.getCancelCriterion());
        this.distributionRWLock = new StoppableReentrantReadWriteLock(this.stopper);
        this._id = id;
        this._port = port;
        this._lockToken = this.getDistributedLockServiceName() + "-token";
        this._statistics = new GatewayHubStats(cache.getDistributedSystem(), id);
        this._socketBufferSize = 32768;
        this._maximumTimeBetweenPings = 60000;
        this._startupPolicy = "none";
        this._manualStart = false;
        this.hubType = hubType;
        this.capableOfBecomingPrimary = isCapableOfBecomingPrimary;
        this._bindAddress = DEFAULT_BIND_ADDRESS;
        this._maxConnections = 800;
        this.initializeEventIdIndex();
    }

    private void checkRunning() {
        if (this.stopper.cancelInProgress() == null) {
            throw new IllegalStateException(LocalizedStrings.GatewayHubImpl_A_BRIDGE_SERVERS_CONFIGURATION_CANNOT_BE_CHANGED_ONCE_IT_IS_RUNNING.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPort() {
        Object object = this.controlLock;
        synchronized (object) {
            return this.basicGetPort();
        }
    }

    private int basicGetPort() {
        if (this._acceptor != null) {
            return this._acceptor.getPort();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPort(int port) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this._port = port;
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this._id = id;
        }
    }

    @Override
    public String getBindAddress() {
        return this._bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBindAddress(String address) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this._bindAddress = address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        Object object = this.controlLock;
        synchronized (object) {
            this._socketBufferSize = socketBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSocketBufferSize() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._socketBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        Object object = this.controlLock;
        synchronized (object) {
            this._maximumTimeBetweenPings = maximumTimeBetweenPings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumTimeBetweenPings() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._maximumTimeBetweenPings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxConnections() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._maxConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxConnections(int maxConnections) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this._maxConnections = maxConnections;
        }
    }

    @Override
    public Gateway addGateway(String id) throws GatewayException {
        return this.addGateway(id, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gateway addGateway(String id, int concurrencyLevel) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            AbstractGateway gateway;
            this.checkRunning();
            Object object2 = this.allGatewaysLock;
            synchronized (object2) {
                if (this.alreadyDefinesGateway(id)) {
                    throw new GatewayException(LocalizedStrings.GatewayHubImpl_GATEWAYHUB_0_ALREADY_DEFINES_A_GATEWAY_WITH_ID_1.toLocalizedString(this._id, id));
                }
                if (concurrencyLevel < 1) {
                    throw new GatewayException(LocalizedStrings.Gateway_INVALID_CONCURRENCY_LEVEL.toLocalizedString(id, concurrencyLevel));
                }
                gateway = concurrencyLevel > 1 ? new GatewayParallelImpl(this, id, concurrencyLevel) : new GatewayImpl(this, id);
                Object[] snap = this.allGateways;
                this.allGateways = (AbstractGateway[])ArrayUtils.insert(snap, snap.length, gateway);
                this._gatewayIds.add(id);
            }
            this._statistics.incNumberOfGateways();
            return gateway;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGateway(String id) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            Object object2 = this.allGatewaysLock;
            synchronized (object2) {
                int pos = this.findGateway(id);
                if (pos == -1) {
                    throw new GatewayException(LocalizedStrings.GatewayHubImpl_GATEWAYHUB_0_DOES_NOT_CONTAIN_A_GATEWAY_WITH_ID_1.toLocalizedString(this._id, id));
                }
                this.allGateways = (AbstractGateway[])ArrayUtils.remove(this.allGateways, pos);
                this._gatewayIds.remove(pos);
            }
            this._statistics.incNumberOfGateways(-1);
        }
    }

    public List getGateways() {
        AbstractGateway[] snap = this.allGateways;
        ArrayList<AbstractGateway> result = new ArrayList<AbstractGateway>();
        for (int i = 0; i < snap.length; ++i) {
            result.add(snap[i]);
        }
        return result;
    }

    public List getGatewayIds() {
        return this._readOnlyGatewayIds;
    }

    public int getEventIdIndex() {
        return this._eventIdIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureFrom(GatewayHub other) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.setSocketBufferSize(other.getSocketBufferSize());
            this.setMaximumTimeBetweenPings(other.getMaximumTimeBetweenPings());
            this.setStartupPolicy(other.getStartupPolicy());
            this.setManualStart(other.getManualStart());
            this.setBindAddress(other.getBindAddress());
            this.setMaxConnections(other.getMaxConnections());
            Object object2 = other.getAllGatewaysLock();
            synchronized (object2) {
                for (Gateway otherGateway : other.getGateways()) {
                    AbstractGateway gateway = (AbstractGateway)this.addGateway(otherGateway.getId(), otherGateway.getConcurrencyLevel());
                    gateway.configureFrom(otherGateway);
                }
            }
        }
    }

    @Override
    public void start() throws IOException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(boolean startGateways) throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            LicenseChecker licenseChecker;
            if (this.stopper.cancelInProgress() == null) {
                return;
            }
            if (this.getStatistics().isClosed()) {
                this.setStatistics(new GatewayHubStats(this._cache.getDistributedSystem(), this.getId()));
            }
            if (this._port != -1 && (licenseChecker = this._cache.getDistributedSystem().getLicenseChecker()) != null) {
                licenseChecker.checkWanEnabled();
            }
            ((GemFireCacheImpl)this.getCache()).getPdxRegistry().startingGatewayHub();
            this.setRunning(true);
            this.initializeDistributedLockService();
            this.initializePrimary();
            if (this._port != -1) {
                this._acceptor = new AcceptorImpl(this._port, this._bindAddress, true, this._socketBufferSize, this._maximumTimeBetweenPings, this.getCache(), this._maxConnections, 0, 230000, 180, 0, null, null, this.hubType > 0x1000000, false, false, true, Collections.EMPTY_LIST, true);
                this._acceptor.start();
            }
            if (startGateways) {
                this.startGateways();
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_STARTED__0, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startGateways() throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            Object object2 = this.allGatewaysLock;
            synchronized (object2) {
                for (int i = 0; i < this.allGateways.length; ++i) {
                    AbstractGateway gateway = this.allGateways[i];
                    gateway.setPrimary(this._primary);
                    gateway.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseGateways() {
        Object object = this.controlLock;
        synchronized (object) {
            Object object2 = this.allGatewaysLock;
            synchronized (object2) {
                for (int i = 0; i < this.allGateways.length; ++i) {
                    AbstractGateway gateway = this.allGateways[i];
                    gateway.pause();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeGateways() {
        Object object = this.controlLock;
        synchronized (object) {
            Object object2 = this.allGatewaysLock;
            synchronized (object2) {
                for (int i = 0; i < this.allGateways.length; ++i) {
                    AbstractGateway gateway = this.allGateways[i];
                    gateway.resume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGateways() {
        StoppableReentrantReadWriteLock.StoppableWriteLock writeLock = this.distributionRWLock.writeLock();
        writeLock.lock();
        try {
            Object object = this.controlLock;
            synchronized (object) {
                Object object2 = this.allGatewaysLock;
                synchronized (object2) {
                    for (int i = 0; i < this.allGateways.length; ++i) {
                        AbstractGateway gateway = this.allGateways[i];
                        gateway.stop();
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean isRunning() {
        return this._isRunning;
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        AcceptorImpl.loadEmergencyClasses();
        GatewayImpl.loadEmergencyClasses();
    }

    public void emergencyClose() {
        this._isRunning = false;
        AcceptorImpl ac = this._acceptor;
        if (ac != null) {
            ac.emergencyClose();
        }
        AbstractGateway[] snap = this.allGateways;
        for (int i = 0; i < snap.length; ++i) {
            this.allGateways[i].emergencyClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        StoppableReentrantReadWriteLock.StoppableWriteLock writeLock = this.distributionRWLock.writeLock();
        boolean locked = false;
        try {
            block28: {
                try {
                    writeLock.lock();
                    locked = true;
                }
                catch (CancelException e) {
                    if (!logger.isDebugEnabled()) break block28;
                    logger.debug("{}: System is cancelled; removing resources", this);
                }
            }
            Object object = this.controlLock;
            synchronized (object) {
                block29: {
                    if (this.isRunning()) break block29;
                    return;
                }
                this.setRunning(false);
                if (this._acceptor != null) {
                    try {
                        this._acceptor.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this._executor != null) {
                    this._executor.shutdown();
                }
                Object e = this.allGatewaysLock;
                synchronized (e) {
                    for (int i = 0; i < this.allGateways.length; ++i) {
                        AbstractGateway gateway = this.allGateways[i];
                        try {
                            gateway.stop();
                            continue;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    DistributedLockService.destroy(this.getDistributedLockServiceName());
                }
                catch (IllegalArgumentException e2) {
                    // empty catch block
                }
                if (this._lockObtainingThread != null && this._lockObtainingThread.isAlive()) {
                    try {
                        this._lockObtainingThread.join(3000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    if (this._lockObtainingThread.isAlive()) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_COULD_NOT_STOP_LOCK_OBTAINING_THREAD_DURING_GATEWAY_HUB_SHUTDOWN));
                    }
                }
                if (this._statistics != null) {
                    this._statistics.close();
                }
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_STOPPED__0, this));
            }
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    @Override
    public Cache getCache() {
        return this._cache;
    }

    @Override
    public boolean isPrimary() {
        return this._primary;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(USE_ASYNCHRONOUS_DISTRIBUTION ? "Asynchronous " : "Synchronous ").append(this._primary ? "Primary" : "Secondary").append(" GatewayHub [id=").append(this._id).append(";bindAddress=").append(this._bindAddress).append(";port=").append(this.basicGetPort()).append(";startupPolicy=").append(this._startupPolicy).append("]");
        return buffer.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        ArrayList currentGateways = null;
        try {
            currentGateways = new ArrayList(this.getGateways());
        }
        catch (ConcurrentModificationException e) {
            currentGateways = null;
        }
        if (currentGateways == null) {
            sb.append(" connections are being modified.");
        } else {
            boolean and = false;
            for (Gateway gateway : currentGateways) {
                if (and) {
                    sb.append(" and");
                }
                sb.append(" connected to ");
                sb.append(gateway);
                and = true;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartupPolicy(String startupPolicy) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            if (!(startupPolicy.equals("none") || startupPolicy.equals("primary") || startupPolicy.equals("secondary"))) {
                throw new GatewayException(LocalizedStrings.GatewayHubImpl_AN_UNKNOWN_GATEWAY_HUB_POLICY_0_WAS_SPECIFIED_IT_MUST_BE_ONE_OF_1_2_3.toLocalizedString(startupPolicy, "none", "primary", "secondary"));
            }
            this._startupPolicy = startupPolicy;
        }
    }

    @Override
    public String getStartupPolicy() {
        return this._startupPolicy;
    }

    @Override
    public void setManualStart(boolean manualStart) {
        this._manualStart = manualStart;
    }

    @Override
    public boolean getManualStart() {
        return this._manualStart;
    }

    private String getDistributedLockServiceName() {
        return this.getClass().getName() + "-" + this.getId();
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    public void distribute(EnumListenerEvent operation, EntryEventImpl event) {
        if (event.getOperation().isLocal() || event.getOperation().isExpiration()) {
            return;
        }
        if (this.stopper.cancelInProgress() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received operation and event to distribute before the gateway hub is running (operation={}) event={}", this, operation, event);
            }
            return;
        }
        this._statistics.incEventsReceived();
        EntryEventImpl clonedEvent = new EntryEventImpl(event);
        this.setModifiedEventId(clonedEvent);
        if (clonedEvent.getRawCallbackArgument() != null && clonedEvent.getRawCallbackArgument() instanceof GatewaySenderEventCallbackArgument) {
            Object callBackArg = ((WrappedCallbackArgument)clonedEvent.getRawCallbackArgument()).getOriginalCallbackArg();
            clonedEvent.setRawCallbackArgument(callBackArg);
        }
        if (USE_ASYNCHRONOUS_DISTRIBUTION) {
            try {
                final EnumListenerEvent finalOperation = operation;
                final EntryEventImpl finalEvent = clonedEvent;
                long start = this._statistics.startTime();
                this._executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!ALLOW_CONSERVE_SOCKETS) {
                            DistributedSystem.setThreadsSocketPolicy(true);
                        }
                        try {
                            GatewayHubImpl.this.basicDistribute(finalOperation, finalEvent);
                        }
                        catch (CancelException e) {
                            return;
                        }
                    }
                });
                this._statistics.endPut(start);
                this._statistics.setQueueSize(this._executorQueue.size());
            }
            catch (RejectedExecutionException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_0__DISTRIBUTION_REJECTED, this), (Throwable)e);
            }
        } else {
            this.basicDistribute(operation, clonedEvent);
        }
    }

    protected GatewayHubStats getStatistics() {
        return this._statistics;
    }

    protected void setStatistics(GatewayHubStats statistics) {
        this._statistics = statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean running) {
        Object object = this.controlLock;
        synchronized (object) {
            this._isRunning = running;
        }
    }

    private boolean alreadyDefinesGateway(String id) {
        return this.findGateway(id) != -1;
    }

    private int findGateway(String id) {
        AbstractGateway[] snap = this.allGateways;
        for (int pos = 0; pos < snap.length; ++pos) {
            AbstractGateway gateway = snap[pos];
            if (!gateway.getId().equals(id)) continue;
            return pos;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicDistribute(EnumListenerEvent operation, EntryEventImpl event) {
        StoppableReentrantReadWriteLock.StoppableReadLock readLock = this.distributionRWLock.readLock();
        if (readLock.tryLock()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: About to notify all gateways to perform operation {} for {}", this, operation, event);
                }
                List gatewaysToDistribute = this.getGatewaysToDistribute(event);
                for (AbstractGateway gateway : gatewaysToDistribute) {
                    gateway.distribute(operation, event);
                }
                this._statistics.incEventsProcessed();
                this._statistics.setQueueSize(this._executorQueue.size());
            }
            finally {
                readLock.unlock();
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received operation and event to distribute before the gateway hub is running (operation={}) event={}", this, operation, event);
            }
            return;
        }
    }

    private List getGatewaysToDistribute(EntryEventImpl event) {
        boolean isPDXRegion;
        boolean isDebugEnabled = logger.isDebugEnabled();
        List<Gateway> distributeToGateways = null;
        Object callbackArg = event.getRawCallbackArgument();
        if (isDebugEnabled) {
            logger.debug("{}: Determining recipient gateways for {}", this, event);
        }
        LocalRegion region = event.getRegion();
        boolean sendToAllRecipients = false;
        boolean bl = isPDXRegion = region instanceof DistributedRegion && region.getName().equals("PdxTypes");
        if (isPDXRegion && event.getOperation().isCreate() && !event.isPossibleDuplicate()) {
            sendToAllRecipients = true;
        }
        if (callbackArg instanceof GatewayEventCallbackArgument) {
            GatewayEventCallbackArgument geca = (GatewayEventCallbackArgument)callbackArg;
            if (geca.getOriginatingGatewayHubId() == null || geca.getOriginatingGatewayHubId().equals(this._id)) {
                if (this._primary) {
                    geca.setOriginatingGatewayHubId(this._id);
                    geca.initializeRecipientGateways(this.getGatewayIds());
                }
                distributeToGateways = this.getGateways();
            } else {
                distributeToGateways = new ArrayList();
                if (isDebugEnabled) {
                    logger.debug("{}: Event is from a gateway with {}. It may not be distributed to all gateways.", this, geca);
                }
                for (Gateway gateway : this.getGateways()) {
                    String gatewayId = gateway.getId();
                    boolean distribute = true;
                    if (isDebugEnabled) {
                        logger.debug("{}: Verifying {}", this, gateway);
                    }
                    if (geca.getOriginatingGatewayHubId().equals(gatewayId)) {
                        if (isDebugEnabled) {
                            logger.debug("{}: Event originated in {}. It is being dropped.", this, gatewayId);
                        }
                        distribute = false;
                    }
                    if (!sendToAllRecipients) {
                        for (String recipientGatewayId : geca.getRecipientGateways()) {
                            if (!recipientGatewayId.equals(gatewayId)) continue;
                            if (isDebugEnabled) {
                                logger.debug("{}: Event has already been sent to gateway {}. Its is being dropped.", this, gatewayId);
                            }
                            distribute = false;
                            break;
                        }
                    }
                    if (!distribute) continue;
                    if (isDebugEnabled) {
                        logger.debug("{}: Event is being distributed to gateway {}", this, gatewayId);
                    }
                    geca.addRecipientGateway(gatewayId);
                    distributeToGateways.add(gateway);
                }
            }
        } else {
            if (isDebugEnabled) {
                logger.debug("{}: event is not from a gateway. It is being distributed to all gateways.", this);
            }
            GatewayEventCallbackArgument geCallbackArg = new GatewayEventCallbackArgument(callbackArg, this._id, this.getGatewayIds(), this.hubType != 0x2000000);
            event.setCallbackArgument(geCallbackArg);
            if (isDebugEnabled) {
                logger.debug("{}: set callback argument: {}", this, geCallbackArg);
            }
            distributeToGateways = this.getGateways();
        }
        return distributeToGateways;
    }

    private void initializePrimary() throws GatewayException {
        this._primary = false;
        if (this.capableOfBecomingPrimary) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Obtaining the lock on {}", this, this._lockToken);
            }
            this._lockService.lock(this._lockToken, 1000L, -1L);
            String startupPolicy = this.getStartupPolicy();
            if (startupPolicy.equals("none") || startupPolicy.equals("primary")) {
                if (this._lockService.isHeldByCurrentThread(this._lockToken)) {
                    this.startAsPrimary();
                } else {
                    this.startAsSecondary();
                }
            } else if (startupPolicy.equals("secondary")) {
                if (this._lockService.isHeldByCurrentThread(this._lockToken)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Obtained the lock on {}", this, this._lockToken);
                    }
                    this._lockService.unlock(this._lockToken);
                    boolean obtainedTheLock = true;
                    long currentTimeMs = System.currentTimeMillis();
                    long endTimeMs = currentTimeMs + 60000L;
                    boolean continueToGetLock = true;
                    while (continueToGetLock) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this._lockService.lock(this._lockToken, 1000L, -1L);
                        if (this._lockService.isHeldByCurrentThread(this._lockToken)) {
                            if (System.currentTimeMillis() <= endTimeMs) {
                                this._lockService.unlock(this._lockToken);
                                continue;
                            }
                            continueToGetLock = false;
                            continue;
                        }
                        obtainedTheLock = false;
                        break;
                    }
                    if (obtainedTheLock) {
                        this.startAsPrimary();
                    } else {
                        this.startAsSecondary();
                    }
                } else {
                    this.startAsSecondary();
                }
            }
        } else {
            this.startAsSecondary();
        }
    }

    private void startAsPrimary() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Obtained the lock on {}", this, this._lockToken);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_PRIMARY, this));
        this._primary = true;
        if (this._startupPolicy.equals("secondary")) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0_STARTING_AS_PRIMARY_BECAUSE_NO_DESIGNATED_PRIMARY_STARTED_WITHIN_1_SECONDS, new Object[]{this, 60}));
        }
    }

    private void startAsSecondary() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Did not obtain the lock on {}", this, this._lockToken);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_SECONDARY, this));
        this._primary = false;
        if (this._startupPolicy.equals("primary")) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0_CANNOT_START_AS_PRIMARY_BECAUSE_THE_LOCK_1_WAS_NOT_OBTAINED_IT_WILL_START_AS_SECONDARY_INSTEAD, new Object[]{this, this._lockToken}));
        }
        if (this.capableOfBecomingPrimary) {
            this.launchLockObtainingThread();
        }
    }

    private void initializeDistributedLockService() {
        InternalDistributedSystem distributedSystem = this._cache.getDistributedSystem();
        String dlsName = this.getDistributedLockServiceName();
        this._lockService = DistributedLockService.getServiceNamed(dlsName);
        if (this._lockService == null) {
            this._lockService = DLockService.create(dlsName, distributedSystem, true, true, true);
        }
        Assert.assertTrue(this._lockService != null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Obtained DistributedLockService: {}", this, this._lockService);
        }
    }

    private void launchLockObtainingThread() {
        this._lockObtainingThread = new Thread(this.threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Obtaining the lock on {}", GatewayHubImpl.this, GatewayHubImpl.this._lockToken);
                        }
                        GatewayHubImpl.this._lockService.lock(GatewayHubImpl.this._lockToken, -1L, -1L);
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Obtained the lock on {}", GatewayHubImpl.this, GatewayHubImpl.this._lockToken);
                        }
                        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_0_IS_BECOMING_PRIMARY_GATEWAY_HUB, GatewayHubImpl.this));
                        GatewayHubImpl.this._primary = true;
                        Object object = GatewayHubImpl.this.allGatewaysLock;
                        synchronized (object) {
                            for (int i = 0; i < GatewayHubImpl.this.allGateways.length; ++i) {
                                AbstractGateway gateway = GatewayHubImpl.this.allGateways[i];
                                gateway.becomePrimary();
                            }
                        }
                    }
                    catch (CancelException e) {
                    }
                    catch (Exception e) {
                        if (GatewayHubImpl.this.stopper.cancelInProgress() != null) break block9;
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_0_THE_THREAD_TO_OBTAIN_THE_FAILOVER_LOCK_WAS_INTERRUPTED__THIS_GATEWAY_HUB_WILL_NEVER_BECOME_THE_PRIMARY, GatewayHubImpl.this), (Throwable)e);
                    }
                }
            }
        }, "Gateway Hub Primary Lock Acquisition Thread");
        this._lockObtainingThread.setDaemon(true);
        this._lockObtainingThread.start();
    }

    @Override
    public Object getAllGatewaysLock() {
        return this.allGatewaysLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeEventIdIndex() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean gotLock = false;
        try {
            gotLock = ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().lock(META_DATA_REGION_NAME, -1L, -1L);
            if (!gotLock) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_FAILED_TO_LOCK_META_REGION_0.toLocalizedString(this));
            }
            if (isDebugEnabled) {
                logger.debug("{}: Locked the metadata region", this);
            }
            Region<String, Integer> region = this.getEventIdIndexMetaDataRegion();
            int index2 = 0;
            String messagePrefix = null;
            if (region.containsKey(this.getId())) {
                index2 = region.get(this.getId());
                if (isDebugEnabled) {
                    messagePrefix = "Using existing";
                }
            } else {
                index2 = region.size();
                region.put(this.getId(), index2);
                if (isDebugEnabled) {
                    messagePrefix = "Created new";
                }
            }
            this._eventIdIndex = index2;
            if (isDebugEnabled) {
                logger.debug("{}: {} event id index: {}", this, messagePrefix, this._eventIdIndex);
            }
            if (!gotLock) return;
        }
        catch (Throwable throwable) {
            if (!gotLock) throw throwable;
            ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().unlock(META_DATA_REGION_NAME);
            if (!isDebugEnabled) throw throwable;
            logger.debug("{}: Unlocked the metadata region", this);
            throw throwable;
        }
        ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().unlock(META_DATA_REGION_NAME);
        if (!isDebugEnabled) return;
        logger.debug("{}: Unlocked the metadata region", this);
    }

    private Region<String, Integer> getEventIdIndexMetaDataRegion() {
        if (this._eventIdIndexMetaDataRegion == null) {
            this._eventIdIndexMetaDataRegion = GatewayHubImpl.initializeEventIdIndexMetaDataRegion(this);
        }
        return this._eventIdIndexMetaDataRegion;
    }

    private static synchronized Region<String, Integer> initializeEventIdIndexMetaDataRegion(GatewayHubImpl ghi) {
        final Cache cache = ghi.getCache();
        Region<String, Integer> region = cache.getRegion(META_DATA_REGION_NAME);
        if (region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes ra = factory.create();
            HasCachePerfStats statsHolder = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(cache.getDistributedSystem(), GatewayHubImpl.META_DATA_REGION_NAME);
                }
            };
            InternalRegionArguments ira = new InternalRegionArguments().setIsUsedForMetaRegion(true).setCachePerfStatsHolder(statsHolder);
            try {
                region = ((GemFireCacheImpl)cache).createVMRegion(META_DATA_REGION_NAME, ra, ira);
            }
            catch (RegionExistsException e) {
                region = cache.getRegion(META_DATA_REGION_NAME);
            }
            catch (Exception e) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_META_REGION_CREATION_EXCEPTION_0.toLocalizedString(ghi), e);
            }
        }
        return region;
    }

    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID(newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(0, originalThreadId, this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with operation={} key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", this, clonedEvent.getOperation(), clonedEvent.getKey(), originalEventId, originalThreadId, newEventId, newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }

    public boolean getIsDBSynchronizerHub() {
        return this.hubType == 0x4000000;
    }

    boolean getSqlFabricStartedHub() {
        return this.hubType > 0x1000000;
    }

    public int getHubType() {
        return this.hubType;
    }

    private class Stopper
    extends CancelCriterion {
        final CancelCriterion stopper;

        Stopper(CancelCriterion stopper) {
            this.stopper = stopper;
        }

        @Override
        public String cancelInProgress() {
            String oops = this.stopper.cancelInProgress();
            if (oops != null) {
                return oops;
            }
            if (GatewayHubImpl.this._isRunning) {
                return null;
            }
            return LocalizedStrings.GatewayHubImpl_HAS_BEEN_STOPPED.toLocalizedString();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            RuntimeException result = this.stopper.generateCancelledException(e);
            if (result != null) {
                return result;
            }
            if (GatewayHubImpl.this._isRunning) {
                return null;
            }
            return new GatewayCancelledException(LocalizedStrings.GatewayHubImpl_HAS_BEEN_STOPPED.toLocalizedString(), e);
        }
    }
}

