/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import org.apache.logging.log4j.Logger;

public class FunctionStreamingReplyMessage
extends ReplyMessage {
    private static final Logger logger = LogService.getLogger();
    protected int msgNum;
    protected boolean lastMsg;
    protected Object result;

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, DM dm, Object result, int msgNum, boolean lastMsg) {
        FunctionStreamingReplyMessage m = new FunctionStreamingReplyMessage();
        m.processorId = processorId;
        if (exception != null) {
            m.setException(exception);
            if (logger.isDebugEnabled()) {
                logger.debug("Replying with exception: {}", m, exception);
            }
        }
        m.setRecipient(recipient);
        m.msgNum = msgNum;
        m.lastMsg = lastMsg;
        m.result = result;
        dm.putOutgoing(m);
    }

    public int getMessageNumber() {
        return this.msgNum;
    }

    public boolean isLastMessage() {
        return this.lastMsg;
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    public int getDSFID() {
        return 1204;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgNum = in.readInt();
        this.lastMsg = in.readBoolean();
        this.processorId = in.readInt();
        try {
            this.result = DataSerializer.readObject(in);
        }
        catch (Exception e) {
            NotSerializableException ioEx = new NotSerializableException();
            ioEx.initCause(e);
            throw ioEx;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgNum);
        out.writeBoolean(this.lastMsg);
        out.writeInt(this.processorId);
        try {
            DataSerializer.writeObject(this.result, out);
        }
        catch (Exception ex) {
            if (ex instanceof CancelException) {
                throw new DistributedSystemDisconnectedException(ex);
            }
            NotSerializableException ioEx = new NotSerializableException(this.result.getClass().getName());
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getClass().getName());
        buff.append("(processorId=");
        buff.append(this.processorId);
        buff.append(" from ");
        buff.append(this.getSender());
        ReplyException ex = this.getException();
        if (ex != null) {
            buff.append(" with exception ");
            buff.append(ex);
        }
        buff.append(";msgNum ");
        buff.append(this.msgNum);
        buff.append(";lastMsg=");
        buff.append(this.lastMsg);
        buff.append(")");
        return buff.toString();
    }
}

