/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class FindVersionTagOperation {
    private static final Logger logger = LogService.getLogger();

    public static VersionTag findVersionTag(LocalRegion r, EventID eventId, boolean isBulkOp) {
        DM dm = r.getDistributionManager();
        Set<InternalDistributedMember> recipients = r instanceof DistributedRegion ? ((DistributedRegion)r).getDistributionAdvisor().adviseCacheOp() : ((PartitionedRegion)r).getRegionAdvisor().adviseDataStore();
        ResultReplyProcessor processor = new ResultReplyProcessor(dm, recipients);
        FindVersionTagMessage msg = new FindVersionTagMessage(recipients, processor.getProcessorId(), r.getFullPath(), eventId, isBulkOp);
        dm.putOutgoing(msg);
        try {
            processor.waitForReplies();
        }
        catch (InterruptedException e) {
            dm.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
            return null;
        }
        return processor.getVersionTag();
    }

    public static class VersionTagReply
    extends ReplyMessage {
        VersionTag versionTag;

        VersionTagReply(VersionTag result) {
            this.versionTag = result;
        }

        public VersionTagReply() {
        }

        @Override
        public String toString() {
            return "VersionTagReply(" + this.versionTag + ")";
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.versionTag, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public int getDSFID() {
            return 6;
        }
    }

    public static class FindVersionTagMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        int processorId;
        String regionName;
        EventID eventId;
        private boolean isBulkOp;

        protected FindVersionTagMessage(Collection recipients, int processorId, String regionName, EventID eventId, boolean isBulkOp) {
            this.setRecipients(recipients);
            this.processorId = processorId;
            this.regionName = regionName;
            this.eventId = eventId;
            this.isBulkOp = isBulkOp;
        }

        public FindVersionTagMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void process(DistributionManager dm) {
            VersionTagReply reply;
            VersionTag result = null;
            try {
                LocalRegion r = this.findRegion();
                if (r == null) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("Region not found, so ignoring version tag request: {}", this);
                    return;
                }
                result = this.isBulkOp ? r.findVersionTagForClientBulkOp(this.eventId) : r.findVersionTagForClientEvent(this.eventId);
                if (result != null) {
                    result.replaceNullIDs(r.getVersionMember());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found version tag {}", result);
                }
                reply = new VersionTagReply(result);
            }
            catch (RuntimeException e) {
                logger.warn("Exception thrown while searching for a version tag", (Throwable)e);
                return;
            }
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
                return;
            }
            catch (CancelException e) {
                return;
            }
            finally {
                reply = new VersionTagReply(result);
                reply.setProcessorId(this.processorId);
                reply.setRecipient(this.getSender());
                try {
                    dm.putOutgoing(reply);
                }
                catch (CancelException e) {}
            }
        }

        private LocalRegion findRegion() {
            GemFireCacheImpl cache = null;
            try {
                cache = GemFireCacheImpl.getInstance();
                if (cache != null) {
                    return cache.getRegionByPathForProcessing(this.regionName);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getDSFID() {
            return 5;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeUTF(this.regionName);
            InternalDataSerializer.invokeToData(this.eventId, out);
            out.writeBoolean(this.isBulkOp);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.regionName = in.readUTF();
            this.eventId = new EventID();
            InternalDataSerializer.invokeFromData(this.eventId, in);
            this.isBulkOp = in.readBoolean();
        }

        @Override
        public String toString() {
            return this.getShortClassName() + "(processorId=" + this.processorId + ";region=" + this.regionName + ";eventId=" + this.eventId + ";isBulkOp=" + this.isBulkOp + ")";
        }
    }

    public static class ResultReplyProcessor
    extends ReplyProcessor21 {
        VersionTag versionTag;

        public ResultReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof VersionTagReply) {
                VersionTagReply reply = (VersionTagReply)msg;
                if (reply.versionTag != null) {
                    this.versionTag = reply.versionTag;
                    this.versionTag.replaceNullIDs(reply.getSender());
                }
            }
            super.process(msg);
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        @Override
        public boolean stillWaiting() {
            return this.versionTag == null && super.stillWaiting();
        }
    }
}

