/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EventTracker;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class EventStateHelper {
    public static void toData(DataOutput dop, Map eventState, boolean isHARegion) throws IOException {
        InternalDistributedMember myId = InternalDistributedSystem.getAnyInstance().getDistributedMember();
        Map<MemberIdentifier, Map<ThreadIdentifier, Object>> groupedThreadIds = EventStateHelper.groupThreadIds(eventState);
        LinkedList<MemberIdentifier> orderedIds = new LinkedList<MemberIdentifier>();
        HashMap<MemberIdentifier, Integer> seenIds = new HashMap<MemberIdentifier, Integer>();
        myId.writeEssentialData(dop);
        for (MemberIdentifier memberIdentifier : groupedThreadIds.keySet()) {
            if (seenIds.containsKey(memberIdentifier)) continue;
            orderedIds.add(memberIdentifier);
            seenIds.put(memberIdentifier, seenIds.size());
        }
        dop.writeInt(seenIds.size());
        for (MemberIdentifier memberIdentifier : orderedIds) {
            DataSerializer.writeByteArray(memberIdentifier.bytes, dop);
        }
        dop.writeInt(groupedThreadIds.size());
        for (Map.Entry entry : groupedThreadIds.entrySet()) {
            MemberIdentifier memberId = (MemberIdentifier)entry.getKey();
            dop.writeInt((Integer)seenIds.get(memberId));
            Map threadIdMap = (Map)entry.getValue();
            dop.writeInt(threadIdMap.size());
            Iterator i$ = threadIdMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry next2;
                Map.Entry entry2 = next2 = i$.next();
                ThreadIdentifier key2 = (ThreadIdentifier)entry2.getKey();
                dop.writeLong(key2.getThreadID());
                if (isHARegion) {
                    HARegionQueue.DispatchedAndCurrentEvents value2 = (HARegionQueue.DispatchedAndCurrentEvents)entry2.getValue();
                    InternalDataSerializer.invokeToData(value2, dop);
                    continue;
                }
                EventTracker.EventSeqnoHolder value2 = (EventTracker.EventSeqnoHolder)entry2.getValue();
                InternalDataSerializer.invokeToData(value2, dop);
            }
        }
    }

    public static Map fromData(DataInput dip, boolean isHARegion) throws IOException, ClassNotFoundException {
        InternalDistributedMember senderId = InternalDistributedMember.readEssentialData(dip);
        int numIds = dip.readInt();
        HashMap<Integer, byte[]> numberToMember = new HashMap<Integer, byte[]>();
        for (int i = 0; i < numIds; ++i) {
            numberToMember.put(i, DataSerializer.readByteArray(dip));
        }
        int size2 = dip.readInt();
        HashMap<ThreadIdentifier, HARegionQueue.DispatchedAndCurrentEvents> eventState = new HashMap<ThreadIdentifier, HARegionQueue.DispatchedAndCurrentEvents>(size2);
        for (int i = 0; i < size2; ++i) {
            int idNumber = dip.readInt();
            int subMapSize = dip.readInt();
            for (int j = 0; j < subMapSize; ++j) {
                Serializable value2;
                long threadId = dip.readLong();
                ThreadIdentifier key2 = new ThreadIdentifier((byte[])numberToMember.get(idNumber), threadId);
                if (isHARegion) {
                    value2 = new HARegionQueue.DispatchedAndCurrentEvents();
                    InternalDataSerializer.invokeFromData(value2, dip);
                    eventState.put(key2, (HARegionQueue.DispatchedAndCurrentEvents)value2);
                    continue;
                }
                value2 = new EventTracker.EventSeqnoHolder();
                InternalDataSerializer.invokeFromData(value2, dip);
                eventState.put(key2, (HARegionQueue.DispatchedAndCurrentEvents)value2);
                if (((EventTracker.EventSeqnoHolder)value2).versionTag == null) continue;
                ((EventTracker.EventSeqnoHolder)value2).versionTag.replaceNullIDs(senderId);
            }
        }
        return eventState;
    }

    private static Map<MemberIdentifier, Map<ThreadIdentifier, Object>> groupThreadIds(Map eventState) {
        HashMap<MemberIdentifier, Map<ThreadIdentifier, Object>> results = new HashMap<MemberIdentifier, Map<ThreadIdentifier, Object>>();
        Iterator i$ = eventState.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry next2;
            Map.Entry entry = next2 = i$.next();
            ThreadIdentifier key2 = (ThreadIdentifier)entry.getKey();
            MemberIdentifier memberId = new MemberIdentifier(key2.getMembershipID());
            Object value2 = entry.getValue();
            HashMap subMap = (HashMap)results.get(memberId);
            if (subMap == null) {
                subMap = new HashMap();
                results.put(memberId, subMap);
            }
            subMap.put(key2, value2);
        }
        return results;
    }

    private static class MemberIdentifier {
        private final byte[] bytes;

        public MemberIdentifier(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MemberIdentifier)) {
                return false;
            }
            MemberIdentifier other = (MemberIdentifier)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

