/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.SerializationVersions;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DistributedTombstoneOperation
extends DistributedCacheOperation {
    private final Map<VersionSource, Long> regionGCVersions;
    private TOperation op;

    public static DistributedTombstoneOperation gc(DistributedRegion region, EventID eventId) {
        RegionEventImpl rev = new RegionEventImpl(region, Operation.REGION_EXPIRE_DESTROY, null, false, region.getMyId());
        rev.setEventID(eventId);
        DistributedTombstoneOperation top = new DistributedTombstoneOperation(rev);
        top.op = TOperation.GC;
        return top;
    }

    private DistributedTombstoneOperation(RegionEventImpl rev) {
        super(rev);
        this.regionGCVersions = ((DistributedRegion)rev.getRegion()).getVersionVector().getTombstoneGCVector();
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    @Override
    boolean isOperationReliable() {
        return false;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        TombstoneMessage mssg = new TombstoneMessage();
        mssg.regionGCVersions = this.regionGCVersions;
        mssg.eventID = this.event.getEventId();
        mssg.op = this.op;
        return mssg;
    }

    @Override
    protected FilterRoutingInfo.FilterInfo getLocalFilterRouting(FilterRoutingInfo frInfo) {
        return null;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseInvalidateRegion();
    }

    public Map<VersionSource, Long> getRegionGCVersions() {
        return this.regionGCVersions;
    }

    public static class TombstoneMessage
    extends DistributedCacheOperation.CacheOperationMessage
    implements SerializationVersions {
        protected Map<VersionSource, Long> regionGCVersions;
        protected TOperation op;
        protected EventID eventID;
        private static Version[] serializationVersions = new Version[]{Version.GFE_80};

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = this.createRegionEvent(rgn);
            event.setEventID(this.eventID);
            return event;
        }

        protected RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            event.setEventID(this.eventID);
            return event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            boolean sendReply = true;
            DistributedRegion region = (DistributedRegion)event.getRegion();
            region.getCachePerfStats().incTombstoneGCCount();
            FilterRoutingInfo.FilterInfo routing = null;
            if (this.filterRouting != null) {
                routing = this.filterRouting.getFilterInfo(region.getMyId());
            }
            region.expireTombstones(this.regionGCVersions, this.eventID, routing);
            this.appliedOperation = true;
            return sendReply;
        }

        @Override
        public int getDSFID() {
            return -69;
        }

        @Override
        public Version[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.fromDataPre_GFE_8_0_0_0(in);
            this.eventID = (EventID)DataSerializer.readObject(in);
        }

        public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.op = TOperation.values()[in.readByte()];
            int count = in.readInt();
            this.regionGCVersions = new HashMap<VersionSource, Long>(count);
            boolean persistent = in.readBoolean();
            for (int i = 0; i < count; ++i) {
                VersionSource<DistributedMember> mbr;
                if (persistent) {
                    DiskStoreID id = new DiskStoreID();
                    InternalDataSerializer.invokeFromData(id, in);
                    mbr = id;
                } else {
                    mbr = InternalDistributedMember.readEssentialData(in);
                }
                this.regionGCVersions.put(mbr, in.readLong());
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            this.toDataPre_GFE_8_0_0_0(out);
            DataSerializer.writeObject(this.eventID, out);
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            VersionSource firstEntry;
            super.toData(out);
            out.writeByte(this.op.ordinal());
            out.writeInt(this.regionGCVersions.size());
            boolean persistent = false;
            if (!this.regionGCVersions.isEmpty() && (firstEntry = this.regionGCVersions.keySet().iterator().next()) instanceof DiskStoreID) {
                persistent = true;
            }
            out.writeBoolean(persistent);
            for (Map.Entry<VersionSource, Long> entry : this.regionGCVersions.entrySet()) {
                VersionSource member = entry.getKey();
                if (member instanceof DiskStoreID) {
                    InternalDataSerializer.invokeToData((DiskStoreID)member, out);
                } else {
                    ((InternalDistributedMember)member).writeEssentialData(out);
                }
                out.writeLong(entry.getValue());
            }
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; op=").append((Object)this.op);
            buff.append("; eventID=").append(this.eventID);
            buff.append("; regionGCVersions=").append(this.regionGCVersions);
        }
    }

    private static enum TOperation {
        GC;

    }
}

